/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.rcp.ui;

import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.rcp.ui.Messages;
import com.ibm.team.process.rcp.ui.ProcessAreaSelectionPart;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ProcessAreaSelectionPage
extends WizardPage {
    private ProcessAreaSelectionPart fPart;
    private Object fViewerInput = ConnectedProjectAreaRegistry.getDefault();
    private List fFilters = new ArrayList();
    private IProcessAreaSelectionValidator fValidator;
    private boolean fAllowArchived;

    public ProcessAreaSelectionPage(String title, String description, boolean allowArchived) {
        super(title);
        this.setTitle(title);
        this.setDescription(description);
        this.fAllowArchived = allowArchived;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fPart = new ProcessAreaSelectionPart(composite, this.fAllowArchived);
        this.fPart.setInput(this.fViewerInput);
        TreeViewer treeViewer = this.fPart.getTreeViewer();
        if (!this.fFilters.isEmpty()) {
            treeViewer.setFilters(this.fFilters.toArray(new ViewerFilter[this.fFilters.size()]));
        }
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IWizardContainer container = ProcessAreaSelectionPage.this.getContainer();
                if (container instanceof WizardDialog) {
                    WizardDialog dialog = (WizardDialog)container;
                    if (ProcessAreaSelectionPage.this.getWizard().canFinish()) {
                        try {
                            ProcessAreaSelectionPage.this.getWizard().performFinish();
                        }
                        finally {
                            dialog.close();
                        }
                    }
                }
            }
        });
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean areaSelected;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object firstElement = selection.getFirstElement();
                boolean bl = areaSelected = !selection.isEmpty() && firstElement instanceof IProcessArea;
                if (ProcessAreaSelectionPage.this.fValidator != null && areaSelected) {
                    String errorMessage = ProcessAreaSelectionPage.this.fValidator.validate((IProcessArea)firstElement);
                    ProcessAreaSelectionPage.this.setErrorMessage(errorMessage);
                    ProcessAreaSelectionPage.this.setPageComplete(errorMessage == null);
                } else {
                    ProcessAreaSelectionPage.this.setPageComplete(areaSelected);
                }
            }
        });
        treeViewer.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.ProcessAreaSelectionPage_0;
            }
        });
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    public void dispose() {
        this.fPart.dispose();
        super.dispose();
    }

    public IProcessArea getSelectedProcessArea() {
        return this.fPart.getSelectedProcessArea();
    }

    public TreeViewer getViewer() {
        return this.fPart.getTreeViewer();
    }

    public void setViewerInput(Object viewerInput) {
        this.fViewerInput = viewerInput;
    }

    public void addViewerFilter(ViewerFilter filter) {
        this.fFilters.add(filter);
    }

    public void setAreaSelectionValidator(IProcessAreaSelectionValidator validator) {
        this.fValidator = validator;
    }

    public static interface IProcessAreaSelectionValidator {
        public String validate(IProcessArea var1);
    }
}

