/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.rcp.ui;

import com.ibm.team.foundation.rcp.ui.util.ItemHandleComparer;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.internal.rcp.ui.ProcessAreaContentProvider;
import com.ibm.team.process.rcp.ui.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class ProcessAreaSelectionDialog
extends ElementTreeSelectionDialog {
    private boolean fAllowArchived = false;
    private boolean fShowTeamsWithNoDevelopmentLine = true;

    public ProcessAreaSelectionDialog(Shell parent, boolean teamAreasOnly) {
        this(parent, teamAreasOnly, (LabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()), new ProcessAreaContentProvider());
    }

    public ProcessAreaSelectionDialog(Shell parent, boolean teamAreasOnly, LabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, (ILabelProvider)labelProvider, contentProvider);
        if (teamAreasOnly) {
            this.setTitle(Messages.ProcessAreaSelectionDialog_0);
            this.setMessage(Messages.ProcessAreaSelectionDialog_1);
        } else {
            this.setTitle(Messages.ProcessAreaSelectionDialog_2);
            this.setMessage(Messages.ProcessAreaSelectionDialog_3);
        }
        this.setAllowMultiple(false);
        this.setComparator(new ViewerComparator());
        this.setValidator(this.getSelectionValidator(teamAreasOnly));
    }

    private ISelectionStatusValidator getSelectionValidator(final boolean teamAreasOnly) {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1) {
                    if (selection[0] instanceof ITeamArea) {
                        return new Status(0, "com.ibm.team.process.rcp.ui", "");
                    }
                    if (selection[0] instanceof IProjectArea && !teamAreasOnly) {
                        return new Status(0, "com.ibm.team.process.rcp.ui", "");
                    }
                    if (selection[0] instanceof PendingUpdateAdapter) {
                        return new Status(4, "com.ibm.team.process.rcp.ui", "");
                    }
                } else {
                    if (selection.length == 0) {
                        return new Status(4, "com.ibm.team.process.rcp.ui", "");
                    }
                    if (selection.length > 1) {
                        if (teamAreasOnly && ProcessAreaSelectionDialog.this.selectionContainsProjectArea(selection)) {
                            return new Status(4, "com.ibm.team.process.rcp.ui", Messages.ProcessAreaSelectionDialog_6);
                        }
                        return new Status(0, "com.ibm.team.process.rcp.ui", "");
                    }
                }
                return new Status(4, "com.ibm.team.process.rcp.ui", Messages.ProcessAreaSelectionDialog_4);
            }
        };
    }

    private boolean selectionContainsProjectArea(Object[] selection) {
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IProjectArea) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IProcessArea getSelectedProcessArea() {
        return (IProcessArea)this.getFirstResult();
    }

    public IProcessArea[] getSelectedProcessAreas() {
        Object[] selected = this.getResult();
        if (selected != null && selected.length > 0) {
            IProcessArea[] processAreas = new IProcessArea[selected.length];
            System.arraycopy(selected, 0, processAreas, 0, selected.length);
            return processAreas;
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.fAllowArchived) {
            final Button showArchivedButton = new Button(composite, 32);
            showArchivedButton.setText(Messages.ProcessAreaSelectionDialog_5);
            showArchivedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProcessAreaSelectionDialog.this.setFilters(showArchivedButton.getSelection(), ProcessAreaSelectionDialog.this.fShowTeamsWithNoDevelopmentLine);
                }
            });
            showArchivedButton.setFont(parent.getFont());
        }
        this.setFilters(false, this.fShowTeamsWithNoDevelopmentLine);
        this.getTreeViewer().setComparer((IElementComparer)new ItemHandleComparer());
        return composite;
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 64);
        if (this.getMessage() != null) {
            label.setText(this.getMessage());
        }
        label.setFont(composite.getFont());
        GridData data = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        return label;
    }

    private void setFilters(boolean showArchived, boolean showTeamsWithoutDevelopmentLines) {
        ProcessAreaContentProvider provider = (ProcessAreaContentProvider)this.getTreeViewer().getContentProvider();
        provider.setFilters(showArchived, showTeamsWithoutDevelopmentLines);
    }

    public void setAllowArchivedAreas(boolean allowArchived) {
        this.fAllowArchived = allowArchived;
    }

    public void setShowTeamsWithNoDevelopmentLine(boolean showTeamsWithNoDevelopmentLine) {
        this.fShowTeamsWithNoDevelopmentLine = showTeamsWithNoDevelopmentLine;
    }
}

