/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui.teamnavigator.feeds;

import com.ibm.team.feed.core.ChannelEvent;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.IChannelListener;
import com.ibm.team.feed.core.INewsListener;
import com.ibm.team.feed.core.INewsManagerListener;
import com.ibm.team.feed.core.NewsEvent;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.ui.internal.OpenFeedAction;
import com.ibm.team.foundation.common.internal.util.Dates;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.feeds.FeedContentProvider;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.feeds.FeedLabelProvider;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.feeds.Messages;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchPartSite;

public class SubscriptionsDomain
extends Domain {
    private INewsManagerListener fNewManagerListener = new INewsManagerListener(){

        public void channelAdded(final ChannelEvent event) {
            FoundationUIJob job = new FoundationUIJob(Messages.SubscriptionsDomain_ADDING_SUBSCRIPTION){

                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                    TreeViewer viewer = SubscriptionsDomain.this.fContentProvider.getViewer();
                    if (viewer != null) {
                        viewer.add(SubscriptionsDomain.this.getRoot(), (Object)event.getChannel());
                        viewer.refresh(SubscriptionsDomain.this.getRoot());
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }

        public void channelRemoved(final ChannelEvent event) {
            FoundationUIJob job = new FoundationUIJob(Messages.SubscriptionsDomain_REMOVING_SUBSCRIPTION){

                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                    TreeViewer viewer = SubscriptionsDomain.this.fContentProvider.getViewer();
                    if (viewer != null) {
                        viewer.remove((Object)event.getChannel());
                        viewer.refresh(SubscriptionsDomain.this.getRoot());
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    };
    IChannelListener fChannelListener = new IChannelListener(){

        public void channelEdited(ChannelEvent event) {
            SubscriptionsDomain.this.update(event.getChannel());
        }

        public void channelStatusChanged(ChannelEvent event) {
            SubscriptionsDomain.this.update(event.getChannel());
        }
    };
    INewsListener fNewsListener = new INewsListener(){

        public void newsReceived(NewsEvent event) {
            SubscriptionsDomain.this.update(event.getChannel());
        }

        public void newsRemoved(NewsEvent event) {
            SubscriptionsDomain.this.update(event.getChannel());
        }

        public void newsStateChanged(NewsEvent event) {
            SubscriptionsDomain.this.update(event.getChannel());
        }
    };
    private LocalResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());
    private FeedLabelProvider fLabelProvider;
    private FeedContentProvider fContentProvider;

    public SubscriptionsDomain() {
        FeedManager.getDefault().addNewsManagerListener(this.fNewManagerListener);
        FeedManager.getDefault().addChannelListener(this.fChannelListener);
        FeedManager.getDefault().addNewsListener(this.fNewsListener);
    }

    private void update(Channel channel) {
        FoundationUIJob job = new FoundationUIJob(Messages.SubscriptionsDomain_REFRESHING_FEEDS_DOMAIN){

            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                TreeViewer viewer;
                if (SubscriptionsDomain.this.fContentProvider != null && (viewer = SubscriptionsDomain.this.fContentProvider.getViewer()) != null) {
                    viewer.refresh(SubscriptionsDomain.this.getRoot());
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    @Override
    public boolean refresh(Object element) {
        if (element instanceof Channel) {
            ((Channel)element).setExplicitRefresh(true);
            FeedManager.getDefault().loadNews((Channel)element);
        } else if (element == this.getRoot()) {
            FeedManager.getDefault().loadNews(true);
        }
        return false;
    }

    @Override
    public boolean contains(Object element) {
        if (element == this.getRoot()) {
            return true;
        }
        Channel[] channels = FeedManager.getDefault().getChannels();
        int i = 0;
        while (i < channels.length) {
            if (channels[i] == element) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String getHoverMarkupForObject(Object element) {
        if (element instanceof Channel) {
            Channel channel = (Channel)element;
            if (channel.getLastError() != null) {
                return XMLString.createFromPlainText((String)channel.getLastError()).getXMLText();
            }
            NewsItem[] items = channel.getItems();
            Arrays.sort(items, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    Date d1 = ((NewsItem)arg0).getPublishDate();
                    Date d2 = ((NewsItem)arg0).getPublishDate();
                    if (d2 != null) {
                        return Dates.compareTo((Date)d2, (Date)d1);
                    }
                    return -1;
                }
            });
            if (items.length > 0) {
                StringBuffer str = new StringBuffer();
                str.append("<ul>");
                int i = 0;
                while (i < items.length) {
                    NewsItem item = items[i];
                    str.append("<li>");
                    if (!item.isIsRead()) {
                        str.append("<b>");
                    }
                    str.append(XMLString.createFromPlainText((String)item.getTitle()).getXMLText()).append("</li>");
                    if (!item.isIsRead()) {
                        str.append("</b>");
                    }
                    ++i;
                }
                str.append("<ul>");
                return str.toString();
            }
        }
        return super.getHoverMarkupForObject(element);
    }

    @Override
    public ITreePathContentProvider getContentProvider() {
        if (this.fContentProvider == null) {
            this.fContentProvider = new FeedContentProvider();
        }
        return this.fContentProvider;
    }

    @Override
    public ITreePathLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new FeedLabelProvider();
        }
        return this.fLabelProvider;
    }

    @Override
    public Object getRoot() {
        return FeedManager.getDefault();
    }

    @Override
    public boolean open(IWorkbenchPartSite site, IStructuredSelection selection) {
        if (selection.getFirstElement() == this.getRoot()) {
            return false;
        }
        OpenFeedAction action = new OpenFeedAction(selection, site.getPage());
        action.run(null);
        return true;
    }

    @Override
    public void dispose() {
        FeedManager.getDefault().removeNewsManagerListener(this.fNewManagerListener);
        this.fNewManagerListener = null;
        FeedManager.getDefault().removeChannelListener(this.fChannelListener);
        FeedManager.getDefault().removeNewsListener(this.fNewsListener);
        this.fChannelListener = null;
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
        }
        this.fLabelProvider = null;
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
        }
        this.fContentProvider = null;
        this.fResources.dispose();
    }
}

