/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui.teamnavigator.feeds;

import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.ui.internal.ImagePool;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.feeds.Messages;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class FeedLabelProvider
extends TypeLabelProvider
implements ITreePathLabelProvider {
    private static final String FEEDS_SEGMENTS = "()";
    private ResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());
    private Font fBoldItalicFont;
    private Font fItalicFont;
    private Font fBoldFont;
    private Font fDefaultFont;

    public FeedLabelProvider() {
        FontDescriptor defaultFont = JFaceResources.getFontRegistry().getDescriptor("org.eclipse.jface.defaultfont");
        this.fBoldItalicFont = (Font)this.fResources.get((DeviceResourceDescriptor)defaultFont.withStyle(3));
        this.fItalicFont = (Font)this.fResources.get((DeviceResourceDescriptor)defaultFont.withStyle(2));
        this.fBoldFont = (Font)this.fResources.get((DeviceResourceDescriptor)defaultFont.withStyle(1));
        this.fDefaultFont = (Font)this.fResources.get((DeviceResourceDescriptor)defaultFont);
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        if (element instanceof Channel) {
            Channel channel = (Channel)element;
            boolean eventFeed = "com.ibm.team.feed.core.SystemFeed".equals(channel.getCategory());
            if (channel.getLastError() != null) {
                Image baseImage = JazzResources.getImageWithDefault((ResourceManager)this.fResources, (ImageDescriptor)(eventFeed ? ImagePool.RSS_EVENT : ImagePool.RSS_NEWS));
                ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
                imageDescriptorArray[1] = ImagePool.ERROR_TICK;
                OverlayIcon icon = new OverlayIcon(ImagePool.RSS_NEWS, baseImage, imageDescriptorArray, new Point(16, 16), 17408);
                return icon;
            }
            return eventFeed ? ImagePool.RSS_EVENT : ImagePool.RSS_NEWS;
        }
        return ImagePool.RSS_NEWS;
    }

    public Font getFont(Object element) {
        if (element instanceof Channel) {
            boolean containsUnread;
            Channel channel = (Channel)element;
            boolean bl = containsUnread = channel.getUnreadCount() > 0;
            if (containsUnread && channel.isLoading()) {
                return this.fBoldItalicFont;
            }
            if (containsUnread) {
                return this.fBoldFont;
            }
            if (channel.isLoading()) {
                return this.fItalicFont;
            }
            return this.fDefaultFont;
        }
        return null;
    }

    public void dispose() {
        this.fResources.dispose();
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        this.updateLabel(label, element);
    }

    public void updateLabel(ViewerLabel label, Object element) {
        label.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResources, (ImageDescriptor)this.getImageDescriptor(element)));
        if (element instanceof Channel) {
            StringBuffer str = new StringBuffer();
            Channel channel = (Channel)element;
            str.append(channel.getTitle());
            int unreadCount = channel.getUnreadCount();
            if (unreadCount > 0) {
                str.append(NLS.bind((String)Messages.FeedLabelProvider_UNREAD_COUNT, (Object)unreadCount, (Object[])new Object[0]));
            }
            label.setText(TextProcessor.process((String)str.toString(), (String)FEEDS_SEGMENTS));
        }
    }
}

