/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui.teamnavigator.feeds;

import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.ui.internal.DeleteSubscriptionAction;
import com.ibm.team.feed.ui.internal.OpenFeedAction;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;

public class ChannelAdapterFactory
implements IAdapterFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        return new IMenuOperationTarget(){

            @Override
            public boolean canDoOperation(String actionId, IStructuredSelection selection) {
                if (selection.getFirstElement() instanceof Channel) {
                    if (IMenuOperationTarget.DELETE.equals(actionId)) {
                        return true;
                    }
                    if ("jazz.open".equals(actionId)) {
                        return true;
                    }
                    if (IMenuOperationTarget.REFRESH.equals(actionId)) {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public void doOperation(String actionId, IWorkbenchSite site, IStructuredSelection selection) {
                if (selection.getFirstElement() instanceof Channel) {
                    if (IMenuOperationTarget.DELETE.equals(actionId)) {
                        DeleteSubscriptionAction del = new DeleteSubscriptionAction(site);
                        del.selectionChanged(null, (ISelection)selection);
                        del.run(null);
                    }
                    if ("jazz.open".equals(actionId)) {
                        OpenFeedAction open = new OpenFeedAction(selection, site.getPage());
                        open.run(null);
                    }
                    if (IMenuOperationTarget.REFRESH.equals(actionId)) {
                        for (Channel next : selection) {
                            next.setExplicitRefresh(true);
                            FeedManager.getDefault().loadNews(next);
                        }
                    }
                }
            }

            @Override
            public String getLabel(String actionId) {
                return null;
            }
        };
    }

    public Class[] getAdapterList() {
        return new Class[]{IMenuOperationTarget.class};
    }
}

