/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites;

import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesManager;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.EditFavoritesFolderDialog;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.Messages;
import java.io.IOException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class RenameFavoritesFolderAction
implements IObjectActionDelegate {
    private FavoritesFolder fFolder;
    private IWorkbenchPart fWorkbenchPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchPart = targetPart;
    }

    public void run(IAction action) {
        EditFavoritesFolderDialog dialog = new EditFavoritesFolderDialog(this.fWorkbenchPart.getSite().getShell(), this.fFolder.getParent(), Messages.RenameFavoritesFolderAction_RENAME_FAVORITES_FOLDER, Messages.RenameFavoritesFolderAction_NEW_FOLDER_NAME, this.fFolder.getText());
        if (dialog.open() == 0) {
            try {
                String newName = dialog.getText();
                FavoritesManager.getInstance().renameFolder(this.fFolder, newName);
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)this.fWorkbenchPart.getSite().getShell(), (String)Messages.RenameFavoritesFolderAction_ERROR_STORING_FAVORITES_TITLE, (String)Messages.RenameFavoritesFolderAction_ERROR_STORING_FAVORITES_DESCRIPTION);
                ProcessRCPUIPlugin.getDefault().log("An error occured while storing favorites", e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection strsel;
        if (selection instanceof IStructuredSelection && (strsel = (IStructuredSelection)selection).size() == 1) {
            this.fFolder = (FavoritesFolder)strsel.getFirstElement();
            action.setEnabled(this.fFolder != FavoritesManager.getInstance().getFavorites());
        }
    }
}

