/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites;

import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesManager;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode;
import com.ibm.team.process.internal.rcp.ui.DomainSelection;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.Messages;
import com.ibm.team.repository.common.util.NLS;
import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public class RemoveFavoritesAction
extends Action {
    private IStructuredSelection fSelection;
    private IWorkbenchSite fWorkbenchSite;

    public RemoveFavoritesAction(IWorkbenchSite site, IStructuredSelection selection) {
        super(Messages.RemoveFavoritesAction_REMOVE_FAVORITES);
        this.selectionChanged((ISelection)selection);
        this.fWorkbenchSite = site;
    }

    public void run() {
        HashSet<String> nonEmptyFolders = new HashSet<String>();
        for (FavoritesNode node : this.fSelection) {
            FavoritesFolder folder;
            if (!(node instanceof FavoritesFolder) || (folder = (FavoritesFolder)node).getChildren().size() <= 0) continue;
            nonEmptyFolders.add(folder.getText());
        }
        if (!nonEmptyFolders.isEmpty()) {
            String message;
            int size = nonEmptyFolders.size();
            if (size == 1) {
                message = NLS.bind((String)Messages.RemoveFavoritesAction_CONFIRM_SINGLE_FOLDER, nonEmptyFolders.iterator().next(), (Object[])new Object[0]);
            } else if (size < 5) {
                String folderList = "";
                for (String name : nonEmptyFolders) {
                    String folderName = NLS.bind((String)Messages.RemoveFavoritesAction_PATTERN_FOLDER_NAME, (Object)name, (Object[])new Object[0]);
                    folderList = folderList.length() == 0 ? folderName : NLS.bind((String)Messages.RemoveFavoritesAction_PATTERN_FOLDER_LIST, (Object)folderList, (Object[])new Object[]{folderName});
                }
                message = NLS.bind((String)Messages.RemoveFavoritesAction_CONFIRM_FOLDER_LIST, (Object)folderList, (Object[])new Object[0]);
            } else {
                message = Messages.RemoveFavoritesAction_CONFIRM_SOME_FOLDERS;
            }
            boolean confirm = MessageDialog.openConfirm((Shell)this.fWorkbenchSite.getShell(), (String)Messages.RemoveFavoritesAction_REMOVE_FAVORITES, (String)message);
            if (!confirm) {
                return;
            }
        }
        FavoritesManager.getInstance().removeFavorites(this.fSelection.toList());
    }

    private void selectionChanged(ISelection selection) {
        this.fSelection = selection instanceof DomainSelection ? ((DomainSelection)selection).getOriginal() : (IStructuredSelection)selection;
        for (Object object : this.fSelection) {
            if (object instanceof FavoritesNode) {
                FavoritesNode next = (FavoritesNode)object;
                if (next != FavoritesManager.getInstance().getFavorites()) continue;
                this.setEnabled(false);
                return;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

