/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites;

import com.ibm.team.foundation.common.util.WildcardMatcher;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

class PatternFilter
extends ViewerFilter {
    private Map<Object, Object> fCache = new HashMap<Object, Object>();
    private Map<Object, Object> fFoundAnyCache = new HashMap<Object, Object>();
    private boolean fUseCache = true;
    private boolean fIncludeLeadingWildcard = true;
    private WildcardMatcher fMatcher;
    private boolean fUseEarlyReturnIfMatcherIsNull = true;
    private static Object[] EMPTY = new Object[0];

    PatternFilter() {
    }

    public final Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        if (this.fMatcher == null && this.fUseEarlyReturnIfMatcherIsNull) {
            return elements;
        }
        if (!this.fUseCache) {
            return super.filter(viewer, parent, elements);
        }
        Object[] filtered = (Object[])this.fCache.get(parent);
        if (filtered == null) {
            Boolean foundAny = (Boolean)this.fFoundAnyCache.get(parent);
            filtered = foundAny != null && foundAny == false ? EMPTY : super.filter(viewer, parent, elements);
            this.fCache.put(parent, filtered);
        }
        return filtered;
    }

    private boolean isAnyVisible(Viewer viewer, Object parent, Object[] elements) {
        if (this.fMatcher == null) {
            return true;
        }
        if (!this.fUseCache) {
            return this.computeAnyVisible(viewer, elements);
        }
        Object[] filtered = (Object[])this.fCache.get(parent);
        if (filtered != null) {
            return filtered.length > 0;
        }
        Boolean foundAny = (Boolean)this.fFoundAnyCache.get(parent);
        if (foundAny == null) {
            foundAny = this.computeAnyVisible(viewer, elements) ? Boolean.TRUE : Boolean.FALSE;
            this.fFoundAnyCache.put(parent, foundAny);
        }
        return foundAny;
    }

    private boolean computeAnyVisible(Viewer viewer, Object[] elements) {
        boolean elementFound = false;
        int i = 0;
        while (i < elements.length && !elementFound) {
            Object element = elements[i];
            elementFound = this.isElementVisible(viewer, element);
            ++i;
        }
        return elementFound;
    }

    public final boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.isElementVisible(viewer, element);
    }

    public void setPattern(String patternString) {
        if ("org.eclipse.ui.keys.optimization.true".equals(patternString)) {
            this.fUseEarlyReturnIfMatcherIsNull = true;
            return;
        }
        if ("org.eclipse.ui.keys.optimization.false".equals(patternString)) {
            this.fUseEarlyReturnIfMatcherIsNull = false;
            return;
        }
        this.clearCaches();
        if (patternString == null || patternString.equals("")) {
            this.fMatcher = null;
        } else {
            String pattern = String.valueOf(patternString) + "*";
            if (this.fIncludeLeadingWildcard) {
                pattern = "*" + pattern;
            }
            this.fMatcher = new WildcardMatcher(pattern, true, false);
        }
    }

    void clearCaches() {
        this.fCache.clear();
        this.fFoundAnyCache.clear();
    }

    private boolean match(String string) {
        if (this.fMatcher == null) {
            return true;
        }
        return this.fMatcher.match(string);
    }

    public boolean isElementSelectable(Object element) {
        return element != null;
    }

    public boolean isElementVisible(Viewer viewer, Object element) {
        return this.isParentMatch(viewer, element) || this.isLeafMatch(viewer, element);
    }

    protected boolean isParentMatch(Viewer viewer, Object element) {
        TreePath path = new TreePath(new Object[]{element});
        Object[] children = ((ITreePathContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(path);
        if (children != null && children.length > 0) {
            return this.isAnyVisible(viewer, element, children);
        }
        return false;
    }

    protected boolean isLeafMatch(Viewer viewer, Object element) {
        if (element instanceof FavoritesFolder) {
            return false;
        }
        String labelText = ((ILabelProvider)((StructuredViewer)viewer).getLabelProvider()).getText(element);
        if (labelText == null) {
            return false;
        }
        return this.wordMatches(labelText);
    }

    private String[] getWords(String text) {
        ArrayList<String> words = new ArrayList<String>();
        BreakIterator iter = BreakIterator.getWordInstance();
        iter.setText(text);
        int i = iter.first();
        while (i != -1 && i < text.length()) {
            int j = iter.following(i);
            if (j == -1) {
                j = text.length();
            }
            if (Character.isLetterOrDigit(text.charAt(i))) {
                String word = text.substring(i, j);
                words.add(word);
            }
            i = j;
        }
        return words.toArray(new String[words.size()]);
    }

    protected boolean wordMatches(String text) {
        if (text == null) {
            return false;
        }
        if (this.match(text)) {
            return true;
        }
        String[] words = this.getWords(text);
        int i = 0;
        while (i < words.length) {
            String word = words[i];
            if (this.match(word)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

