/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesManager;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode;
import com.ibm.team.foundation.rcp.core.internal.favorites.IFavoritesListener;
import com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite;
import com.ibm.team.foundation.rcp.ui.internal.favorites.FavoritesContentProvider;
import com.ibm.team.foundation.rcp.ui.internal.favorites.FavoritesLabelProvider;
import com.ibm.team.foundation.rcp.ui.internal.favorites.IViewerSettable;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.FavoritesAdapterFactory;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.Messages;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.PatternFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.progress.UIJob;

public class FavoritesSelectionPopupDialog
extends PopupDialog {
    private static final String SETTINGS = "FavoritesSelectionPopupDialog";
    private static final long FILTER_DELAY = 200L;
    private StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((ILabelProvider)new FavoritesLabelProvider(), (IElementRemovedNotifier)new ElementRemovedNotifierImpl()){

        public void updateLabel(ViewerLabel label, Object element) {
            URIFavorite favorite;
            super.updateLabel(label, element);
            if (element instanceof URIFavorite && ((favorite = (URIFavorite)element).getText() == null || !favorite.getText().equals(label.getText()))) {
                favorite.setText(label.getText());
                FavoritesManager.getInstance().deferredStore();
            }
        }
    };
    private IFavoritesListener fFavoritesListener = new IFavoritesListener(){

        public void favoritesAdded(final List nodes) {
            FoundationUIJob job = new FoundationUIJob(Messages.FavoritesSelectionPopupDialog_COMPUTING_LABELS){

                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                    HashSet<FavoritesFolder> parents = new HashSet<FavoritesFolder>();
                    for (FavoritesNode node : nodes) {
                        parents.add(node.getParent());
                    }
                    FavoritesSelectionPopupDialog.this.internalRefresh(parents);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }

        public void favoritesRemoved(List nodes) {
            HashSet<FavoritesFolder> parents = new HashSet<FavoritesFolder>();
            for (FavoritesNode node : nodes) {
                parents.add(node.getParent());
            }
            FavoritesSelectionPopupDialog.this.internalRefresh(parents);
        }

        public void favoritesChanged(List nodes) {
            FavoritesSelectionPopupDialog.this.internalRefresh(nodes);
        }
    };
    private TreeViewer fViewer;
    private Text fFilterInput;
    private PatternFilter fFilter;
    private FavoritesContentProvider fContentProvider;
    private final IWorkbenchPage fPage;
    private DecoratingLabelProvider fLabelProvider;
    private UIJob fFilterJob;

    public FavoritesSelectionPopupDialog(Shell parent, IWorkbenchPage page) {
        super(parent, 0, true, true, true, true, true, null, null);
        this.fPage = page;
        this.registerListeners();
    }

    private void registerListeners() {
        FavoritesManager.getInstance().addListener(this.fFavoritesListener);
    }

    private void unregisterListeners() {
        FavoritesManager.getInstance().removeListener(this.fFavoritesListener);
    }

    private void internalRefresh(final Collection nodes) {
        if (nodes.isEmpty()) {
            return;
        }
        new FoundationUIJob(Messages.FavoritesSelectionPopupDialog_APPLYING_CHANGES){

            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                if (FavoritesSelectionPopupDialog.this.fViewer == null || FavoritesSelectionPopupDialog.this.fViewer.getControl().isDisposed()) {
                    return Status.OK_STATUS;
                }
                ArrayList<URIFavorite> toResolve = new ArrayList<URIFavorite>();
                for (Object next : nodes) {
                    URIFavorite favorite;
                    if (next instanceof URIFavorite && (favorite = (URIFavorite)next).getModelInstance() == null && FavoritesManager.getInstance().canResolve(favorite.uri())) {
                        toResolve.add(favorite);
                    }
                    FavoritesSelectionPopupDialog.this.fViewer.refresh(next, true);
                }
                FavoritesSelectionPopupDialog.this.resolve(toResolve);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void resolve(final List<FavoritesNode> favorites) {
        if (favorites.isEmpty()) {
            return;
        }
        new FoundationJob(Messages.FavoritesSelectionPopupDialog_RESOLVING){

            protected IStatus runProtected(IProgressMonitor monitor) {
                FavoritesManager.getInstance().resolveModelObjects(favorites, monitor);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings all = ProcessRCPUIPlugin.getDefault().getDialogSettings();
        IDialogSettings result = all.getSection(SETTINGS);
        if (result == null) {
            result = new DialogSettings(SETTINGS);
            all.addSection(result);
        }
        return result;
    }

    protected Control createTitleControl(Composite parent) {
        Composite titleArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        titleArea.setLayout((Layout)layout);
        titleArea.setLayoutData((Object)new GridData(768));
        Font font = parent.getFont();
        this.fFilterInput = new Text(titleArea, 0);
        this.fFilterInput.setFont(font);
        GridData gd = new GridData(4, 0x1000000, true, false);
        this.fFilterInput.setLayoutData((Object)gd);
        this.fFilterInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FavoritesSelectionPopupDialog.this.onSearch();
            }
        });
        this.fFilterInput.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    FavoritesSelectionPopupDialog.this.fViewer.getControl().setFocus();
                }
            }
        });
        this.fFilterInput.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 4: {
                        FavoritesSelectionPopupDialog.this.onOpen();
                    }
                }
            }
        });
        return titleArea;
    }

    public boolean close() {
        this.unregisterListeners();
        this.dispose();
        return super.close();
    }

    private void dispose() {
        if (this.fFilterJob != null) {
            this.fFilterJob.cancel();
        }
        this.fStandardLabelProvider.dispose();
        this.fLabelProvider.dispose();
        this.fContentProvider.dispose();
    }

    private void onSearch() {
        if (this.fFilterJob != null) {
            this.fFilterJob.cancel();
        }
        this.fFilterJob = new UIJob(this.getShell().getDisplay(), Messages.FavoritesSelectionPopupDialog_FILTERING){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!monitor.isCanceled() && !FavoritesSelectionPopupDialog.this.fFilterInput.isDisposed()) {
                    String pattern = FavoritesSelectionPopupDialog.this.fFilterInput.getText();
                    FavoritesSelectionPopupDialog.this.fFilter.setPattern(pattern);
                    FavoritesSelectionPopupDialog.this.fViewer.refresh(false);
                    if (pattern.length() > 0) {
                        FavoritesSelectionPopupDialog.this.fViewer.expandAll();
                        FavoritesSelectionPopupDialog.this.selectFirstResult();
                    } else {
                        FavoritesSelectionPopupDialog.this.fViewer.expandToLevel(2);
                        FavoritesSelectionPopupDialog.this.fViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        this.fFilterJob.setSystem(true);
        this.fFilterJob.setUser(false);
        this.fFilterJob.schedule(200L);
    }

    private void selectFirstResult() {
        TreeItem[] items;
        if (this.fViewer == null || this.fViewer.getControl().isDisposed()) {
            return;
        }
        Tree tree = this.fViewer.getTree();
        TreeItem[] treeItemArray = items = tree.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (this.selectFirstResult(item)) break;
            ++n2;
        }
    }

    private boolean selectFirstResult(TreeItem item) {
        TreeItem[] childitems;
        TreeItem[] treeItemArray = childitems = item.getItems();
        if (childitems.length != 0) {
            TreeItem childitem = treeItemArray[0];
            return this.selectFirstResult(childitem);
        }
        Object data = item.getData();
        if (data instanceof URIFavorite) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(data));
            return true;
        }
        return false;
    }

    protected Control getFocusControl() {
        return this.fFilterInput;
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        result.setLayout((Layout)layout);
        result.setFont(font);
        FontMetrics fontMetrics = null;
        GC gc = null;
        try {
            gc = new GC((Drawable)result);
            gc.setFont(font);
            fontMetrics = gc.getFontMetrics();
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        int width = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)60);
        int height = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)15);
        this.createViewer(result, width, height);
        result.setLayoutData((Object)new GridData(1808));
        return result;
    }

    private void createViewer(Composite result, int width, int height) {
        this.fViewer = new TreeViewer(result, 768);
        this.fViewer.getTree().setBackground(result.getBackground());
        this.fViewer.setAutoExpandLevel(2);
        GridData gd = new GridData(1808);
        gd.widthHint = width;
        gd.heightHint = height;
        Tree tree = this.fViewer.getTree();
        tree.setLayoutData((Object)gd);
        this.fContentProvider = new FavoritesContentProvider(new IViewerSettable(){

            public void setViewer(TreeViewer viewer) {
            }
        });
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fLabelProvider = new DecoratingLabelProvider((ILabelProvider)this.fStandardLabelProvider, null);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.setSorter((ViewerSorter)new FavoritesContentProvider.FavoritesSorter());
        this.fFilter = new PatternFilter();
        this.fViewer.addFilter((ViewerFilter)this.fFilter);
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                FavoritesSelectionPopupDialog.this.onOpen();
            }
        });
        this.fViewer.setInput((Object)FavoritesManager.getInstance().getFavorites());
    }

    private void onOpen() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (!selection.isEmpty()) {
            this.close();
            IWorkbenchPart activePart = this.fPage.getActivePart();
            FavoritesAdapterFactory.open((IWorkbenchSite)(activePart != null ? activePart.getSite() : null), selection);
        }
    }
}

