/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites;

import com.ibm.team.collaboration.core.meeting.CollaborationData;
import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.ui.CollaborationUI;
import com.ibm.team.collaboration.ui.context.ICollaborationContextProvider;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.IModelAccessor;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesManager;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode;
import com.ibm.team.foundation.rcp.core.internal.favorites.IFavoritesListener;
import com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite;
import com.ibm.team.foundation.rcp.ui.internal.favorites.FavoritesContentProvider;
import com.ibm.team.foundation.rcp.ui.internal.favorites.FavoritesLabelProvider;
import com.ibm.team.foundation.rcp.ui.internal.favorites.IViewerSettable;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.AddFavoritesFolderAction;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.Messages;
import com.ibm.team.process.rcp.ui.teamnavigator.Category;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FavoritesDomainImplementation
implements IViewerSettable,
IShellProvider {
    private TreeViewer fViewer;
    private ITreePathLabelProvider fLabelProvider;
    private FavoritesLabelProvider fModelAccessorAwareLabelProvider = new FavoritesLabelProvider(){
        private StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());

        public String getText(Object element) {
            String text;
            IModelAccessor modelAccessor;
            Object modelInstance;
            if (element instanceof IModelAccessor && (modelInstance = (modelAccessor = (IModelAccessor)element).getModelInstance()) != null && (text = this.fStandardLabelProvider.getText(modelInstance)) != null && text.length() > 0) {
                return text;
            }
            return super.getText(element);
        }
    };
    private StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((ILabelProvider)this.fModelAccessorAwareLabelProvider, (IElementRemovedNotifier)new ElementRemovedNotifierImpl()){

        public void updateLabel(ViewerLabel label, Object element) {
            URIFavorite favorite;
            super.updateLabel(label, element);
            if (element instanceof URIFavorite && ((favorite = (URIFavorite)element).getText() == null || !favorite.getText().equals(label.getText()))) {
                favorite.setText(label.getText());
                FavoritesManager.getInstance().deferredStore();
            }
        }

        public void invokeDecorators(ViewerLabel label, Object element) {
            String text = label.getText();
            super.invokeDecorators(label, element);
            label.setText(text);
        }
    };
    private ITreePathContentProvider fContentProvider;
    private IViewerSettable fViewerSettable;
    IFavoritesListener fListener = new IFavoritesListener(){

        public void favoritesAdded(final List nodes) {
            new FoundationUIJob(Messages.FavoritesDomainImplementation_COMPUTING_LABELS_JOB_NAME){

                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                    HashSet<FavoritesFolder> parents = new HashSet<FavoritesFolder>();
                    for (FavoritesNode node : nodes) {
                        parents.add(node.getParent());
                    }
                    FavoritesDomainImplementation.this.internalRefresh(parents, nodes);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }

        public void favoritesRemoved(List nodes) {
            HashSet<FavoritesFolder> parents = new HashSet<FavoritesFolder>();
            for (FavoritesNode node : nodes) {
                parents.add(node.getParent());
            }
            FavoritesDomainImplementation.this.internalRefresh(parents, null);
        }

        public void favoritesChanged(List nodes) {
            FavoritesDomainImplementation.this.internalRefresh(nodes, null);
        }
    };
    ISelectionProvider fFavoritesSelectionProvider = new ISelectionProvider(){

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            FavoritesDomainImplementation.this.fViewer.addSelectionChangedListener(listener);
        }

        public ISelection getSelection() {
            IStructuredSelection selection = (IStructuredSelection)FavoritesDomainImplementation.this.fViewer.getSelection();
            ArrayList<Object> converted = new ArrayList<Object>();
            for (Object next : selection) {
                Object convert;
                if (next == (convert = FavoritesDomainImplementation.this.convertToModel(next))) continue;
                converted.add(convert);
            }
            return new StructuredSelection(converted);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            FavoritesDomainImplementation.this.fViewer.removeSelectionChangedListener(listener);
        }

        public void setSelection(ISelection selection) {
        }
    };
    private IWorkbenchPart fWorkbenchPart;
    private ViewerSorter fSorter;

    public FavoritesDomainImplementation(IViewerSettable settable) {
        this.fViewerSettable = settable;
        FavoritesManager.getInstance().addListener(this.fListener);
    }

    public Object convertToModel(Object next) {
        URIFavorite favorite;
        if (next instanceof URIFavorite && (favorite = (URIFavorite)next).getModelInstance() != null) {
            return favorite.getModelInstance();
        }
        return next;
    }

    public ViewerSorter getSorter() {
        if (this.fSorter == null) {
            this.fSorter = new FavoritesContentProvider.FavoritesSorter();
        }
        return this.fSorter;
    }

    public void dispose() {
        FavoritesManager.getInstance().removeListener(this.fListener);
        try {
            FavoritesManager.getInstance().store();
        }
        catch (IOException e) {
            ProcessRCPUIPlugin.getDefault().log("Error while storing favorites", e);
        }
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
        }
        this.fLabelProvider = null;
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
        }
        this.fContentProvider = null;
        this.fStandardLabelProvider.dispose();
    }

    public void setViewer(TreeViewer viewer) {
        this.fViewer = viewer;
        this.fViewerSettable.setViewer(this.fViewer);
    }

    public void configure(IWorkbenchPart part, Category category, IConnectedProjectAreaRegistry registry) {
    }

    public boolean contains(Object element) {
        return element instanceof FavoritesNode;
    }

    public ITreePathContentProvider getContentProvider() {
        if (this.fContentProvider == null) {
            this.fContentProvider = new FavoritesContentProvider((IViewerSettable)this);
        }
        return this.fContentProvider;
    }

    public ITreePathLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new DecoratingLabelProvider((ILabelProvider)this.fStandardLabelProvider, null);
        }
        return this.fLabelProvider;
    }

    public Object getRoot() {
        return FavoritesManager.getInstance().getFavorites();
    }

    public boolean validateDrop(Object target, IStructuredSelection selection, IStructuredSelection originalSelection, int operation) {
        FavoritesFolder newParent;
        FavoritesManager favoritesManager = FavoritesManager.getInstance();
        if (target instanceof FavoritesFolder) {
            newParent = (FavoritesFolder)target;
        } else if (target instanceof FavoritesNode) {
            newParent = ((FavoritesNode)target).getParent();
        } else {
            return false;
        }
        for (Object next : selection) {
            if (!favoritesManager.canAddToFavorites(next)) {
                return false;
            }
            if (!(next instanceof FavoritesNode) || !favoritesManager.parentPathContainsNode(newParent, (FavoritesNode)next)) continue;
            return false;
        }
        return true;
    }

    public int getSupportedOperationsForSelection(IStructuredSelection selection) {
        boolean isOnlyFavorite = true;
        for (Object next : selection) {
            if (next == this.getRoot()) {
                return 0;
            }
            if (next instanceof FavoritesNode) continue;
            isOnlyFavorite = false;
        }
        if (isOnlyFavorite) {
            return 2;
        }
        return 4;
    }

    public boolean performDrop(final Object target, final IStructuredSelection structuredSelection, final IStructuredSelection originalSelection, int operation) {
        new FoundationJob(Messages.FavoritesDomainImplementation_DROPPING_INTO_FAVORITES_JOB_NAME){

            protected IStatus runProtected(IProgressMonitor monitor) {
                ArrayList<Object> itemsToAdd;
                URIFavorite below;
                FavoritesFolder parent;
                IContributorHandle contributor = null;
                if (target instanceof URIFavorite) {
                    URIFavorite favorite = (URIFavorite)target;
                    if ("com.ibm.team.repository.Contributor".equals(favorite.getFavoriteType())) {
                        try {
                            Object object;
                            String uri = favorite.getUri();
                            if (uri != null && !"".equals(uri) && (object = Hyperlinks.resolve((URI)new URI(uri), null, (IProgressMonitor)monitor)) instanceof IContributorHandle) {
                                contributor = (IContributorHandle)object;
                            }
                        }
                        catch (CoreException exception) {
                            IStatus status = exception.getStatus();
                            if (status != null && status.getException() instanceof PermissionDeniedException) {
                                FavoritesDomainImplementation.this.openPermissionDeniedDialog(Messages.FavoritesDomainImplementation_CONTRIBUTOR);
                                return Status.OK_STATUS;
                            }
                        }
                        catch (URISyntaxException exception) {
                            // empty catch block
                        }
                    }
                    parent = favorite.getParent();
                    below = favorite;
                } else {
                    parent = (FavoritesFolder)target;
                    below = null;
                }
                if (originalSelection == null) {
                    itemsToAdd = structuredSelection.toList();
                } else {
                    itemsToAdd = new ArrayList<Object>(structuredSelection.size());
                    Object[] structuredArray = structuredSelection.toArray();
                    Object[] originalArray = originalSelection.toArray();
                    int i = 0;
                    while (i < structuredArray.length) {
                        if (originalArray[i] instanceof FavoritesNode) {
                            itemsToAdd.add(originalArray[i]);
                        } else {
                            itemsToAdd.add(structuredArray[i]);
                        }
                        ++i;
                    }
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (contributor != null) {
                    final Set<Object> contributors = Collections.singleton(contributor);
                    final ArrayList collection = new ArrayList(structuredSelection.size());
                    final Iterator iterator = structuredSelection.iterator();
                    FoundationJob job = new FoundationJob(Messages.FavoritesDomainImplementation_CONTACT_CONTRIBUTORS_JOB_NAME){

                        protected IStatus runProtected(IProgressMonitor monitor) {
                            while (iterator.hasNext()) {
                                URIReference reference = Hyperlinks.create(iterator.next(), (IProgressMonitor)monitor);
                                if (reference == null) continue;
                                collection.add(reference);
                            }
                            return CollaborationUI.contactContributors((IWorkbenchPart)FavoritesDomainImplementation.this.fWorkbenchPart, (Collection)contributors, (ICollaborationContextProvider)new ICollaborationContextProvider(){

                                public Collection<URIReference> getTopics(Collection<CollaborationUser> users, IProgressMonitor monitor) {
                                    return collection;
                                }

                                public CollaborationData getContext(Collection<CollaborationUser> users, IProgressMonitor monitor) {
                                    return null;
                                }
                            }, (IProgressMonitor)monitor);
                        }
                    };
                    job.setSystem(true);
                    job.schedule();
                    return Status.OK_STATUS;
                }
                List addedItems = FavoritesManager.getInstance().addItemsToFavorites(parent, itemsToAdd, (FavoritesNode)below, monitor);
                FavoritesDomainImplementation.notifyDuplicates(FavoritesDomainImplementation.this.getShell(), itemsToAdd, addedItems);
                FavoritesDomainImplementation.this.resolve(addedItems);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return false;
    }

    public void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        FoundationUIUtils.contributeObjectActions((IWorkbenchPart)this.fWorkbenchPart, (IMenuManager)manager, (ISelectionProvider)this.fFavoritesSelectionProvider);
        if (selection.size() == 1 && selection.getFirstElement() instanceof FavoritesFolder) {
            manager.appendToGroup("jazz.new.group", (IAction)new AddFavoritesFolderAction(this.fViewer, this, selection));
        }
    }

    public void setWorkbenchPart(IWorkbenchPart workbenchPart) {
        this.fWorkbenchPart = workbenchPart;
    }

    public Shell getShell() {
        if (this.fWorkbenchPart == null) {
            return null;
        }
        return this.fWorkbenchPart.getSite().getShell();
    }

    public static void notifyDuplicates(final Shell shell, final List toadd, final List added) {
        if (shell == null) {
            return;
        }
        if (Display.getCurrent() != null) {
            FavoritesDomainImplementation.internalNotifyDuplicates(shell, toadd, added);
        } else {
            FoundationUIJob job = new FoundationUIJob(Messages.FavoritesDomainImplementation_NOTIFY_DUPLICATE_JOB_NAME){

                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                    FavoritesDomainImplementation.internalNotifyDuplicates(shell, toadd, added);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    private static void internalNotifyDuplicates(Shell shell, List toadd, List added) {
        if (added.size() < toadd.size()) {
            int notAdded = toadd.size() - added.size();
            String msg = notAdded == 1 ? Messages.FavoritesDomainImplementation_ONE_EXISTING : NLS.bind((String)Messages.FavoritesDomainImplementation_MORE_THAN_ONE_EXISTING_FORMAT, (Object)notAdded, (Object[])new Object[0]);
            String title = Messages.FavoritesDomainImplementation_PREVENTING_DUPLICATES_DIALOG_TITLE;
            MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
        }
        int exceptions = 0;
        for (Object item : added) {
            if (!(item instanceof URIFavorite) || !(((URIFavorite)item).getModelInstance() instanceof Exception)) continue;
            ++exceptions;
        }
        if (exceptions == 1) {
            MessageDialog.openWarning((Shell)shell, (String)Messages.FavoritesDomainImplementation_ADD_ITEM_FAVORITES_ERROR, (String)Messages.FavoritesDomainImplementation_ADD_ITEM_FAVORITES_ERROR_DETAIL);
        } else if (exceptions > 1) {
            MessageDialog.openWarning((Shell)shell, (String)Messages.FavoritesDomainImplementation_ADD_ITEMS_FAVORITES_ERROR, (String)Messages.FavoritesDomainImplementation_ADD_ITEMS_FAVORITES_ERROR_DETAIL);
        }
    }

    private void resolve(final List<FavoritesNode> favorites) {
        if (favorites.isEmpty()) {
            return;
        }
        new FoundationJob(Messages.FavoritesDomainImplementation_RESOLVING_FAVORITES_JOB_NAME){

            protected IStatus runProtected(IProgressMonitor monitor) {
                FavoritesManager.getInstance().resolveModelObjects(favorites, monitor);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void internalRefresh(final Collection nodes, final List<?> reveal) {
        if (nodes.isEmpty()) {
            return;
        }
        new FoundationUIJob(Messages.FavoritesDomainImplementation_APPLYING_CHANGES_JOB_NAME){

            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                if (FavoritesDomainImplementation.this.fViewer == null || FavoritesDomainImplementation.this.fViewer.getControl().isDisposed()) {
                    return Status.OK_STATUS;
                }
                ArrayList<URIFavorite> toResolve = new ArrayList<URIFavorite>();
                for (Object next : nodes) {
                    URIFavorite favorite;
                    if (next instanceof URIFavorite && (favorite = (URIFavorite)next).getModelInstance() == null && FavoritesManager.getInstance().canResolve(favorite.uri())) {
                        toResolve.add(favorite);
                    }
                    FavoritesDomainImplementation.this.fViewer.refresh(next, true);
                }
                FavoritesDomainImplementation.this.resolve(toResolve);
                if (reveal != null && !reveal.isEmpty()) {
                    FavoritesDomainImplementation.this.fViewer.setSelection((ISelection)new StructuredSelection(reveal), true);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void openPermissionDeniedDialog(final String typeName) {
        if (Display.getCurrent() == null) {
            FoundationUIJob job = new FoundationUIJob(NLS.bind((String)Messages.FavoritesDomainImplementation_PERMISSION_DENIED_OPEN, (Object)typeName, (Object[])new Object[0])){

                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                    FavoritesDomainImplementation.this.openPermissionDeniedDialogInUI(typeName);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        } else {
            this.openPermissionDeniedDialog(typeName);
        }
    }

    private void openPermissionDeniedDialogInUI(String typeName) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null && workbench.getWorkbenchWindowCount() > 0) {
            window = workbench.getWorkbenchWindows()[0];
        }
        String message = NLS.bind((String)Messages.FavoritesDomainImplementation_PERMISSION_DENIED_OPEN, (Object)typeName, (Object[])new Object[0]);
        MessageDialog.openInformation((Shell)(window != null ? window.getShell() : null), (String)Messages.FavoritesDomainImplementation_PERMISSION_DENIED, (String)message);
    }
}

