/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesManager;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode;
import com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.process.internal.rcp.ui.DomainNavigator;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.Messages;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.RemoveFavoritesAction;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.RenameFavoritesFolderAction;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FavoritesAdapterFactory
implements IAdapterFactory {
    public static boolean open(final IWorkbenchSite site, final IStructuredSelection selection) {
        boolean opened = true;
        FoundationJob job = new FoundationJob(Messages.FavoritesAdapterFactory_OPEN_FAVORITES){

            protected IStatus runProtected(IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * selection.size()));
                StandardContextProvider context = new StandardContextProvider(null);
                Object shellProvider = null;
                shellProvider = site != null ? site : FoundationUIUtils.getShellProvider();
                if (shellProvider != null) {
                    context.setUIContext((Object)shellProvider.getShell());
                    for (Object object : selection) {
                        if (object instanceof FavoritesFolder) continue;
                        if (object instanceof URIFavorite) {
                            URIFavorite favorite = (URIFavorite)object;
                            IStatus status = Hyperlinks.open((URI)favorite.uri(), (ContextProvider)context, (IProgressMonitor)subMonitor.newChild(2));
                            if (status.isOK()) continue;
                            Throwable exception = status.getException();
                            if (exception instanceof ItemNotFoundException) {
                                FavoritesAdapterFactory.openInformation(Messages.FavoritesAdapterFactory_OPEN, Messages.FavoritesAdapterFactory_NOT_FOUND);
                                return Status.OK_STATUS;
                            }
                            if (exception instanceof PermissionDeniedException) {
                                FavoritesAdapterFactory.openInformation(Messages.FavoritesAdapterFactory_OPEN, Messages.FavoritesAdapterFactory_PERMISSION_DENIED);
                                return Status.OK_STATUS;
                            }
                            return status;
                        }
                        URIReference reference = Hyperlinks.create(object, (IProgressMonitor)subMonitor.newChild(1));
                        SubMonitor child = subMonitor.newChild(1);
                        if (reference != null) {
                            Hyperlinks.open((URI)reference.getURI(), (ContextProvider)context, (IProgressMonitor)child);
                            continue;
                        }
                        FavoritesAdapterFactory.openInformation(Messages.FavoritesAdapterFactory_OPEN, Messages.FavoritesAdapterFactory_NOT_FOUND);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return opened;
    }

    private static void openInformation(final String title, final String message) {
        if (Display.getCurrent() == null) {
            FoundationUIJob job = new FoundationUIJob(message){

                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                    FavoritesAdapterFactory.openItemNotFoundDialogInUI(title, message);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        } else {
            FavoritesAdapterFactory.openItemNotFoundDialogInUI(title, message);
        }
    }

    private static void openItemNotFoundDialogInUI(String title, String message) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null && workbench.getWorkbenchWindowCount() > 0) {
            window = workbench.getWorkbenchWindows()[0];
        }
        MessageDialog.openInformation((Shell)(window != null ? window.getShell() : null), (String)title, (String)message);
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof FavoritesNode && IMenuOperationTarget.class.isAssignableFrom(adapterType)) {
            return new FavoritesOperationTarget();
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IMenuOperationTarget.class};
    }

    private static class FavoritesOperationTarget
    implements IMenuOperationTarget {
        private FavoritesOperationTarget() {
        }

        @Override
        public boolean canDoOperation(String actionId, IStructuredSelection selection) {
            if (selection.getFirstElement() instanceof URIFavorite && "jazz.open".equals(actionId)) {
                return true;
            }
            if (IMenuOperationTarget.DELETE.equals(actionId)) {
                return new RemoveFavoritesAction(null, selection).isEnabled();
            }
            if (IMenuOperationTarget.REFRESH.equals(actionId)) {
                return true;
            }
            if ("jazz.rename".equals(actionId) && selection.toList().size() == 1 && selection.getFirstElement() instanceof FavoritesFolder) {
                Action action = new Action(){};
                RenameFavoritesFolderAction actionDelegate = new RenameFavoritesFolderAction();
                actionDelegate.selectionChanged((IAction)action, (ISelection)selection);
                return action.isEnabled();
            }
            return false;
        }

        @Override
        public void doOperation(String actionId, IWorkbenchSite site, IStructuredSelection selection) {
            Action action;
            if ("jazz.open".equals(actionId)) {
                FavoritesAdapterFactory.open(site, selection);
            }
            if (IMenuOperationTarget.DELETE.equals(actionId)) {
                action = new RemoveFavoritesAction(site, selection);
                action.run();
            }
            if (IMenuOperationTarget.REFRESH.equals(actionId)) {
                final ArrayList<FavoritesNode> favorites = new ArrayList<FavoritesNode>();
                for (Object next : selection) {
                    DomainNavigator navigator;
                    TreeViewer treeViewer;
                    IWorkbenchPart part;
                    FavoritesFolder folder;
                    List children;
                    ArrayList toadd = new ArrayList();
                    toadd.add(next);
                    if (next instanceof FavoritesFolder && (children = (folder = (FavoritesFolder)next).getChildren()).size() > 0 && (part = ((IWorkbenchPartSite)site).getPart()) instanceof DomainNavigator && (treeViewer = (navigator = (DomainNavigator)part).getTreeViewer()).getExpandedState((Object)folder)) {
                        toadd.addAll(children);
                    }
                    for (Object object : toadd) {
                        if (!(object instanceof FavoritesNode)) continue;
                        favorites.add((FavoritesNode)object);
                    }
                }
                FoundationJob job = new FoundationJob(Messages.FavoritesAdapterFactory_REFRESHING_FAVORITES_JOB_NAME){

                    protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                        FavoritesManager.getInstance().resolveModelObjects(favorites, true, monitor);
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
            if ("jazz.rename".equals(actionId)) {
                action = new Action(){};
                RenameFavoritesFolderAction actionDelegate = new RenameFavoritesFolderAction();
                actionDelegate.setActivePart((IAction)action, site.getPage().getActivePart());
                actionDelegate.selectionChanged((IAction)action, (ISelection)selection);
                if (action.isEnabled()) {
                    actionDelegate.run((IAction)action);
                }
            }
        }

        @Override
        public String getLabel(String actionId) {
            if (IMenuOperationTarget.DELETE.equals(actionId)) {
                return Messages.FavoritesAdapterFactory_REMOVE_FAVORITES;
            }
            return null;
        }
    }
}

