/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites;

import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.Messages;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditFavoritesFolderDialog
extends StatusDialog {
    private final IStatus fgAlreadyExistsStatus = new Status(4, "com.ibm.team.process.rcp.ui", 0, Messages.EditFavoritesFolderDialog_FAVORITE_ALREADY_EXISTS_MESSAGE, null);
    private final IStatus fgEmptyNameStatus = new Status(4, "com.ibm.team.process.rcp.ui", 0, "", null);
    private HashSet<String> fNameSet = new HashSet();
    private String fDefaultText;
    private String fMessage;
    private Text fText;
    private String fResult;
    private String fTitle;

    public EditFavoritesFolderDialog(Shell parent, FavoritesFolder parentFolder, String title, String message, String defaultText) {
        super(parent);
        this.fTitle = title;
        this.fDefaultText = defaultText;
        this.fResult = defaultText == null ? "" : defaultText;
        this.fMessage = message;
        this.fillNameSet(parentFolder);
    }

    public boolean isHelpAvailable() {
        return false;
    }

    private void fillNameSet(FavoritesFolder folder) {
        List children = folder.getChildren();
        for (FavoritesNode child : children) {
            this.fNameSet.add(child.getText());
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fTitle != null) {
            shell.setText(this.fTitle);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite diagArea = (Composite)super.createDialogArea(parent);
        if (this.fMessage != null) {
            Label label = new Label(diagArea, 64);
            label.setText(this.fMessage);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        this.fText = new Text(diagArea, 2052);
        this.fText.setText(this.fDefaultText);
        this.fText.selectAll();
        this.fText.setLayoutData((Object)new GridData(768));
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditFavoritesFolderDialog.this.updateStatus();
            }
        });
        this.updateStatus();
        EditFavoritesFolderDialog.applyDialogFont((Control)diagArea);
        return diagArea;
    }

    private void updateStatus() {
        this.fResult = this.fText.getText().trim();
        if (this.fNameSet.contains(this.fResult)) {
            this.updateStatus(this.fgAlreadyExistsStatus);
        } else if ("".equals(this.fResult)) {
            this.updateStatus(this.fgEmptyNameStatus);
        } else {
            this.updateStatus(Status.OK_STATUS);
        }
    }

    public String getText() {
        return this.fResult;
    }
}

