/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites;

import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesManager;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode;
import com.ibm.team.foundation.rcp.ui.internal.favorites.FavoritesContentProvider;
import com.ibm.team.foundation.rcp.ui.internal.favorites.FavoritesLabelProvider;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.internal.rcp.ui.HelpContextIds;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.AddFavoritesFolderAction;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class ChooseFavoriteDialog
extends TrayDialog {
    private static final String SETTINGS_ID = "com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.ChooseFavoriteDialog";
    private static final String TITLE = Messages.ChooseFavoriteDialog_ADD_TO_FAVORITES_TITLE;
    private static final String MESSAGE = Messages.ChooseFavoriteDialog_SELECT_TARGET_MESSAGE;
    private static final Object INPUT = new Object();
    private IStructuredSelection fSelection;
    private Label fMessage;
    private StandardLabelProvider fLabelProvider;
    private ISelectionChangedListener fSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelection() instanceof IStructuredSelection) {
                ChooseFavoriteDialog.this.fSelection = (IStructuredSelection)event.getSelection();
            }
        }
    };
    private IDoubleClickListener fDoubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            if (event.getSelection() instanceof IStructuredSelection) {
                ChooseFavoriteDialog.this.fSelection = (IStructuredSelection)event.getSelection();
                ChooseFavoriteDialog.this.okPressed();
            }
        }
    };
    private DisposeListener fDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            ChooseFavoriteDialog.this.fLabelProvider.dispose();
        }
    };
    private TreeViewer fViewer;

    public ChooseFavoriteDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(TITLE);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings dialogSettings = ProcessRCPUIPlugin.getDefault().getDialogSettings();
        IDialogSettings settingsSection = dialogSettings.getSection(SETTINGS_ID);
        if (settingsSection != null) {
            return settingsSection;
        }
        return dialogSettings.addNewSection(SETTINGS_ID);
    }

    protected int getDialogBoundsStrategy() {
        return 2;
    }

    public void create() {
        super.create();
        Rectangle bounds = this.getContents().getBounds();
        Point preferred = this.getContents().computeSize(-1, -1);
        if (preferred.x < bounds.width) {
            preferred.x = bounds.width;
        }
        if (preferred.y < bounds.height) {
            preferred.y = bounds.height;
        }
        this.getShell().setSize(preferred);
        ((Composite)this.getContents()).layout();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        parent.addDisposeListener(this.fDisposeListener);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 250;
        gridData.widthHint = 400;
        area.setLayoutData((Object)gridData);
        this.fMessage = new Label(area, 64);
        this.fMessage.setLayoutData((Object)new GridData(768));
        this.fMessage.setText(MESSAGE);
        Tree tree = new Tree(area, 2052);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fViewer = new TreeViewer(tree);
        this.fViewer.addSelectionChangedListener(this.fSelectionListener);
        this.fViewer.addDoubleClickListener(this.fDoubleClickListener);
        this.fViewer.setContentProvider((IContentProvider)new ChooserContentProvider());
        this.fLabelProvider = new StandardLabelProvider((ILabelProvider)new FavoritesLabelProvider(), (IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.setSorter((ViewerSorter)new FavoritesContentProvider.FavoritesSorter());
        FavoritesNode root = FavoritesManager.getInstance().getFavorites();
        this.fViewer.setInput(INPUT);
        this.fViewer.setSelection((ISelection)new StructuredSelection((Object)root));
        this.fViewer.expandAll();
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new Action(Messages.ChooseFavoriteDialog_NEW_FOLDER_ACTION){

            public void run() {
                ChooseFavoriteDialog.this.onNewFolder();
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.fViewer.getTree());
        this.fViewer.getTree().setMenu(menu);
        Button newFolder = new Button(area, 8);
        newFolder.setText(Messages.ChooseFavoriteDialog_NEW_FOLDER_ACTION);
        newFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseFavoriteDialog.this.onNewFolder();
            }
        });
        HelpContextIds.hookHelpListener((Control)parent, "com.ibm.team.process.rcp.ui.add_favorite_dialog");
        ChooseFavoriteDialog.applyDialogFont((Control)area);
        this.setButtonLayoutData(newFolder);
        ((GridData)newFolder.getLayoutData()).grabExcessHorizontalSpace = false;
        ((GridData)newFolder.getLayoutData()).horizontalAlignment = 1;
        return area;
    }

    private void onNewFolder() {
        IStructuredSelection sel = (IStructuredSelection)this.fViewer.getSelection();
        if (!sel.isEmpty()) {
            new AddFavoritesFolderAction(this.fViewer, (IShellProvider)this, sel).run();
            this.fViewer.refresh();
        }
    }

    protected void okPressed() {
        if (this.fSelection != null && this.fSelection.size() == 1 || ((FavoritesFolder)FavoritesManager.getInstance().getFavorites()).getChildren().isEmpty()) {
            super.okPressed();
        }
    }

    public FavoritesNode getResult() {
        if (((FavoritesFolder)FavoritesManager.getInstance().getFavorites()).getChildren().isEmpty()) {
            return FavoritesManager.getInstance().getFavorites();
        }
        return (FavoritesNode)this.fSelection.getFirstElement();
    }

    private class ChooserContentProvider
    extends FavoritesContentProvider {
        public ChooserContentProvider() {
            super(null);
        }

        public Object[] getChildren(TreePath parentPath) {
            Object parent = parentPath.getLastSegment();
            if (parent == INPUT) {
                return new Object[]{FavoritesManager.getInstance().getFavorites()};
            }
            return super.getChildren(parentPath);
        }
    }
}

