/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites;

import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.foundation.rcp.core.internal.HyperlinkHandlerRegistry;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesManager;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode;
import com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite;
import com.ibm.team.process.internal.rcp.ui.DomainSelection;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.ChooseFavoriteDialog;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.FavoritesDomainImplementation;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class AddItemToFavoritesAction
implements IAdapterFactory,
IObjectActionDelegate {
    private IStructuredSelection fSelection;
    private IWorkbenchPart fWorkbenchPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchPart = targetPart;
    }

    public void run(IAction action) {
        ChooseFavoriteDialog dialog = new ChooseFavoriteDialog(this.fWorkbenchPart.getSite().getShell());
        if (dialog.open() == 0) {
            final FavoritesNode result = dialog.getResult();
            try {
                final ArrayList added = new ArrayList();
                final ArrayList items = new ArrayList();
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        FavoritesNode below;
                        FavoritesFolder parent;
                        monitor.beginTask(Messages.AddItemToFavoritesAction_ADDING_ITEMS_TO_FAVORITES, AddItemToFavoritesAction.this.fSelection.size());
                        if (result instanceof FavoritesFolder) {
                            parent = (FavoritesFolder)result;
                            below = null;
                        } else {
                            parent = result.getParent();
                            below = result;
                        }
                        Iterator iterator = AddItemToFavoritesAction.this.fSelection.iterator();
                        while (iterator.hasNext()) {
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            items.add(iterator.next());
                            monitor.worked(1);
                        }
                        List internaladded = FavoritesManager.getInstance().addItemsToFavorites(parent, items, below, monitor);
                        added.addAll(internaladded);
                    }
                });
                FavoritesDomainImplementation.notifyDuplicates(this.fWorkbenchPart.getSite().getShell(), items, added);
            }
            catch (InvocationTargetException e) {
                ProcessRCPUIPlugin.getDefault().log("Error while adding items to favorites", e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof DomainSelection) {
            IStructuredSelection origsel = ((DomainSelection)selection).getOriginal();
            for (Object next : origsel) {
                if (!(next instanceof URIFavorite)) continue;
                action.setEnabled(false);
                return;
            }
        }
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
            for (Object next : this.fSelection) {
                HyperlinkHandler createHandler = HyperlinkHandlerRegistry.getDefault().getCreateHandler(next);
                if (createHandler != null) continue;
                action.setEnabled(false);
                return;
            }
            action.setEnabled(true);
        }
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        return this;
    }

    public Class[] getAdapterList() {
        return new Class[]{IObjectActionDelegate.class};
    }
}

