/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites;

import com.ibm.team.foundation.rcp.core.internal.favorites.Favorite;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesManager;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode;
import com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.EditFavoritesFolderDialog;
import com.ibm.team.process.internal.rcp.ui.teamnavigator.favorites.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;

public class AddFavoritesFolderAction
extends Action {
    private IShellProvider fShellProvider;
    private IStructuredSelection fSelection;
    private TreeViewer fViewer;

    public AddFavoritesFolderAction(TreeViewer viewer, IShellProvider shellProvider, IStructuredSelection selection) {
        super(Messages.AddFavoritesFolderAction_NEW_FOLDER);
        this.fViewer = viewer;
        this.fShellProvider = shellProvider;
        this.fSelection = selection;
        if (this.fSelection.size() == 1) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void run() {
        EditFavoritesFolderDialog dialog;
        FavoritesNode node = (FavoritesNode)this.fSelection.getFirstElement();
        FavoritesFolder parent = null;
        FavoritesNode below = null;
        if (node instanceof Favorite) {
            Favorite favorite = (Favorite)node;
            parent = favorite.getParent();
            below = node;
        } else if (node instanceof URIFavorite) {
            parent = node.getParent();
            below = node;
        } else if (node instanceof FavoritesFolder) {
            parent = (FavoritesFolder)node;
        }
        if (parent != null && (dialog = new EditFavoritesFolderDialog(this.fShellProvider.getShell(), parent, Messages.AddFavoritesFolderAction_NEW_FAVORITES_FOLDER, Messages.AddFavoritesFolderAction_ENTER_FOLDER_NAME, Messages.AddFavoritesFolderAction_UNTITLED_FOLDER)).open() == 0) {
            String foldername = dialog.getText();
            FavoritesFolder newFolder = FavoritesManager.getInstance().addFolder(parent, foldername, below);
            if (newFolder == null) {
                MessageDialog.openWarning((Shell)this.fShellProvider.getShell(), (String)Messages.AddFavoritesFolderAction_FOLDER_EXISTS_TITLE, (String)Messages.AddFavoritesFolderAction_FOLDER_EXISTS_MESSAGE);
                return;
            }
            if (this.fViewer != null && !this.fViewer.getControl().isDisposed()) {
                this.fViewer.expandToLevel((Object)parent, 1);
            }
        }
    }
}

