/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.HistoryCombo;
import com.ibm.team.process.rcp.ui.ILoginInfoUIProvider;
import com.ibm.team.process.rcp.ui.IUIValidationCallback;
import com.ibm.team.process.rcp.ui.Messages;
import com.ibm.team.repository.client.ILoginInfo2;
import com.ibm.team.repository.client.SavedPasswordNotObtainedException;
import com.ibm.team.repository.client.login.UsernameAndPasswordLoginInfo;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.Preferences;

public class UserAndPassLoginInfoUIPart
implements ILoginInfoUIProvider {
    private Preferences dialogPrefs = this.getConfigPrefs().node("dialog");
    private HistoryCombo userIdText;
    private Text passwordText;
    private String userValue = null;
    private String passwordValue = null;
    private static final String EMPTY_STRING = "";

    @Override
    public Control createContents(Composite parent, final IUIValidationCallback validationCallback) {
        Composite userAndPassComposite = new Composite(parent, 0);
        final Label userID = new Label(userAndPassComposite, 0);
        userID.setText(Messages.RepositoryCreationPart_11);
        this.userIdText = new HistoryCombo(userAndPassComposite, this.dialogPrefs.node("userId"), false);
        this.userIdText.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = NLS.bind((String)Messages.UserAndPassLoginInfoUIPart_0, (Object)userID.getText());
            }
        });
        Label password = new Label(userAndPassComposite, 0);
        password.setText(Messages.RepositoryCreationPart_13);
        this.passwordText = new Text(userAndPassComposite, 0x400804);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(userAndPassComposite);
        ControlDecoration fUserIdDecoration = new ControlDecoration(this.userIdText.getControl(), 16512);
        fUserIdDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage());
        fUserIdDecoration.show();
        this.userIdText.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Combo combo = UserAndPassLoginInfoUIPart.this.userIdText.getCombo();
                UserAndPassLoginInfoUIPart.this.userValue = combo.getText();
                UserAndPassLoginInfoUIPart.this.userIdText.addToHistory();
                if (validationCallback != null) {
                    validationCallback.validate();
                }
            }
        });
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UserAndPassLoginInfoUIPart.this.passwordValue = UserAndPassLoginInfoUIPart.this.passwordText.getText();
                if (validationCallback != null) {
                    validationCallback.validate();
                }
            }
        });
        return userAndPassComposite;
    }

    @Override
    public ILoginInfo2 getLoginInfo() {
        UsernameAndPasswordLoginInfo userAndPass = new UsernameAndPasswordLoginInfo(this.userValue, this.passwordValue);
        return userAndPass;
    }

    private Preferences getConfigPrefs() {
        IEclipsePreferences prefs = new InstanceScope().getNode("com.ibm.team.process.rcp.ui");
        Preferences edilogPrefs = prefs.node(this.getClass().getName());
        return edilogPrefs;
    }

    @Override
    public boolean isValid() {
        return this.userIdText != null && !this.userIdText.getCombo().isDisposed() && this.userIdText.getCombo().getText() != null && this.passwordText != null && !this.passwordText.isDisposed() && this.passwordText.getText() != null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public IStatus getValidationStatus() {
        if (!this.userIdText.getCombo().isDisposed() && !this.isUserIdValid()) {
            return new Status(4, "com.ibm.team.process.rcp.ui", Messages.RepositoryCreationPart_19);
        }
        return null;
    }

    private boolean isUserIdValid() {
        String userId = this.userIdText.getCombo().getText();
        return userId.trim().length() > 0;
    }

    @Override
    public void populate(ILoginInfo2 loginInfo) {
        this.populate(loginInfo, true);
    }

    @Override
    public void populate(ILoginInfo2 loginInfo, boolean rememberPassword) {
        if (loginInfo != null) {
            UsernameAndPasswordLoginInfo usernameAndPass = (UsernameAndPasswordLoginInfo)loginInfo;
            this.userValue = usernameAndPass.getUsername();
            String storedPassword = EMPTY_STRING;
            try {
                storedPassword = usernameAndPass.getPassword();
            }
            catch (SavedPasswordNotObtainedException savedPasswordNotObtainedException) {
                // empty catch block
            }
            this.passwordValue = rememberPassword ? storedPassword : EMPTY_STRING;
            this.setUserIdTextValue(this.userValue);
            this.setPasswordTextValue(this.passwordValue);
        } else {
            this.clear();
        }
    }

    @Override
    public void clear() {
        this.setUserIdTextValue(EMPTY_STRING);
        this.setPasswordTextValue(EMPTY_STRING);
    }

    private void setUserIdTextValue(String value) {
        boolean comboIsValid;
        boolean bl = comboIsValid = this.userIdText != null && !this.userIdText.getCombo().isDisposed();
        if (value != null && comboIsValid) {
            this.userIdText.getCombo().setText(value);
        }
    }

    private void setPasswordTextValue(String value) {
        boolean passwordTextIsValid;
        boolean bl = passwordTextIsValid = this.passwordText != null && !this.passwordText.isDisposed();
        if (value != null && passwordTextIsValid) {
            this.passwordText.setText(value);
        }
    }
}

