/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.foundation.rcp.core.PasswordUtil;
import com.ibm.team.process.internal.rcp.ui.LoginAction;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.repository.client.IDeferredSecuredLoginInfo;
import com.ibm.team.repository.client.ILoginInfo2;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.SavedPasswordNotObtainedException;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.internal.LoginInfoElementDescriptor;
import com.ibm.team.repository.client.internal.LoginInfoExtensionReader;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class TeamRepositoryPersistanceManager {
    private static final String PREF_REPOSITORIES = "repositories";
    private RegistryListener fRegistryListener = new RegistryListener();

    public TeamRepositoryPersistanceManager() {
        this.read();
        TeamPlatform.getTeamRepositoryService().addGenericListener((Object)PREF_REPOSITORIES, (IListener)this.fRegistryListener);
    }

    private synchronized void save() {
        Preferences serverPrefs = this.getPreferencesFor(PREF_REPOSITORIES);
        if (serverPrefs == null) {
            return;
        }
        try {
            serverPrefs.removeNode();
            serverPrefs = this.getPreferencesFor(PREF_REPOSITORIES);
            ITeamRepository[] servers = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            int i = 0;
            while (i < servers.length) {
                ITeamRepository repo = servers[i];
                Preferences prefs = serverPrefs.node("" + i);
                prefs.put("uri", repo.getRepositoryURI());
                prefs.put("name", this.ensureNotNull(repo.getName()));
                UUID id = repo.getId();
                if (id != null) {
                    prefs.put("id", id.getUuidValue());
                }
                Collection aliasRepositoryURIs = repo.getAliasRepositoryURIs();
                int index = 0;
                Iterator j = aliasRepositoryURIs.iterator();
                while (j.hasNext()) {
                    prefs.put("aliasRepositoryURIs" + index, (String)j.next());
                    ++index;
                }
                prefs.putBoolean("autoLogin", repo.getAutoLogin());
                prefs.putBoolean("savePassword", repo.getSavePassword());
                prefs.put("userId", this.ensureNotNull(repo.getUserId()));
                prefs.putInt("timeout", repo.getConnectionTimeout());
                if (repo.getLoginInfo() != null) {
                    prefs.put("authentication-id", repo.getLoginInfo().getId());
                    Properties properties = repo.getLoginInfo().getLoginProperties();
                    this.addPropertiesToPreferences(properties, prefs);
                }
                ++i;
            }
            serverPrefs.flush();
        }
        catch (BackingStoreException e) {
            ProcessRCPUIPlugin.getDefault().log(Messages.TeamRepositoryPersistanceManager_0, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() {
        ArrayList<ITeamRepository> toAutoLogin = new ArrayList<ITeamRepository>();
        TeamRepositoryPersistanceManager teamRepositoryPersistanceManager = this;
        synchronized (teamRepositoryPersistanceManager) {
            Preferences serverPrefs = this.getPreferencesFor(PREF_REPOSITORIES);
            if (serverPrefs == null) {
                return;
            }
            try {
                String key;
                int i = 0;
                while (serverPrefs.nodeExists(key = Integer.toString(i))) {
                    Preferences prefs = serverPrefs.node(key);
                    String uri = prefs.get("uri", null);
                    if (uri != null) {
                        String aliasRepositoryURI;
                        ITeamRepository teamRepository = TeamPlatform.getTeamRepositoryService().getTeamRepository(uri);
                        teamRepository.setAutoLogin(prefs.getBoolean("autoLogin", false));
                        teamRepository.setSavePassword(prefs.getBoolean("savePassword", false));
                        teamRepository.setName(this.ensureNotEmpty(prefs.get("name", Messages.TeamRepositoryPersistanceManager_1)));
                        String id = prefs.get("id", null);
                        if (id != null) {
                            teamRepository.setId(UUID.valueOf((String)id));
                        }
                        int j = 0;
                        while ((aliasRepositoryURI = prefs.get("aliasRepositoryURIs" + j, null)) != null) {
                            teamRepository.addAliasRepositoryURI(aliasRepositoryURI);
                            ++j;
                        }
                        teamRepository.setUserId(this.ensureNotEmpty(prefs.get("userId", Messages.TeamRepositoryPersistanceManager_2)));
                        teamRepository.setConnectionTimeout(prefs.getInt("timeout", 60));
                        ILoginInfo2 loginInfo = teamRepository.getLoginInfo();
                        if (loginInfo == null) {
                            LoginInfoElementDescriptor descriptor;
                            String authid;
                            String defaultAuthId = null;
                            LoginInfoElementDescriptor defaultDescriptor = LoginInfoExtensionReader.INSTANCE.getDefaultDescriptor();
                            if (defaultDescriptor != null) {
                                loginInfo = defaultDescriptor.createImplementation();
                                defaultAuthId = loginInfo.getId();
                            }
                            if ((authid = prefs.get("authentication-id", defaultAuthId)) != null && (descriptor = LoginInfoExtensionReader.INSTANCE.getDescriptor(authid)) != null) {
                                loginInfo = descriptor.createImplementation();
                            }
                        }
                        if (loginInfo != null) {
                            Properties properties = this.convertPreferencesToProperties(prefs);
                            loginInfo.setLoginProperties(properties);
                            if (loginInfo instanceof IDeferredSecuredLoginInfo) {
                                ((IDeferredSecuredLoginInfo)loginInfo).setSecuredLoginPropertiesCallback((IDeferredSecuredLoginInfo.ISecuredLoginPropertiesCallback)new DeferredSecureLoginPropertiesCallback(teamRepository));
                            } else {
                                PasswordUtil.populateSavedPassword((ITeamRepository)teamRepository, (ILoginInfo2)loginInfo);
                            }
                            teamRepository.setLoginInfo(loginInfo);
                        }
                        if (teamRepository.getAutoLogin()) {
                            toAutoLogin.add(teamRepository);
                        }
                        teamRepository.addGenericListener((Object)teamRepository, (IListener)this.fRegistryListener);
                        TeamPlatform.getTeamRepositoryService().addTeamRepository(teamRepository);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                ProcessRCPUIPlugin.getDefault().log(Messages.TeamRepositoryPersistanceManager_3, e);
            }
        }
        if (toAutoLogin.size() > 0) {
            LoginAction.runHeadless(toAutoLogin);
        }
    }

    private Properties convertPreferencesToProperties(Preferences prefs) {
        Properties properties = new Properties();
        if (prefs != null) {
            try {
                String[] keys;
                String[] stringArray = keys = prefs.keys();
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    String value = prefs.get(key, null);
                    properties.setProperty(key, value);
                    ++n2;
                }
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
        return properties;
    }

    private void addPropertiesToPreferences(Properties properties, Preferences preferences) {
        if (properties != null && preferences != null) {
            Set<Object> keys = properties.keySet();
            for (Object k : keys) {
                preferences.put((String)k, properties.getProperty((String)k));
            }
        }
    }

    private String ensureNotEmpty(String string) {
        return string == null || string.trim().length() > 0 ? string : null;
    }

    private Preferences getPreferencesFor(String pref) {
        Preferences serverPrefs = new InstanceScope().getNode("com.ibm.team.process.rcp.ui").node(pref);
        return serverPrefs;
    }

    private String ensureNotNull(String string) {
        return string == null ? "" : string;
    }

    public void dispose() {
        this.save();
        TeamPlatform.getTeamRepositoryService().removeGenericListener((Object)PREF_REPOSITORIES, (IListener)this.fRegistryListener);
        ITeamRepository[] teamRepositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < teamRepositories.length) {
            ITeamRepository teamRepository = teamRepositories[i];
            teamRepository.removeGenericListener((Object)teamRepository, (IListener)this.fRegistryListener);
            ++i;
        }
    }

    class DeferredSecureLoginPropertiesCallback
    implements IDeferredSecuredLoginInfo.ISecuredLoginPropertiesCallback {
        private ITeamRepository repo = null;

        public DeferredSecureLoginPropertiesCallback(ITeamRepository repo) {
            this.repo = repo;
        }

        public void fetchSecuredLoginProperties(ILoginInfo2 loginInfo) throws SavedPasswordNotObtainedException {
            PasswordUtil.populateSavedPassword((ITeamRepository)this.repo, (ILoginInfo2)loginInfo);
        }
    }

    private class RegistryListener
    implements IListener {
        private RegistryListener() {
        }

        public void handleEvents(List events) {
            for (IPropertyChangeEvent event : events) {
                this.handleEvent(event);
            }
        }

        private void handleEvent(IPropertyChangeEvent event) {
            if (this.shouldSave(event)) {
                TeamRepositoryPersistanceManager.this.save();
            }
            if (event.getProperty() == TeamRepositoryPersistanceManager.PREF_REPOSITORIES) {
                Object oldValue;
                if (event.getEventType() == "com.ibm.team.repository.PropertyAdd") {
                    Object newValue = event.getNewValue();
                    if (newValue instanceof ITeamRepository) {
                        ITeamRepository teamRepository = (ITeamRepository)newValue;
                        teamRepository.addGenericListener((Object)teamRepository, (IListener)this);
                    }
                } else if (event.getEventType() == "com.ibm.team.repository.PropertyRemove" && (oldValue = event.getOldValue()) instanceof ITeamRepository) {
                    ITeamRepository teamRepository = (ITeamRepository)oldValue;
                    teamRepository.removeGenericListener((Object)teamRepository, (IListener)this);
                }
            }
        }

        private boolean shouldSave(IPropertyChangeEvent event) {
            return event.getProperty() != "state" && event.getProperty() != "error_state";
        }
    }
}

