/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.rcp.ui.ILoginInfoUIProvider;
import com.ibm.team.process.rcp.ui.IUIValidationCallback;
import com.ibm.team.repository.client.ILoginInfo2;
import com.ibm.team.repository.client.login.SmartCardLoginInfo;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class SmartCardLoginInfoUIProvider
implements ILoginInfoUIProvider {
    private String selectedAlias = null;
    private ListViewer viewer;

    @Override
    public Control createContents(Composite parent, IUIValidationCallback validationCallback) {
        Composite composite = new Composite(parent, 0);
        new Label(composite, 0).setText(Messages.SmartCardLoginInfoUIProvider_0);
        this.createAliasList(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(composite);
        return composite;
    }

    private void createAliasList(Composite parent) {
        this.viewer = new ListViewer(parent, 2564);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.viewer.getList());
        this.viewer.setContentProvider((IContentProvider)new AliasSelectionContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AliasSelectionLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SmartCardLoginInfoUIProvider.this.selectedAlias = (String)((IStructuredSelection)event.getSelection()).getFirstElement();
            }
        });
        List<String> aliases = this.getAliases();
        this.viewer.setInput(aliases);
    }

    private List<String> getAliases() {
        SmartCardLoginInfo info = new SmartCardLoginInfo();
        return info.getAliases();
    }

    @Override
    public void dispose() {
    }

    @Override
    public IStatus getValidationStatus() {
        return null;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public ILoginInfo2 getLoginInfo() {
        return new SmartCardLoginInfo(this.selectedAlias);
    }

    @Override
    public void populate(ILoginInfo2 loginInfo) {
        this.populate(loginInfo, true);
    }

    @Override
    public void populate(ILoginInfo2 loginInfo, boolean rememberPassword) {
        String loginAlias;
        SmartCardLoginInfo smartCardLoginInfo = (SmartCardLoginInfo)loginInfo;
        Properties loginProperties = smartCardLoginInfo.getLoginProperties();
        this.selectedAlias = loginAlias = loginProperties.getProperty("userId");
        this.updateListSelection();
    }

    private void updateListSelection() {
        Object element;
        if (this.selectedAlias == null || this.viewer == null) {
            return;
        }
        int index = 0;
        while ((element = this.viewer.getElementAt(index++)) != null) {
            String elementString = (String)element;
            if (!elementString.equals(this.selectedAlias)) continue;
            this.viewer.setSelection((ISelection)new StructuredSelection(element), true);
        }
    }

    @Override
    public void clear() {
        this.selectedAlias = null;
    }

    private class AliasSelectionContentProvider
    implements IStructuredContentProvider {
        private AliasSelectionContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List list = (List)inputElement;
                return list.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class AliasSelectionLabelProvider
    extends LabelProvider {
        private AliasSelectionLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return null;
        }
    }
}

