/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.rcp.ui.ItemHandleAwareHashSet;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;

public class SelectProcessAreasAction
extends Action {
    private int fType;

    public SelectProcessAreasAction(int type) {
        super("", 8);
        this.fType = type;
        switch (this.fType) {
            case 0: {
                this.setText(Messages.SelectTeamAreasAction_1);
                break;
            }
            case 1: {
                this.setText(Messages.SelectTeamAreasAction_2);
                break;
            }
            case 2: {
                this.setText(Messages.SelectTeamAreasAction_3);
            }
        }
    }

    public void run() {
        IPreferenceStore preferences = ProcessRCPUIPlugin.getDefault().getPreferenceStore();
        if (this.fType == preferences.getInt("teamArtifactsNavigator.activeFilter")) {
            return;
        }
        switch (this.fType) {
            case 0: {
                this.selectCustom();
                break;
            }
            case 1: {
                this.selectMyProcessAreas();
                break;
            }
            case 2: {
                this.selectAllProcessAreas(false);
            }
        }
        preferences.setValue("teamArtifactsNavigator.activeFilter", this.fType);
        new InstanceScope().getNode("com.ibm.team.process.rcp.ui").put("teamArtifactsNavigator.activeFilter", String.valueOf(this.fType));
    }

    private void selectCustom() {
        IEclipsePreferences preferences = new InstanceScope().getNode("com.ibm.team.process.rcp.ui");
        String stringMemento = preferences.get("customTeamAreaFilterMemento", "");
        if (stringMemento.length() != 0) {
            ConnectedProjectAreaRegistry.getDefault().setStateFromMemento(stringMemento, true, true);
        } else {
            this.selectAllProcessAreas(true);
        }
    }

    private void selectAllProcessAreas(final boolean alwaysIncludeArchived) {
        final ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        List connectedProjectAreas = registry.getConnectedProjectAreas(null);
        if (connectedProjectAreas.isEmpty()) {
            return;
        }
        final ItemHandleAwareHashSet teamRepositories = new ItemHandleAwareHashSet();
        int i = 0;
        while (i < connectedProjectAreas.size()) {
            IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)connectedProjectAreas.get(i);
            teamRepositories.add(projectAreaHandle.getOrigin());
            ++i;
        }
        Job job = new Job(Messages.SelectTeamAreasAction_4){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ItemHandleAwareHashSet projectAreasToSelect = new ItemHandleAwareHashSet();
                    IEclipsePreferences preferences = new InstanceScope().getNode("com.ibm.team.process.rcp.ui");
                    boolean includeArchived = alwaysIncludeArchived || preferences.getBoolean("teamArtifactsNavigator.showArchived", false);
                    Iterator it = teamRepositories.iterator();
                    while (it.hasNext()) {
                        Object[] projectAreas = registry.fetchConnectedProjectAreas((ITeamRepository)it.next(), false, includeArchived, monitor);
                        int i = 0;
                        while (i < projectAreas.length) {
                            IProjectArea projectArea = (IProjectArea)projectAreas[i];
                            registry.setSelectedTeamAreas((IProjectAreaHandle)projectArea, projectArea.getTeamAreas());
                            ++i;
                        }
                        projectAreasToSelect.addAll(projectAreas);
                    }
                    registry.setSelectedProjectAreas(new ArrayList(projectAreasToSelect));
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.process.rcp.ui", Messages.SelectTeamAreasAction_5, (Throwable)e);
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void selectMyProcessAreas() {
        final ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        final List connectedProjectAreas = registry.getConnectedProjectAreas(null);
        if (connectedProjectAreas.isEmpty()) {
            return;
        }
        Job job = new Job(Messages.SelectTeamAreasAction_6){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ItemHandleAwareHashSet projectAreasToSelect = new ItemHandleAwareHashSet();
                    for (IProjectAreaHandle projectAreaHandle : connectedProjectAreas) {
                        ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
                        IContributor user = teamRepository.loggedInContributor();
                        if (user == null) continue;
                        IProjectArea projectArea = (IProjectArea)teamRepository.itemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 0, monitor);
                        if (projectArea.hasMember((IContributorHandle)user)) {
                            projectAreasToSelect.add(projectArea);
                        }
                        IProcessItemService service = (IProcessItemService)teamRepository.getClientLibrary(IProcessItemService.class);
                        List teamAreas = service.findTeamAreas(user, projectAreaHandle, SelectProcessAreasAction.this.computeRequiredProperties(), monitor);
                        registry.setSelectedTeamAreas(projectAreaHandle, teamAreas);
                    }
                    registry.setSelectedProjectAreas(new ArrayList(projectAreasToSelect));
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.process.rcp.ui", Messages.SelectTeamAreasAction_7, (Throwable)e);
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private Collection computeRequiredProperties() {
        return IProcessClientService.ALL_PROPERTIES;
    }
}

