/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.HistoryCombo;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.rcp.ui.ILoginInfoUIProvider;
import com.ibm.team.process.rcp.ui.IUIValidationCallback;
import com.ibm.team.repository.client.ILoginInfo2;
import com.ibm.team.repository.client.SavedPasswordNotObtainedException;
import com.ibm.team.repository.client.login.SSLCertificateLoginInfo;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.Preferences;

public class SSLCertificateLoginInfoUIProvider
implements ILoginInfoUIProvider {
    private Preferences dialogPrefs = this.getConfigPrefs().node("dialog");
    private HistoryCombo certificateLocation;
    private String certificateLocationValue;
    private String passwordValue;
    private Text password;

    private Preferences getConfigPrefs() {
        IEclipsePreferences prefs = new InstanceScope().getNode("com.ibm.team.process.rcp.ui");
        Preferences edilogPrefs = prefs.node(this.getClass().getName());
        return edilogPrefs;
    }

    @Override
    public Control createContents(Composite parent, final IUIValidationCallback validationCallback) {
        Composite main = new Composite(parent, 0);
        new Label(main, 0).setText(Messages.SSLCertificateLoginInfoUIProvider_0);
        this.certificateLocation = new HistoryCombo(main, this.dialogPrefs.node("certificateLocation"), false);
        this.certificateLocation.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SSLCertificateLoginInfoUIProvider.this.certificateLocationValue = SSLCertificateLoginInfoUIProvider.this.certificateLocation.getCombo().getText();
                SSLCertificateLoginInfoUIProvider.this.certificateLocation.addToHistory();
                if (validationCallback != null) {
                    validationCallback.validate();
                }
            }
        });
        Button browse = new Button(main, 8);
        browse.setText(Messages.SSLCertificateLoginInfoUIProvider_1);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell());
                dialog.setFilterExtensions(new String[]{"*.p12"});
                dialog.setText(Messages.SSLCertificateLoginInfoUIProvider_2);
                String location = dialog.open();
                if (location != null) {
                    SSLCertificateLoginInfoUIProvider.this.certificateLocation.getCombo().setText(location);
                }
            }
        });
        new Label(main, 0).setText(Messages.SSLCertificateLoginInfoUIProvider_3);
        this.password = new Text(main, 0x400800);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.password);
        GridLayoutFactory.fillDefaults().numColumns(3).generateLayout(main);
        this.password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SSLCertificateLoginInfoUIProvider.this.password != null && !SSLCertificateLoginInfoUIProvider.this.password.isDisposed()) {
                    SSLCertificateLoginInfoUIProvider.this.passwordValue = SSLCertificateLoginInfoUIProvider.this.password.getText();
                    if (validationCallback != null) {
                        validationCallback.validate();
                    }
                }
            }
        });
        return main;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ILoginInfo2 getLoginInfo() {
        SSLCertificateLoginInfo loginInfo = new SSLCertificateLoginInfo(this.certificateLocationValue, this.passwordValue);
        return loginInfo;
    }

    @Override
    public IStatus getValidationStatus() {
        if (!this.isValidCertificateLocation()) {
            return new Status(4, "com.ibm.team.process.rcp.ui", Messages.SSLCertificateLoginInfoUIProvider_4);
        }
        if (!this.isCertificateExist()) {
            return new Status(4, "com.ibm.team.process.rcp.ui", Messages.SSLCertificateLoginInfoUIProvider_5);
        }
        return null;
    }

    @Override
    public boolean isValid() {
        return this.certificateLocationValue != null && this.isCertificateExist() && this.isValidCertificateLocation();
    }

    private boolean isCertificateExist() {
        String filename = this.certificateLocationValue.trim();
        File file = new File(filename);
        return file.isFile();
    }

    private boolean isValidCertificateLocation() {
        return this.certificateLocationValue != null && this.certificateLocationValue.length() > 0;
    }

    @Override
    public void populate(ILoginInfo2 loginInfo) {
        this.populate(loginInfo, true);
    }

    @Override
    public void populate(ILoginInfo2 loginInfo, boolean rememberPassword) {
        if (loginInfo != null) {
            SSLCertificateLoginInfo info = (SSLCertificateLoginInfo)loginInfo;
            this.certificateLocationValue = info.getCertificateLocation();
            this.passwordValue = null;
            try {
                this.passwordValue = rememberPassword ? info.getPassword() : "";
            }
            catch (SavedPasswordNotObtainedException savedPasswordNotObtainedException) {
                // empty catch block
            }
            this.setPasswordTextValue(this.passwordValue);
            this.setCertificateLocationTextValue(this.certificateLocationValue);
        } else {
            this.clear();
        }
    }

    @Override
    public void clear() {
        String empty = "";
        this.setPasswordTextValue(empty);
        this.setCertificateLocationTextValue(empty);
    }

    private void setPasswordTextValue(String passwordValue) {
        if (passwordValue == null) {
            return;
        }
        if (this.password == null) {
            return;
        }
        if (this.password.isDisposed()) {
            return;
        }
        this.password.setText(passwordValue);
    }

    private void setCertificateLocationTextValue(String value) {
        if (value == null) {
            return;
        }
        if (this.certificateLocation == null) {
            return;
        }
        Combo combo = this.certificateLocation.getCombo();
        if (combo.isDisposed()) {
            return;
        }
        combo.setText(value);
    }
}

