/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.osgi.framework.BundleContext;

public class RepositoryProxyListener
implements IProxyChangeListener,
ITeamRepositoryService.IRepositoryServiceListener {
    private final IProxyService proxyService;

    private static String scheme2ProxyType(String scheme) {
        if (scheme == null) {
            return null;
        }
        if ("http".equals(scheme.toLowerCase())) {
            return "HTTP";
        }
        if ("https".equals(scheme.toLowerCase())) {
            return "HTTPS";
        }
        return null;
    }

    private void setProxyForRepo(ITeamRepository repository) {
        IProxyData proxyData = null;
        if (this.proxyService.isProxiesEnabled()) {
            URI uri = URI.create(repository.getRepositoryURI());
            proxyData = this.getProxyData(uri);
        }
        if (proxyData != null) {
            repository.setProxy(proxyData.getHost(), proxyData.getType(), proxyData.getPort(), proxyData.getUserId(), proxyData.getPassword());
        } else {
            repository.setProxy(null, null, -1, null, null);
        }
    }

    private IProxyData getProxyData(URI uri) {
        String proxy_type = RepositoryProxyListener.scheme2ProxyType(uri.getScheme());
        URI httpUri = null;
        if (proxy_type == null) {
            return null;
        }
        IProxyData proxyData = null;
        boolean systemProxyEnabled = this.proxyService.isSystemProxiesEnabled();
        if (systemProxyEnabled) {
            try {
                httpUri = new URI("HTTP", uri.getHost(), uri.getPath(), uri.getFragment());
                IProxyData[] nativeProxyData = this.proxyService.select(httpUri);
                if (nativeProxyData != null && nativeProxyData.length > 0) {
                    proxyData = nativeProxyData[0];
                }
            }
            catch (URISyntaxException e) {
                proxyData = null;
            }
        } else {
            proxyData = this.proxyService.getProxyData("HTTP");
        }
        if (proxyData != null && proxyData.getHost() == null) {
            proxyData = null;
        }
        return proxyData;
    }

    private void setProxyForAllRepos() {
        ITeamRepositoryService rs = TeamPlatform.getTeamRepositoryService();
        ITeamRepository[] repos = rs.getTeamRepositories();
        int i = 0;
        while (i < repos.length) {
            this.setProxyForRepo(repos[i]);
            ++i;
        }
    }

    RepositoryProxyListener(BundleContext context) {
        this.proxyService = (IProxyService)context.getService(context.getServiceReference(IProxyService.class.getName()));
        this.proxyService.addProxyChangeListener((IProxyChangeListener)this);
        ITeamRepositoryService teamRepositoryService = TeamPlatform.getTeamRepositoryService();
        teamRepositoryService.addRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this);
        if (this.proxyService.isProxiesEnabled()) {
            this.setProxyForAllRepos();
        }
    }

    public void proxyInfoChanged(IProxyChangeEvent event) {
        this.setProxyForAllRepos();
    }

    public void addedRepository(ITeamRepository repository) {
        if (this.proxyService.isProxiesEnabled()) {
            this.setProxyForRepo(repository);
        }
    }

    public void removedRepository(ITeamRepository repository) {
    }
}

