/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.foundation.rcp.core.PasswordUtil;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.rcp.ui.ErrorUtil;
import com.ibm.team.process.internal.rcp.ui.LoginAction;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.internal.rcp.ui.RepositoryInfo;
import com.ibm.team.process.rcp.ui.IStatusHandler;
import com.ibm.team.process.rcp.ui.RepositoryCreationPart;
import com.ibm.team.repository.client.ILoginInfo2;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.SavedPasswordNotObtainedException;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.login.SSLCertificateLoginInfo;
import com.ibm.team.repository.client.login.UsernameAndPasswordLoginInfo;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;

public class RepositoryPropertyPage
extends PropertyPage
implements IStatusHandler {
    private RepositoryCreationPart fPart;
    private RepositoryInfo fRepositoryInformation;
    private Composite fComposite;

    protected Control createContents(Composite parent) {
        IAdaptable element = this.getElement();
        ITeamRepository repo = (ITeamRepository)element.getAdapter(ITeamRepository.class);
        this.fRepositoryInformation = new RepositoryInfo(repo);
        this.fComposite = new Composite(parent, 0);
        this.fComposite.setLayout((Layout)new GridLayout(1, false));
        this.fComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fPart = new RepositoryCreationPart(this, this.fRepositoryInformation);
        return this.fComposite;
    }

    public void dispose() {
        if (this.fPart != null) {
            this.fPart.dispose();
        }
    }

    public boolean performOk() {
        this.save();
        return true;
    }

    private void save() {
        Job saveJob = new Job(Messages.RepositoryPropertyPage_0){

            protected IStatus run(IProgressMonitor monitor) {
                RepositoryPropertyPage.this.save(monitor);
                return Status.OK_STATUS;
            }
        };
        saveJob.setUser(true);
        saveJob.schedule();
    }

    private void save(IProgressMonitor monitor) {
        boolean needsReset = this.saveSettings(monitor);
        if (needsReset) {
            this.resetConnection(monitor);
        }
        this.savePassword();
    }

    private boolean saveSettings(IProgressMonitor monitor) {
        boolean needsReset = this.needsReset();
        if (this.repositoryURIChanged()) {
            try {
                this.changeRepositoryURI(monitor);
            }
            catch (TeamRepositoryException e) {
                ErrorUtil.reportException(Messages.RepositoryPropertyPage_2, e);
                return false;
            }
        }
        this.fRepositoryInformation.fTeamRepository.setAutoLogin(this.fRepositoryInformation.fAutoLogin);
        this.fRepositoryInformation.fTeamRepository.setName(this.fRepositoryInformation.fName);
        this.fRepositoryInformation.fTeamRepository.setUserId(this.fRepositoryInformation.fUserID);
        this.fRepositoryInformation.fTeamRepository.setConnectionTimeout(this.fRepositoryInformation.fTimeout);
        this.fRepositoryInformation.fTeamRepository.setSavePassword(this.fRepositoryInformation.fSavePassword);
        this.fRepositoryInformation.fTeamRepository.setLoginInfo(this.fRepositoryInformation.fProvider.getLoginInfo());
        return needsReset;
    }

    private boolean needsReset() {
        Properties newLoginProperties;
        boolean loginPropertiesChanged;
        if (this.repositoryURIChanged()) {
            return true;
        }
        if (!this.fRepositoryInformation.fTeamRepository.loggedIn()) {
            return true;
        }
        ILoginInfo2 currentLogin = this.fRepositoryInformation.fTeamRepository.getLoginInfo();
        if (currentLogin == null) {
            return true;
        }
        ILoginInfo2 newLoginInfo = this.fRepositoryInformation.fProvider.getLoginInfo();
        Properties currentLoginProperties = currentLogin.getLoginProperties();
        boolean bl = loginPropertiesChanged = !currentLoginProperties.equals(newLoginProperties = this.fRepositoryInformation.fProvider.getLoginInfo().getLoginProperties());
        if (loginPropertiesChanged) {
            return true;
        }
        if (this.fRepositoryInformation.fSavePassword) {
            try {
                boolean securedPropertiesChanged;
                Properties currentSecuredLoginProperties = currentLogin.getSecuredLoginProperties();
                Properties newSecuredLoginProperties = newLoginInfo.getSecuredLoginProperties();
                boolean bl2 = securedPropertiesChanged = !currentSecuredLoginProperties.equals(newSecuredLoginProperties);
                if (securedPropertiesChanged) {
                    return true;
                }
            }
            catch (SavedPasswordNotObtainedException savedPasswordNotObtainedException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean repositoryURIChanged() {
        boolean repositoryURIChanged = !this.fRepositoryInformation.fTeamRepository.getRepositoryURI().equalsIgnoreCase(this.fRepositoryInformation.fURI);
        return repositoryURIChanged;
    }

    private void changeRepositoryURI(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(NLS.bind((String)Messages.RepositoryPropertyPage_3, (Object)this.fRepositoryInformation.fName), -1);
        String newURI = this.fRepositoryInformation.fURI;
        ITeamRepository teamRepository = TeamPlatform.getTeamRepositoryService().getTeamRepositoryWithOverride(newURI, monitor);
        if (!teamRepository.getId().equals((Object)this.fRepositoryInformation.fTeamRepository.getId())) {
            this.clearPassword(this.fRepositoryInformation.fTeamRepository.getLoginInfo());
            TeamPlatform.getTeamRepositoryService().removeTeamRepository(this.fRepositoryInformation.fTeamRepository);
            TeamPlatform.getTeamRepositoryService().addTeamRepository(teamRepository);
        }
        this.fRepositoryInformation.fTeamRepository = teamRepository;
    }

    private void resetConnection(IProgressMonitor monitor) {
        if (this.fRepositoryInformation.fTeamRepository.loggedIn()) {
            this.fRepositoryInformation.fTeamRepository.logout();
        }
        monitor.beginTask(NLS.bind((String)Messages.RepositoryPropertyPage_1, (Object)this.fRepositoryInformation.fName), -1);
        try {
            this.fRepositoryInformation.fTeamRepository.login(monitor);
        }
        catch (TeamRepositoryException e) {
            Shell shell = ErrorUtil.getNewShell();
            if (shell == null) {
                ProcessRCPUIPlugin.getDefault().log(e);
            }
            LoginAction.reportLoginException(shell, e);
        }
    }

    private void savePassword() {
        if (this.fRepositoryInformation.fTeamRepository.getSavePassword()) {
            PasswordUtil.savePassword((ITeamRepository)this.fRepositoryInformation.fTeamRepository, (ILoginInfo2)this.fRepositoryInformation.fProvider.getLoginInfo());
        } else {
            PasswordUtil.clearSavedPassword((ITeamRepository)this.fRepositoryInformation.fTeamRepository);
            this.clearPassword(this.fRepositoryInformation.fTeamRepository.getLoginInfo());
        }
    }

    private void clearPassword(ILoginInfo2 loginInfo) {
        if (loginInfo instanceof UsernameAndPasswordLoginInfo) {
            ((UsernameAndPasswordLoginInfo)loginInfo).clearPassword();
        } else if (loginInfo instanceof SSLCertificateLoginInfo) {
            ((SSLCertificateLoginInfo)loginInfo).clearPassword();
        }
    }

    @Override
    public void setStatus(IStatus status) {
        String statusMessage = null;
        if (status != null && !status.isOK()) {
            statusMessage = status.getMessage();
        }
        if (statusMessage == null) {
            this.setMessage(null);
        } else if (status.getSeverity() == 2) {
            this.setMessage(statusMessage, 2);
            statusMessage = null;
        } else {
            this.setMessage(statusMessage, 3);
        }
        this.setValid(statusMessage == null);
    }

    @Override
    public Composite getComposite() {
        return this.fComposite;
    }

    @Override
    public GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }
}

