/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.repository.transport.client.IOAuthHandler;
import com.ibm.team.repository.transport.client.OAuthHandler;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RepositoryOAuthHandler
extends OAuthHandler {
    private volatile String fResult;

    public IOAuthHandler.IResponse authorize(final String url) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                RepositoryOAuthHandler.this.fResult = null;
                RepositoryOAuthHandler.this.authorizeUI(url);
            }
        });
        if (this.fResult == null || this.fResult.trim().length() == 0) {
            return null;
        }
        return new OAuthHandler.Response(this.fResult, Status.OK_STATUS);
    }

    private void authorizeUI(String url) {
        this.fResult = new Popup().open(url);
    }

    private static class Popup {
        private static Pattern fgOauthVerifier = Pattern.compile(".*[?&]oauth_verifier=([^&]+)");
        private static Pattern fgSecretPattern = Pattern.compile(".*[?&]request_token_secret=([^&]+)");
        private static Pattern fgTokenPattern = Pattern.compile(".*[?&]oauth_token=([^&]+)");
        private Shell fPopup;
        private Text fAddress;
        private ProgressBar fProgress;
        private Browser fBrowser;
        private String fResultUrl;
        private boolean fShouldClose;

        private Popup() {
        }

        private void handleLocationChanged(LocationEvent event) {
            this.fAddress.setText(event.location);
            String url = event.location;
            if (!fgTokenPattern.matcher(url).find()) {
                return;
            }
            boolean hasVerifier = fgOauthVerifier.matcher(url).find();
            boolean hasSecret = fgSecretPattern.matcher(url).find();
            boolean bl = this.fShouldClose = hasVerifier || hasSecret;
            if (this.fShouldClose) {
                this.fResultUrl = url;
            }
        }

        private String open(String url) {
            Display display = Display.getCurrent();
            Shell shell = display.getActiveShell();
            if (shell == null) {
                shell = display.getShells()[0];
            }
            this.fPopup = new Shell(shell, 67696);
            this.fPopup.setText(Messages.RepositoryOAuthHandler_0);
            this.fPopup.setSize(650, 600);
            this.fPopup.setLayout((Layout)new GridLayout());
            this.fAddress = new Text((Composite)this.fPopup, 2056);
            this.fAddress.setBackground(display.getSystemColor(25));
            this.fAddress.setLayoutData((Object)new GridData(768));
            this.fAddress.setText(url);
            this.fBrowser = new Browser((Composite)this.fPopup, 2048);
            this.fBrowser.setUrl(url);
            this.fBrowser.setLayoutData((Object)new GridData(1808));
            this.fProgress = new ProgressBar((Composite)this.fPopup, 256);
            this.fProgress.setLayoutData((Object)new GridData(768));
            this.fBrowser.addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent event) {
                    fProgress.setMaximum(event.total);
                    fProgress.setSelection(event.current);
                    if (event.current > 0) {
                        fProgress.setVisible(true);
                    }
                }

                public void completed(ProgressEvent event) {
                    fProgress.setVisible(false);
                    this.handleCompleted(event);
                }
            });
            this.fBrowser.addLocationListener((LocationListener)new LocationAdapter(){

                public void changed(LocationEvent event) {
                    this.handleLocationChanged(event);
                }

                public void changing(LocationEvent event) {
                    this.changed(event);
                }
            });
            this.fPopup.open();
            while (!this.fPopup.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            return this.fResultUrl;
        }

        protected void handleCompleted(ProgressEvent event) {
            if (this.fShouldClose) {
                this.fPopup.close();
            }
        }
    }
}

