/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.ImagePool;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.RepositoryInfo;
import com.ibm.team.process.rcp.ui.ILoginInfoUIProvider;
import com.ibm.team.process.rcp.ui.IUIValidationCallback;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.SavedPasswordNotObtainedException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RepositoryLoginInfoDialog
extends Dialog
implements IUIValidationCallback {
    protected Button rememberPasswordButton;
    protected Button autoLoginButton;
    protected Image keyLockImage;
    protected String message = null;
    private LocalResourceManager resourceMgr;
    private final String messageTooltip;
    private RepositoryInfo repositoryInfo;

    public RepositoryLoginInfoDialog(Shell parentShell, RepositoryInfo repositoryInfo, String message, String messageTooltip) {
        super(null);
        this.messageTooltip = messageTooltip;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.repositoryInfo = repositoryInfo;
        this.message = message;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.RepositoryLoginDialog_0);
    }

    public void create() {
        super.create();
        ILoginInfoUIProvider loginInfoUIProvider = this.repositoryInfo.fProvider;
        ITeamRepository repository = this.repositoryInfo.fTeamRepository;
        try {
            loginInfoUIProvider.populate(repository.getLoginInfo(), repository.getSavePassword());
        }
        catch (SavedPasswordNotObtainedException savedPasswordNotObtainedException) {
            // empty catch block
        }
        if (this.repositoryInfo.hasPassword) {
            this.rememberPasswordButton.setSelection(this.repositoryInfo.fSavePassword);
        }
        this.autoLoginButton.setSelection(this.repositoryInfo.fAutoLogin);
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.resourceMgr = new LocalResourceManager(JFaceResources.getResources(), (Control)top);
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(768));
        Composite imageComposite = new Composite(top, 0);
        layout = new GridLayout();
        imageComposite.setLayout((Layout)layout);
        imageComposite.setLayoutData((Object)new GridData(1040));
        Composite main = new Composite(top, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(768));
        Label imageLabel = new Label(imageComposite, 0);
        this.keyLockImage = this.resourceMgr.createImageWithDefault(ImagePool.KEYLOCK_IMAGE);
        imageLabel.setImage(this.keyLockImage);
        GridData data = new GridData(768);
        imageLabel.setLayoutData((Object)data);
        if (this.message != null) {
            Label messageLabel = new Label(main, 64);
            messageLabel.setForeground(Display.getDefault().getSystemColor(3));
            messageLabel.setBackground(Display.getDefault().getSystemColor(22));
            messageLabel.setText(this.message);
            messageLabel.setToolTipText(this.messageTooltip);
            data = new GridData(768);
            data.horizontalSpan = 3;
            data.widthHint = 300;
            messageLabel.setLayoutData((Object)data);
        }
        String domain = this.repositoryInfo.fURI;
        Label d = new Label(main, 64);
        d.setText(Messages.RepositoryLoginDialog_1);
        data = new GridData();
        d.setLayoutData((Object)data);
        Label label = new Label(main, 64);
        label.setBackground(Display.getDefault().getSystemColor(22));
        label.setText(domain);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 300;
        label.setLayoutData((Object)data);
        this.createPanel(main);
        if (domain != null) {
            this.autoLoginButton = new Button(main, 32);
            this.autoLoginButton.setText(Messages.RepositoryLoginDialog_3);
            data = new GridData();
            data.horizontalSpan = 2;
            this.autoLoginButton.setLayoutData((Object)data);
            this.autoLoginButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((RepositoryLoginInfoDialog)RepositoryLoginInfoDialog.this).repositoryInfo.fAutoLogin = RepositoryLoginInfoDialog.this.autoLoginButton.getSelection();
                }
            });
            if (this.repositoryInfo.hasPassword) {
                Composite warningComposite = new Composite(main, 0);
                layout = new GridLayout();
                layout.numColumns = 2;
                layout.marginHeight = 0;
                layout.marginHeight = 0;
                warningComposite.setLayout((Layout)layout);
                data = new GridData(768);
                data.horizontalSpan = 3;
                warningComposite.setLayoutData((Object)data);
                Label warningLabel = new Label(warningComposite, 0);
                warningLabel.setImage(RepositoryLoginInfoDialog.getImage((String)"dialog_messasge_warning_image"));
                warningLabel.setLayoutData((Object)new GridData(34));
                Label warningText = new Label(warningComposite, 64);
                warningText.setText(Messages.RepositoryLoginDialog_4);
                data = new GridData(768);
                data.widthHint = 300;
                warningText.setLayoutData((Object)data);
            }
        }
        this.validate();
        Dialog.applyDialogFont((Control)parent);
        return main;
    }

    private void createPanel(Composite main) {
        if (this.repositoryInfo.fProvider != null) {
            Composite parent = new Composite(main, 0);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)parent);
            GridLayoutFactory.fillDefaults().applyTo(parent);
            Control contents = this.repositoryInfo.fProvider.createContents(parent, this);
            if (this.repositoryInfo.hasPassword) {
                this.rememberPasswordButton = new Button((Composite)contents, 32);
                GridData data = new GridData();
                data.horizontalSpan = 2;
                this.rememberPasswordButton.setLayoutData((Object)data);
                this.rememberPasswordButton.setText(Messages.RepositoryLoginDialog_2);
                this.rememberPasswordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ((RepositoryLoginInfoDialog)RepositoryLoginInfoDialog.this).repositoryInfo.fSavePassword = RepositoryLoginInfoDialog.this.rememberPasswordButton.getSelection();
                    }
                });
            }
            GridDataFactory.fillDefaults().grab(true, false).applyTo(contents);
        }
    }

    protected void okPressed() {
        super.okPressed();
    }

    public RepositoryInfo getRepositoryInfo() {
        return this.repositoryInfo;
    }

    @Override
    public void validate() {
    }
}

