/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.foundation.rcp.core.PasswordUtil;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.RepositoryInfo;
import com.ibm.team.process.internal.rcp.ui.RepositoryLabelProvider;
import com.ibm.team.process.internal.rcp.ui.RepositoryLoginInfoDialog;
import com.ibm.team.repository.client.ILoginHandler2;
import com.ibm.team.repository.client.ILoginInfo2;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.login.SSLCertificateLoginInfo;
import com.ibm.team.repository.client.login.UsernameAndPasswordLoginInfo;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.transport.client.KerberosInvalidTicketException;
import com.ibm.team.repository.transport.client.NoUserCredentialsAcceptedException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class RepositoryLoginHandler
implements ILoginHandler2 {
    public ILoginInfo2 challenge(final ITeamRepository repository) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return null;
        }
        final ILoginInfo2[] result = new ILoginInfo2[1];
        if (Display.getCurrent() == null) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    result[0] = RepositoryLoginHandler.this.getCredentials(repository);
                }
            });
            return result[0];
        }
        return this.getCredentials(repository);
    }

    private ILoginInfo2 getCredentials(ITeamRepository server) {
        boolean savedValidPasswordExists;
        boolean bl = savedValidPasswordExists = server.getSavePassword() && server.getErrorState() != 2;
        if (savedValidPasswordExists) {
            if (server.getErrorState() == 0) {
                return server.getLoginInfo();
            }
            if (server.getErrorState() == 1) {
                if (this.userWantsToTryAgain(server)) {
                    return server.getLoginInfo();
                }
                return null;
            }
        }
        return this.getCredentialsFromUser(server);
    }

    private boolean userWantsToTryAgain(ITeamRepository server) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        String message = Messages.RepositoryLoginHandler_0;
        Throwable lastError = server.getLastError();
        if (lastError instanceof TeamRepositoryException) {
            message = RepositoryLabelProvider.toConnectionErrorString((TeamRepositoryException)lastError, server);
        }
        return MessageDialog.openQuestion((Shell)shell, (String)Messages.RepositoryLoginHandler_1, (String)NLS.bind((String)Messages.RepositoryLoginHandler_2, (Object)message));
    }

    private ILoginInfo2 getCredentialsFromUser(ITeamRepository repository) {
        RepositoryInfo repositoryInfo = new RepositoryInfo(repository);
        if (repositoryInfo.fProvider != null) {
            RepositoryLoginInfoDialog dialog = this.createLoginDialog(repositoryInfo);
            if (dialog == null) {
                return null;
            }
            int dialogResult = dialog.open();
            if (dialogResult == 0) {
                repository.setSavePassword(repositoryInfo.fSavePassword);
                repository.setAutoLogin(repositoryInfo.fAutoLogin);
                ILoginInfo2 uiLoginInfo = repositoryInfo.fProvider.getLoginInfo();
                if (repositoryInfo.hasPassword) {
                    this.savePassword(repository, uiLoginInfo, repository.getSavePassword());
                }
                return uiLoginInfo;
            }
            return null;
        }
        return null;
    }

    private void savePassword(ITeamRepository repository, ILoginInfo2 loginInfo, boolean savePassword) {
        if (savePassword) {
            PasswordUtil.savePassword((ITeamRepository)repository, (ILoginInfo2)loginInfo);
        } else {
            PasswordUtil.clearSavedPassword((ITeamRepository)repository, (ILoginInfo2)loginInfo);
            this.clearPassword(repository.getLoginInfo());
        }
    }

    private void clearPassword(ILoginInfo2 loginInfo) {
        if (loginInfo instanceof UsernameAndPasswordLoginInfo) {
            ((UsernameAndPasswordLoginInfo)loginInfo).clearPassword();
        } else if (loginInfo instanceof SSLCertificateLoginInfo) {
            ((SSLCertificateLoginInfo)loginInfo).clearPassword();
        }
    }

    private RepositoryLoginInfoDialog createLoginDialog(RepositoryInfo info) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        String message = null;
        if (info.fTeamRepository.getErrorState() != 0) {
            if (info.fTeamRepository.getLastError() instanceof KerberosInvalidTicketException || info.fTeamRepository.getLastError() instanceof NoUserCredentialsAcceptedException) {
                return null;
            }
            message = RepositoryLabelProvider.toConnectionErrorString(info.fTeamRepository);
        }
        RepositoryLoginInfoDialog dialog = new RepositoryLoginInfoDialog(shell, info, message, null);
        return dialog;
    }
}

