/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.process.internal.rcp.ui.ErrorUtil;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.internal.rcp.ui.RepositoryLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ServerStateCheckException;
import com.ibm.team.repository.common.ServerVersionCheckException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.transport.client.AuthenticationException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class RepositoryLoginErrorDialog
extends MessageDialog {
    private ServerVersionCheckException svce;

    public static void openError(Shell shell, TeamRepositoryException exception) {
        ServerVersionCheckException svce;
        if (exception instanceof ServerVersionCheckException && ((svce = (ServerVersionCheckException)exception).getServerVersion().length() > 0 || svce.getCause() instanceof AuthenticationException)) {
            RepositoryLoginErrorDialog dialog = new RepositoryLoginErrorDialog(shell, svce);
            dialog.open();
            return;
        }
        Object origin = exception.getOrigin();
        ITeamRepository repo = null;
        String message = exception.getMessage();
        if (origin instanceof ITeamRepository) {
            repo = (ITeamRepository)origin;
            message = RepositoryLabelProvider.toConnectionErrorString(exception, repo);
        }
        if (exception instanceof ServerStateCheckException) {
            message = NLS.bind((String)Messages.RepositoryLoginErrorDialog_3, (Object)message);
            new RestartRequiredDialog(shell, message).open();
            return;
        }
        IStatus status = ErrorUtil.createStatus(message, exception);
        ErrorDialog.openError((Shell)shell, (String)Messages.LoginAction_3, null, (IStatus)status);
    }

    private RepositoryLoginErrorDialog(Shell parentShell, ServerVersionCheckException svce) {
        super(parentShell, Messages.RepositoryLoginErrorDialog_0, null, svce.getMessage(), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        this.svce = svce;
    }

    protected Control createMessageArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        super.createMessageArea(composite);
        new Label(composite, 0);
        Label versionLabel = new Label(composite, 0);
        if (this.svce.getServerVersion().length() == 0) {
            versionLabel.setText(NLS.bind((String)Messages.RepositoryLoginErrorDialog_CLIENT_VERSION, (Object)this.svce.getClientVersion()));
        } else {
            versionLabel.setText(NLS.bind((String)Messages.RepositoryLoginErrorDialog_CLIENT_VERSION_SERVER_VERSION, (Object)this.svce.getClientVersion(), (Object)this.svce.getServerVersion()));
        }
        new Label(composite, 0);
        Object origin = this.svce.getOrigin();
        ITeamRepository repo = null;
        if (origin instanceof ITeamRepository) {
            repo = (ITeamRepository)origin;
        }
        String svceUri = XMLString.createFromPlainText((String)this.svce.getUri()).getXMLText();
        String uri = "<a href=\"" + svceUri + "\">" + svceUri + "</a>";
        Link link = new Link(composite, 0);
        link.setText(NLS.bind((String)Messages.RepositoryLoginErrorDialog_2, (Object)RepositoryLabelProvider.getRepositoryText(repo), (Object)uri));
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    int style = 42;
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.createBrowser(style, RepositoryLoginErrorDialog.this.svce.getUri(), null, null);
                    browser.openURL(new URL(RepositoryLoginErrorDialog.this.svce.getUri()));
                    RepositoryLoginErrorDialog.this.close();
                }
                catch (PartInitException e) {
                    ProcessRCPUIPlugin.getDefault().log(e);
                }
                catch (MalformedURLException e) {
                    ProcessRCPUIPlugin.getDefault().log(e);
                }
            }
        });
        GridDataFactory.defaultsFor((Control)link).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)link);
        RepositoryLoginErrorDialog.applyDialogFont((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(composite);
        return composite;
    }

    private static class RestartRequiredDialog
    extends ErrorDialog {
        private static String fgDialogTitle = Messages.RepositoryLoginErrorDialog_1;
        private static int fgDisplayMask = 7;

        private RestartRequiredDialog(Shell parentShell, String message) {
            super(parentShell, fgDialogTitle, null, (IStatus)new Status(4, "com.ibm.team.process.rcp.ui", message), fgDisplayMask);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, false);
        }

        protected void buttonPressed(int id) {
            if (id == 2) {
                PlatformUI.getWorkbench().close();
            } else if (id == 3) {
                super.cancelPressed();
            } else {
                super.buttonPressed(id);
            }
        }
    }
}

