/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.DisplayHelper;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import java.util.List;
import org.eclipse.jface.viewers.StructuredViewer;

public class RepositoryListener
implements IListener {
    private ITeamRepositoryService.IRepositoryServiceListener fListener = new ITeamRepositoryService.IRepositoryServiceListener(){

        public void removedRepository(ITeamRepository repository) {
            int j = 0;
            while (j < RepositoryListener.this.fCategories.length) {
                String category = RepositoryListener.this.fCategories[j];
                repository.removeGenericListener((Object)category, (IListener)RepositoryListener.this);
                ++j;
            }
        }

        public void addedRepository(ITeamRepository repository) {
            int j = 0;
            while (j < RepositoryListener.this.fCategories.length) {
                String category = RepositoryListener.this.fCategories[j];
                repository.addGenericListener((Object)category, (IListener)RepositoryListener.this);
                ++j;
            }
        }
    };
    private StructuredViewer fViewer;
    private String[] fCategories;
    private final boolean fUpdateProjectAreas;

    public RepositoryListener(StructuredViewer viewer, String[] categories, boolean updateProjectAreas) {
        this.fViewer = viewer;
        this.fCategories = categories;
        this.fUpdateProjectAreas = updateProjectAreas;
        ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < repositories.length) {
            ITeamRepository teamRepository = repositories[i];
            int j = 0;
            while (j < this.fCategories.length) {
                String category = this.fCategories[j];
                teamRepository.addGenericListener((Object)category, (IListener)this);
                ++j;
            }
            ++i;
        }
        TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener(this.fListener);
    }

    public void handleEvents(List events) {
        for (final IEvent event : events) {
            if (!(event instanceof PropertyChangeEvent)) continue;
            PropertyChangeEvent propertyChangeEvent = (PropertyChangeEvent)event;
            if (!(event.getEventSource() instanceof ITeamRepository) || !this.interestingProperty(propertyChangeEvent.getProperty()) || this.fViewer == null) continue;
            DisplayHelper.asyncExec(this.fViewer.getControl(), new Runnable(){

                @Override
                public void run() {
                    ITeamRepository teamRepository = (ITeamRepository)event.getEventSource();
                    RepositoryListener.this.fViewer.update((Object)teamRepository, null);
                    if (RepositoryListener.this.fUpdateProjectAreas) {
                        List connected = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(teamRepository);
                        RepositoryListener.this.fViewer.update(connected.toArray(), null);
                    }
                }
            });
        }
    }

    private boolean interestingProperty(Object property) {
        int i = 0;
        while (i < this.fCategories.length) {
            String interestingProperty = this.fCategories[i];
            if (interestingProperty.equals(property)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void dispose() {
        ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < repositories.length) {
            ITeamRepository teamRepository = repositories[i];
            int j = 0;
            while (j < this.fCategories.length) {
                String category = this.fCategories[j];
                teamRepository.removeGenericListener((Object)category, (IListener)this);
                ++j;
            }
            ++i;
        }
        TeamPlatform.getTeamRepositoryService().removeRepositoryServiceListener(this.fListener);
    }
}

