/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.process.internal.rcp.ui.ImagePool;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.SavedPasswordNotObtainedException;
import com.ibm.team.repository.client.ServerStateCheckException;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import com.ibm.team.repository.common.ServerVersionCheckException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.common.transport.HostUnknownException;
import com.ibm.team.repository.common.transport.VersionMismatchException;
import com.ibm.team.repository.transport.client.AuthenticationException;
import com.ibm.team.repository.transport.client.ClientCertificateNotAcceptedException;
import com.ibm.team.repository.transport.client.InsufficientRightsException;
import com.ibm.team.repository.transport.client.InvalidCertificateOrSmartcardException;
import com.ibm.team.repository.transport.client.InvalidUserCredentialsException;
import com.ibm.team.repository.transport.client.KerberosInvalidTicketException;
import com.ibm.team.repository.transport.client.NoKerberosTargetException;
import com.ibm.team.repository.transport.client.NoResponseException;
import com.ibm.team.repository.transport.client.NoUserCredentialsAcceptedException;
import com.ibm.team.repository.transport.client.WindowsLoginException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class RepositoryLabelProvider
extends TypeLabelProvider {
    private Image fRepositoryImage;
    private Image fLoggedInRepositoryImage;
    private Image fErrorLoggedInRepositoryImage;
    private IListener fEventListener = new IListener(){

        public void handleEvents(List events) {
            ArrayList<Object> affectedRepos = new ArrayList<Object>();
            for (IPropertyChangeEvent event : events) {
                affectedRepos.add(event.getObject());
            }
            RepositoryLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)RepositoryLabelProvider.this, affectedRepos.toArray()));
        }
    };

    public static String getRepositoryText(ITeamRepository repo) {
        String name = repo.getName();
        if (name == null || "".equals(name)) {
            name = repo.getRepositoryURI();
        }
        return name;
    }

    public RepositoryLabelProvider() {
        this.fRepositoryImage = this.getImage(ImagePool.LOGGEDOUT_REPOSITORY);
        this.fLoggedInRepositoryImage = this.getImage(ImagePool.LOGGEDIN_REPOSITORY);
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
        imageDescriptorArray[1] = ImagePool.ERROR_TICK;
        this.fErrorLoggedInRepositoryImage = this.getImage((ImageDescriptor)new OverlayIcon(ImagePool.LOGGEDIN_REPOSITORY, this.fLoggedInRepositoryImage, imageDescriptorArray, new Point(16, 16), 17408));
    }

    public void updateLabel(ViewerLabel label, Object element) {
        if (!(element instanceof ITeamRepository)) {
            return;
        }
        ITeamRepository obj = (ITeamRepository)element;
        String userId = obj.getUserId();
        if (userId == null || "".equals(userId)) {
            userId = Messages.RepositoryLabelProvider_0;
        }
        String name = RepositoryLabelProvider.getRepositoryText(obj);
        StringBuffer result = new StringBuffer(userId);
        result.append('@');
        result.append(name);
        int state = obj.getState();
        int errorState = obj.getErrorState();
        if (errorState == 1 || errorState == 2) {
            result.append(NLS.bind((String)Messages.RepositoryLabelProvider_9, (Object)RepositoryLabelProvider.toConnectionErrorString(obj)));
            if (state == 1) {
                label.setImage(this.fErrorLoggedInRepositoryImage);
            } else {
                label.setImage(this.fErrorLoggedInRepositoryImage);
            }
        } else if (state == 1) {
            label.setImage(this.fLoggedInRepositoryImage);
        } else {
            label.setImage(this.fRepositoryImage);
        }
        label.setText(result.toString());
    }

    protected void elementAdded(Object element) {
        ((ITeamRepository)element).addGenericListener((Object)"state", this.fEventListener);
        ((ITeamRepository)element).addGenericListener((Object)"error_state", this.fEventListener);
    }

    protected void elementRemoved(Object element) {
        ((ITeamRepository)element).removeGenericListener((Object)"state", this.fEventListener);
        ((ITeamRepository)element).removeGenericListener((Object)"error_state", this.fEventListener);
    }

    public static String toConnectionErrorString(ITeamRepository repo) {
        Throwable e;
        String errorString = "";
        int errorState = repo.getErrorState();
        if (errorState != 0 && (e = repo.getLastError()) != null) {
            if (e instanceof TeamRepositoryException) {
                errorString = RepositoryLabelProvider.toConnectionErrorString((TeamRepositoryException)e, repo);
            } else {
                errorString = errorState == 1 ? Messages.RepositoryLabelProvider_1 : Messages.RepositoryLabelProvider_2;
                String message = e.getMessage();
                if (message != null) {
                    errorString = NLS.bind((String)Messages.RepositoryLabelProvider_10, (Object)errorString, (Object)message);
                }
            }
        }
        return errorString;
    }

    public static String toConnectionErrorString(TeamRepositoryException exception, ITeamRepository repo) {
        String message = NLS.bind((String)Messages.RepositoryLabelProvider_3, (Object)RepositoryLabelProvider.getRepositoryText(repo));
        if (exception instanceof InvalidUserCredentialsException) {
            message = NLS.bind((String)Messages.RepositoryLabelProvider_4, (Object)RepositoryLabelProvider.getRepositoryText(repo));
        } else if (exception instanceof InvalidCertificateOrSmartcardException) {
            message = NLS.bind((String)Messages.RepositoryLabelProvider_4_5, (Object)RepositoryLabelProvider.getRepositoryText(repo));
        } else if (exception instanceof InsufficientRightsException) {
            message = NLS.bind((String)Messages.RepositoryLabelProvider_4_6, (Object)RepositoryLabelProvider.getRepositoryText(repo));
        } else if (exception instanceof KerberosInvalidTicketException) {
            message = NLS.bind((String)Messages.RepositoryLabelProvider_4_4, (Object)RepositoryLabelProvider.getRepositoryText(repo));
        } else if (exception instanceof NoKerberosTargetException) {
            message = NLS.bind((String)Messages.RepositoryLabelProvider_4_2, (Object)RepositoryLabelProvider.getRepositoryText(repo));
        } else if (exception instanceof WindowsLoginException) {
            message = exception.getLocalizedMessage();
        } else if (exception instanceof NoUserCredentialsAcceptedException) {
            message = NLS.bind((String)Messages.RepositoryLabelProvider_4_3, (Object)RepositoryLabelProvider.getRepositoryText(repo));
        } else if (exception instanceof ClientCertificateNotAcceptedException) {
            message = NLS.bind((String)Messages.RepositoryLabelProvider_4_8, (Object)RepositoryLabelProvider.getRepositoryText(repo));
        } else if (exception instanceof AuthenticationException) {
            message = NLS.bind((String)Messages.RepositoryLabelProvider_4_7, (Object)RepositoryLabelProvider.getRepositoryText(repo));
        } else if (exception instanceof ConnectionException) {
            message = NLS.bind((String)Messages.RepositoryLabelProvider_5, (Object)RepositoryLabelProvider.getRepositoryText(repo));
        } else if (exception instanceof HostUnknownException) {
            message = NLS.bind((String)Messages.RepositoryLabelProvider_6, (Object)repo.getRepositoryURI());
        } else if (exception instanceof NoResponseException) {
            message = NLS.bind((String)Messages.RepositoryLabelProvider_7, (Object)RepositoryLabelProvider.getRepositoryText(repo));
        } else if (exception instanceof VersionMismatchException) {
            message = NLS.bind((String)Messages.RepositoryLabelProvider_8, (Object)RepositoryLabelProvider.getRepositoryText(repo));
        } else if (exception instanceof ServerVersionCheckException) {
            ServerVersionCheckException svce = (ServerVersionCheckException)exception;
            message = NLS.bind((String)Messages.RepositoryLabelProvider_11, (Object[])new String[]{svce.getClientVersion(), svce.getServerVersion()});
        } else if (exception instanceof ServerStateCheckException) {
            message = exception.getMessage();
        } else if (exception instanceof SavedPasswordNotObtainedException) {
            message = Messages.Password_CannotBeNull;
        }
        return message;
    }

    public void dispose() {
        super.dispose();
        ITeamRepository[] teamRepositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < teamRepositories.length) {
            teamRepositories[i].purgeGenericListener(this.fEventListener);
            ++i;
        }
    }
}

