/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.LoginInfoUIProviderElementDescriptor;
import com.ibm.team.process.internal.rcp.ui.LoginInfoUIProviderExtensionReader;
import com.ibm.team.process.rcp.ui.ILoginInfoUIProvider;
import com.ibm.team.repository.client.ILoginInfo2;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.SavedPasswordNotObtainedException;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;

public class RepositoryInfo {
    public static final int MIN_TIMOUT = 0;
    public static final int MAX_TIMOUT = 9999;
    public ITeamRepository fTeamRepository;
    public String fName = "";
    public String fURI = "";
    public String fUserID = "";
    public boolean fAutoLogin = true;
    public boolean fSavePassword = true;
    public ILoginInfoUIProvider fProvider = null;
    public boolean hasPassword = true;
    public int fTimeout;

    public RepositoryInfo(ITeamRepository teamRepository) {
        this.fTeamRepository = teamRepository;
        if (teamRepository != null) {
            this.fUserID = teamRepository.getUserId();
            this.fAutoLogin = teamRepository.getAutoLogin();
            this.fSavePassword = teamRepository.getSavePassword();
            this.fTimeout = teamRepository.getConnectionTimeout();
            this.fURI = teamRepository.getRepositoryURI();
            this.fName = teamRepository.getName();
            if (this.fName == null) {
                this.fName = "";
            }
            if (teamRepository.getLoginInfo() != null) {
                String loginInfoId = teamRepository.getLoginInfo().getClass().getName();
                if (loginInfoId != null) {
                    LoginInfoUIProviderElementDescriptor descriptor = LoginInfoUIProviderExtensionReader.INSTANCE.getDescriptorForLoginID(loginInfoId);
                    this.fProvider = descriptor.createImplementation();
                    try {
                        this.fProvider.populate(teamRepository.getLoginInfo(), this.fSavePassword);
                    }
                    catch (SavedPasswordNotObtainedException savedPasswordNotObtainedException) {
                        // empty catch block
                    }
                }
                this.hasPassword = teamRepository.getLoginInfo().hasPassword();
                if (!this.hasPassword) {
                    this.fSavePassword = true;
                }
            } else {
                LoginInfoUIProviderElementDescriptor descriptor = LoginInfoUIProviderExtensionReader.INSTANCE.getDefaultDescriptor();
                this.fProvider = descriptor.createImplementation();
            }
        } else {
            ITeamRepositoryService service = TeamPlatform.getTeamRepositoryService();
            this.fTimeout = service.getDefaultConnectionTimeout() / 1000;
        }
    }

    @Deprecated
    public ILoginInfo2 getLoginInfo() throws TeamRepositoryException {
        if (this.fProvider != null) {
            return this.fProvider.getLoginInfo();
        }
        if (this.fTeamRepository != null) {
            return this.fTeamRepository.getLoginInfo();
        }
        return null;
    }

    public boolean isValid() {
        return this.fURI != null && this.fURI.trim().length() > 0 && this.fTimeout >= 0 && this.fTimeout <= 9999 && this.fProvider != null && this.fProvider.isValid();
    }
}

