/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.RepositoryCertificateDialog;
import com.ibm.team.process.internal.rcp.ui.RepositoryLabelProvider;
import com.ibm.team.repository.client.ICertificateHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.transport.client.CertificateHostnameMismatchException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public final class RepositoryCertificateHandler
implements ICertificateHandler {
    private ICertificateHandler.Trust ask(ITeamRepository server, CertificateException problem) {
        RepositoryCertificateDialog dialog = this.createCertificateDialog(server, problem);
        int dialogResult = dialog.open();
        if (dialogResult == 0) {
            switch (dialog.getSelection()) {
                case 1: {
                    return ICertificateHandler.Trust.REJECT;
                }
                case 2: {
                    return ICertificateHandler.Trust.ACCEPT_SESSION;
                }
                case 4: {
                    return ICertificateHandler.Trust.ACCEPT_PERMANENT;
                }
            }
        }
        return ICertificateHandler.Trust.REJECT;
    }

    private RepositoryCertificateDialog createCertificateDialog(ITeamRepository repository, CertificateException problem) {
        int buttonMask = 7;
        String detail = problem instanceof CertificateExpiredException ? Messages.RepositoryCertificateHandler_1 : (problem instanceof CertificateNotYetValidException ? Messages.RepositoryCertificateHandler_2 : (problem instanceof CertificateHostnameMismatchException ? Messages.RepositoryCertificateHandler_4 : Messages.RepositoryCertificateHandler_3));
        String message = NLS.bind((String)Messages.RepositoryCertificateHandler_0, (Object)RepositoryLabelProvider.getRepositoryText(repository), (Object)detail);
        String tooltip = problem.getLocalizedMessage();
        RepositoryCertificateDialog dialog = new RepositoryCertificateDialog(repository.getRepositoryURI(), message, tooltip, buttonMask, 1);
        return dialog;
    }

    public ICertificateHandler.Trust evaluate(final ITeamRepository repository, X509Certificate certificate, final CertificateException problem) {
        if (ErrorDialog.AUTOMATED_MODE) {
            return ICertificateHandler.Trust.ACCEPT_CONNECTION;
        }
        if (!PlatformUI.isWorkbenchRunning()) {
            return ICertificateHandler.Trust.REJECT;
        }
        final ICertificateHandler.Trust[] result = new ICertificateHandler.Trust[]{ICertificateHandler.Trust.REJECT};
        if (Display.getCurrent() == null) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    result[0] = RepositoryCertificateHandler.this.ask(repository, problem);
                }
            });
            return result[0];
        }
        return this.ask(repository, problem);
    }
}

