/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.foundation.rcp.core.extensionpoint.ExtensionPointManager;
import com.ibm.team.process.internal.rcp.ui.LoginInfoUIProviderExtensionReader;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessUIPreferenceStore;
import com.ibm.team.process.internal.rcp.ui.RepositoryProxyListener;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.util.ThreadCheck;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ProcessRCPUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.team.process.rcp.ui";
    public static final String PREF_TEAM_ARTIFACTS_NAVIGATOR_ACTIVE_FILTER = "teamArtifactsNavigator.activeFilter";
    private static final String APPLICATION_PROPERTY = "eclipse.application";
    private static final String APPLICATION_ARG = "-application";
    private static final List TEST_APPLICATIONS = Arrays.asList("org.eclipse.test.uitestapplication", "org.eclipse.test.coretestapplication", "org.eclipse.pde.junit.runtime.uitestapplication", "org.eclipse.pde.junit.runtime.coretestapplication", "org.eclipse.pde.junit.runtime.legacyUItestapplication", "org.eclipse.pde.junit.runtime.legacyCoretestapplication");
    public static final int CUSTOM = 0;
    public static final int MY_PROCESS_AREAS = 1;
    public static final int ALL_PROCESS_AREAS = 2;
    private ExtensionPointManager fExtensionPointManager;
    private ProcessUIPreferenceStore fProcessPreferenceStore;
    private static ProcessRCPUIPlugin fgDefault;

    public static ProcessRCPUIPlugin getDefault() {
        return fgDefault;
    }

    public ProcessRCPUIPlugin() {
        fgDefault = this;
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.fProcessPreferenceStore == null) {
            this.fProcessPreferenceStore = new ProcessUIPreferenceStore(this.getPluginPreferenceStore());
        }
        return this.fProcessPreferenceStore;
    }

    public IPersistentPreferenceStore getPluginPreferenceStore() {
        return (IPersistentPreferenceStore)super.getPreferenceStore();
    }

    public void log(Throwable exception) {
        this.log(Messages.ProcessRCPUIPlugin_2, exception);
    }

    public void log(String message, Throwable exception) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 0, message, exception));
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void stop(BundleContext context) throws Exception {
        ConnectedProjectAreaRegistry.disposeDefault();
        if (this.fExtensionPointManager != null) {
            this.fExtensionPointManager.dispose();
        }
        LoginInfoUIProviderExtensionReader.INSTANCE.stop();
        fgDefault = null;
        super.stop(context);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fExtensionPointManager = new ExtensionPointManager(this.getBundle());
        LoginInfoUIProviderExtensionReader.INSTANCE.start();
        new RepositoryProxyListener(context);
        String appId = this.getAppId(context);
        if (!TEST_APPLICATIONS.contains(appId)) {
            if (Display.getCurrent() != null) {
                ThreadCheck.prohibitLongOps();
            } else if (PlatformUI.isWorkbenchRunning()) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ThreadCheck.prohibitLongOps();
                    }
                });
            }
        }
    }

    private String getAppId(BundleContext context) {
        String[] args = Platform.getCommandLineArgs();
        int i = args.length - 2;
        while (i >= 0) {
            if (args[i].equals(APPLICATION_ARG) && i < args.length - 1 && !args[i + 1].startsWith("-")) {
                return args[i + 1];
            }
            --i;
        }
        String id = context.getProperty(APPLICATION_PROPERTY);
        if (id != null) {
            return id;
        }
        IProduct product = Platform.getProduct();
        if (product != null) {
            return product.getApplication();
        }
        return null;
    }

    public ExtensionPointManager getExtensionPointManager() {
        return this.fExtensionPointManager;
    }
}

