/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.foundation.rcp.ui.util.ItemHandleComparer;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.process.internal.common.ItemHandleAwareHashMap;
import com.ibm.team.process.internal.rcp.ui.DeferredCheckBoxTreeViewer;
import com.ibm.team.process.internal.rcp.ui.ImagePool;
import com.ibm.team.process.internal.rcp.ui.ItemHandleAwareHashSet;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessAreaContentProvider;
import com.ibm.team.process.internal.rcp.ui.ProcessAreaFiltersDialog;
import com.ibm.team.process.internal.rcp.ui.TeamRepositoryExceptionNode;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ProcessAreaSelector
extends Composite {
    private IElementComparer fComparer;
    private ProcessAreaContentProvider fContentProvider;
    private boolean fIncludeArchived = false;
    private CheckboxTreeViewer fViewer;
    private Map<String, ItemHandleAwareHashMap> fChangedTeamAreas = new HashMap<String, ItemHandleAwareHashMap>();
    private Map<String, Map<IProjectArea, Boolean>> fChangedProjectAreas = new HashMap<String, Map<IProjectArea, Boolean>>();
    private ProcessAreaFiltersDialog fDialog;
    private ICheckStateListener fCheckStateListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            ProcessAreaSelector.this.handleCheckStateChange(event.getElement(), event.getChecked());
        }
    };

    public ProcessAreaSelector(ProcessAreaFiltersDialog teamAreaFiltersDialog, Composite parent) {
        super(parent, 0);
        this.fDialog = teamAreaFiltersDialog;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.widthHint = 300;
        gridData.heightHint = 300;
        this.setLayoutData(gridData);
        Tree tree = new Tree((Composite)this, 2084);
        tree.setLayoutData((Object)gridData);
        this.fViewer = new DeferredCheckBoxTreeViewer(tree, this);
        this.fViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.fViewer.setComparer(this.getComparer());
        this.fViewer.setComparator(new ViewerComparator());
        this.fViewer.setInput((Object)ConnectedProjectAreaRegistry.getDefault());
        this.fViewer.addCheckStateListener(this.fCheckStateListener);
    }

    private ITreeContentProvider getContentProvider() {
        if (this.fContentProvider == null) {
            this.fContentProvider = new ProcessAreaContentProvider();
            this.fContentProvider.setFilters(this.fIncludeArchived, true);
        }
        return this.fContentProvider;
    }

    private ILabelProvider getLabelProvider() {
        LabelProvider provider = new LabelProvider(null, (IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        provider.addListener(new LabelProviderListener());
        return provider;
    }

    public CheckboxTreeViewer getViewer() {
        return this.fViewer;
    }

    private IElementComparer getComparer() {
        if (this.fComparer == null) {
            this.fComparer = new ItemHandleComparer();
        }
        return this.fComparer;
    }

    public Map<String, ItemHandleAwareHashMap> getChangedTeamAreas() {
        return this.fChangedTeamAreas;
    }

    public Map<String, Map<IProjectArea, Boolean>> getChangedProjectAreas() {
        return this.fChangedProjectAreas;
    }

    public void selectAll(boolean state) {
        ((DeferredCheckBoxTreeViewer)this.getViewer()).setAllChecked(state);
    }

    public void setIncludeArchived(boolean includeArchived) {
        this.fIncludeArchived = includeArchived;
        if (this.fContentProvider != null) {
            this.fContentProvider.setFilters(includeArchived, true);
        }
    }

    public void updateCheckedState(Object element) {
        ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        if (element instanceof IProjectAreaHandle) {
            IProjectAreaHandle connectedProjectArea = (IProjectAreaHandle)element;
            IItemManager itemManager = ((ITeamRepository)connectedProjectArea.getOrigin()).itemManager();
            IProjectArea projectArea = (IProjectArea)itemManager.getSharedItemIfKnown((IItemHandle)connectedProjectArea);
            if (projectArea != null) {
                boolean selected = registry.isSelected((IProjectAreaHandle)projectArea);
                String uniqueKey = this.getUniqueKey(projectArea);
                Map<IProjectArea, Boolean> map = this.fChangedProjectAreas.get(uniqueKey);
                if (map != null) {
                    selected = map.values().iterator().next();
                }
                this.fViewer.setChecked((Object)projectArea, selected);
            }
        } else if (element instanceof ITeamArea) {
            Boolean changedSelection;
            ITeamArea teamArea = (ITeamArea)element;
            boolean selected = registry.isSelected((ITeamAreaHandle)teamArea, teamArea.getProjectArea());
            String uniqueKey = this.getUniqueKey(teamArea.getProjectArea());
            ItemHandleAwareHashMap changedTeams = this.fChangedTeamAreas.get(uniqueKey);
            if (changedTeams != null && (changedSelection = (Boolean)changedTeams.get((Object)teamArea)) != null) {
                selected = changedSelection;
            }
            this.fViewer.setChecked((Object)teamArea, selected);
        }
        this.updateDescription();
    }

    private void updateDescription() {
        ItemHandleAwareHashSet selectedAreas = new ItemHandleAwareHashSet();
        ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        List connectedProjectAreas = registry.getConnectedProjectAreas(null);
        int totalCount = 0;
        for (Object connectedProjectAreaHandle : connectedProjectAreas) {
            IItemManager itemManager = ((ITeamRepository)connectedProjectAreaHandle.getOrigin()).itemManager();
            IProjectArea projectArea = (IProjectArea)itemManager.getSharedItemIfKnown((IItemHandle)connectedProjectAreaHandle);
            if (projectArea == null || !projectArea.isPropertySet(ProcessCommon.getPropertyName(IProjectArea.class, (String)"teamAreaHierarchy"))) continue;
            List registrySelectedAreas = registry.getSelectedProcessAreas((IProjectAreaHandle)projectArea);
            for (Object registrySelectedObject : registrySelectedAreas) {
                selectedAreas.add(registrySelectedObject);
            }
            ++totalCount;
            totalCount += projectArea.getTeamAreas().size();
        }
        for (Map map : this.fChangedProjectAreas.values()) {
            IProjectArea projectArea = (IProjectArea)map.keySet().iterator().next();
            boolean newSelection = (Boolean)map.values().iterator().next();
            if (newSelection) {
                selectedAreas.add(projectArea);
                continue;
            }
            selectedAreas.remove(projectArea);
        }
        Collection<ItemHandleAwareHashMap> collection = this.fChangedTeamAreas.values();
        for (ItemHandleAwareHashMap teamAreaChangesMap : collection) {
            for (Object object : teamAreaChangesMap.keySet()) {
                ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)object;
                boolean newSelection = (Boolean)teamAreaChangesMap.get((Object)teamAreaHandle);
                if (newSelection) {
                    selectedAreas.add(teamAreaHandle);
                    continue;
                }
                selectedAreas.remove(teamAreaHandle);
            }
        }
        String description = NLS.bind((String)Messages.TeamAreaSelector_0, (Object)Integer.toString(selectedAreas.size()), (Object)Integer.toString(totalCount));
        this.fDialog.updateDescription(description);
    }

    public void setAllChecked(boolean checked) {
        TreeItem[] roots = this.fViewer.getTree().getItems();
        int i = 0;
        while (i < roots.length) {
            TreeItem treeItem = roots[i];
            Object item = treeItem.getData();
            if (item instanceof IProjectArea) {
                this.setAllChecked((IProjectArea)item, checked);
            }
            ++i;
        }
        this.updateDescription();
    }

    private void setAllChecked(IProjectArea projectArea, boolean checked) {
        String uniqueKey = this.getUniqueKey(projectArea);
        Map<IProjectArea, Boolean> changedProjectAreas = this.fChangedProjectAreas.get(uniqueKey);
        if (changedProjectAreas == null) {
            changedProjectAreas = new HashMap<IProjectArea, Boolean>();
            this.fChangedProjectAreas.put(uniqueKey, changedProjectAreas);
        }
        changedProjectAreas.put(projectArea, checked);
        ItemHandleAwareHashMap changedTeamAreas = this.fChangedTeamAreas.get(this.getUniqueKey(projectArea));
        if (changedTeamAreas == null) {
            changedTeamAreas = new ItemHandleAwareHashMap();
            this.fChangedTeamAreas.put(this.getUniqueKey(projectArea), changedTeamAreas);
        }
        List teamAreas = projectArea.getTeamAreas();
        for (Object object : teamAreas) {
            ITeamAreaHandle teamArea = (ITeamAreaHandle)object;
            changedTeamAreas.put((Object)teamArea, (Object)checked);
        }
    }

    public void handleCheckStateChange(Object element, boolean checked) {
        if (element instanceof IProjectArea) {
            IProjectArea projectArea = (IProjectArea)element;
            String uniqueKey = this.getUniqueKey(projectArea);
            Map<IProjectArea, Boolean> changedProjectAreas = this.fChangedProjectAreas.get(uniqueKey);
            if (changedProjectAreas == null) {
                changedProjectAreas = new HashMap<IProjectArea, Boolean>();
                this.fChangedProjectAreas.put(uniqueKey, changedProjectAreas);
            }
            changedProjectAreas.put(projectArea, checked);
        } else if (element instanceof ITeamArea) {
            ITeamArea teamArea = (ITeamArea)element;
            String uniqueKey = this.getUniqueKey(teamArea.getProjectArea());
            ItemHandleAwareHashMap changedTeamAreas = this.fChangedTeamAreas.get(uniqueKey);
            if (changedTeamAreas == null) {
                changedTeamAreas = new ItemHandleAwareHashMap();
                this.fChangedTeamAreas.put(uniqueKey, changedTeamAreas);
            }
            changedTeamAreas.put((Object)teamArea, (Object)checked);
        }
        this.updateDescription();
    }

    protected String getUniqueKey(Object element) {
        String uniqueKey = null;
        if (element instanceof IProcessAreaHandle) {
            IProcessAreaHandle handle = (IProcessAreaHandle)element;
            ITeamRepository repository = (ITeamRepository)handle.getOrigin();
            uniqueKey = repository.getId() + handle.getItemId().getUuidValue();
        }
        return uniqueKey;
    }

    private static class LabelProvider
    extends StandardLabelProvider {
        public LabelProvider(ILabelProvider fallBackLabelProvider, IElementRemovedNotifier notifier) {
            super(fallBackLabelProvider, notifier);
        }

        public Color getBackground(Object element) {
            ViewerLabel label = new ViewerLabel(null, null);
            this.updateLabel(label, new TreePath(new Object[]{element}));
            return label.getBackground();
        }

        public Color getForeground(Object element) {
            ViewerLabel label = new ViewerLabel(null, null);
            this.updateLabel(label, new TreePath(new Object[]{element}));
            return label.getForeground();
        }

        public Font getFont(Object element) {
            ViewerLabel label = new ViewerLabel(null, null);
            this.updateLabel(label, new TreePath(new Object[]{element}));
            return label.getFont();
        }

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof TeamRepositoryExceptionNode) {
                label.setText(((TeamRepositoryExceptionNode)element).getMessage());
                label.setImage(this.getResources().createImageWithDefault(ImagePool.ERROR_TICK));
            } else {
                super.updateLabel(label, element);
            }
        }
    }

    private class LabelProviderListener
    implements ILabelProviderListener {
        private LabelProviderListener() {
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] elements = event.getElements();
            if (elements != null) {
                int i = 0;
                while (i < elements.length) {
                    Object element = elements[i];
                    ProcessAreaSelector.this.fViewer.update(element, null);
                    ++i;
                }
            }
        }
    }
}

