/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.internal.common.ItemHandleAwareHashMap;
import com.ibm.team.process.internal.rcp.ui.ItemHandleAwareHashSet;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessAreaSelector;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ProcessAreaFiltersDialog
extends Dialog {
    private ProcessAreaSelector fSelector;
    private Label fDescription;

    public ProcessAreaFiltersDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(Messages.TeamAreaFiltersDialog_0);
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(false).applyTo(composite);
        composite.setLayoutData((Object)new GridData(1808));
        this.fDescription = new Label(composite, 64);
        this.fDescription.setLayoutData((Object)new GridData(768));
        this.fSelector = new ProcessAreaSelector(this, composite);
        this.fSelector.setIncludeArchived(ProcessRCPUIPlugin.getDefault().getPluginPreferenceStore().getBoolean("teamArtifactsNavigator.showArchived"));
        this.fSelector.getViewer().getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ProcessAreaFiltersDialog.this.fDescription.getText();
            }
        });
        Composite buttonBar = new Composite(composite, 0);
        buttonBar.setLayoutData((Object)new GridData(131072, 4, false, false, 1, 1));
        GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).applyTo(buttonBar);
        Button selectAll = new Button(buttonBar, 8);
        selectAll.setText(Messages.TeamAreaFiltersDialog_1);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessAreaFiltersDialog.this.fSelector.selectAll(true);
            }
        });
        Button deselectAll = new Button(buttonBar, 8);
        deselectAll.setText(Messages.TeamAreaFiltersDialog_2);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessAreaFiltersDialog.this.fSelector.selectAll(false);
            }
        });
        this.fSelector.forceFocus();
        composite.layout();
        ProcessAreaFiltersDialog.applyDialogFont((Control)composite);
        this.setButtonLayoutData(selectAll);
        this.setButtonLayoutData(deselectAll);
        return composite;
    }

    protected void okPressed() {
        Map<String, Map<IProjectArea, Boolean>> changedProjectAreas;
        Map<String, ItemHandleAwareHashMap> changedTeamAreas = this.fSelector.getChangedTeamAreas();
        if (!changedTeamAreas.isEmpty()) {
            ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
            List connectedProjectAreas = registry.getConnectedProjectAreas(null);
            for (IProjectAreaHandle projectAreaHandle : connectedProjectAreas) {
                String uniqueKey = this.fSelector.getUniqueKey(projectAreaHandle);
                ItemHandleAwareHashMap changedTeamAreasToSelected = changedTeamAreas.get(uniqueKey);
                if (changedTeamAreasToSelected == null) continue;
                this.updateSelectedTeamAreasInRegistry(changedTeamAreasToSelected, projectAreaHandle);
            }
        }
        if (!(changedProjectAreas = this.fSelector.getChangedProjectAreas()).isEmpty()) {
            this.updateSelectedProjectAreasInRegistry(changedProjectAreas);
        }
        super.okPressed();
    }

    private void updateSelectedProjectAreasInRegistry(Map<String, Map<IProjectArea, Boolean>> changedProjectAreas) {
        ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        ItemHandleAwareHashSet currentlySelectedInRegistry = new ItemHandleAwareHashSet(registry.getSelectedProjectAreas());
        Collection<Map<IProjectArea, Boolean>> changedProjectAreaMaps = changedProjectAreas.values();
        for (Map<IProjectArea, Boolean> projectAreaSelections : changedProjectAreaMaps) {
            IProjectArea projectArea = projectAreaSelections.keySet().iterator().next();
            boolean isSelected = projectAreaSelections.get(projectArea);
            boolean inRegistry = registry.isSelected((IProjectAreaHandle)projectArea);
            if (isSelected && !inRegistry) {
                currentlySelectedInRegistry.add(projectArea);
                continue;
            }
            if (isSelected || !inRegistry) continue;
            currentlySelectedInRegistry.remove(projectArea);
        }
        registry.setSelectedProjectAreas(new ArrayList(currentlySelectedInRegistry));
    }

    private void updateSelectedTeamAreasInRegistry(ItemHandleAwareHashMap changedTeamAreasToSelected, IProjectAreaHandle projectAreaHandle) {
        ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        ItemHandleAwareHashSet selectedTeamAreas = new ItemHandleAwareHashSet(registry.getSelectedTeamAreas(projectAreaHandle));
        Iterator currentlySelected = selectedTeamAreas.iterator();
        while (currentlySelected.hasNext()) {
            ITeamAreaHandle selectedTeamArea = (ITeamAreaHandle)currentlySelected.next();
            Boolean selectedState = (Boolean)changedTeamAreasToSelected.remove((Object)selectedTeamArea);
            if (selectedState == null || selectedState.booleanValue()) continue;
            currentlySelected.remove();
            if (changedTeamAreasToSelected.isEmpty()) break;
        }
        if (!changedTeamAreasToSelected.isEmpty()) {
            Set changedTeamAreasKeys = changedTeamAreasToSelected.keySet();
            for (ITeamAreaHandle teamAreaHandle : changedTeamAreasKeys) {
                boolean selected = (Boolean)changedTeamAreasToSelected.get((Object)teamAreaHandle);
                if (!selected) continue;
                selectedTeamAreas.add(teamAreaHandle);
            }
        }
        registry.setSelectedTeamAreas(projectAreaHandle, new ArrayList(selectedTeamAreas));
    }

    public void updateDescription(String description) {
        this.fDescription.setText(description);
        this.fDescription.getParent().layout();
    }

    protected ProcessAreaSelector getTeamAreaSelector() {
        return this.fSelector;
    }
}

