/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.OpenProcessAreaFiltersDialogMenuAction;
import com.ibm.team.process.internal.rcp.ui.ProcessAreaFiltersDialog;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.internal.rcp.ui.SelectProcessAreasAction;
import com.ibm.team.process.internal.rcp.ui.ShowArchivedAction;
import com.ibm.team.process.internal.rcp.ui.ShowDeletedIterationsAction;
import com.ibm.team.process.rcp.ui.ProcessRCPUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class OpenProcessAreaFiltersDialogAction
extends Action
implements IMenuCreator {
    public static final String CUSTOM_PROCESS_AREA_FILTER_MEMENTO = "customTeamAreaFilterMemento";
    private Shell fShell;
    private Menu fMenu;
    private SelectProcessAreasAction fSelectMyProcessAreasAction;
    private SelectProcessAreasAction fSelectAllProcessAreasAction;
    private SelectProcessAreasAction fSelectCustomProcessAreasAction;
    private ShowArchivedAction fShowArchivedAction;
    private ShowDeletedIterationsAction fShowDeletedAction;
    private OpenProcessAreaFiltersDialogMenuAction fMenuAction;

    public OpenProcessAreaFiltersDialogAction(Shell shell) {
        this.fShell = shell;
        this.setMenuCreator(this);
        this.fSelectMyProcessAreasAction = new SelectProcessAreasAction(1);
        this.fSelectAllProcessAreasAction = new SelectProcessAreasAction(2);
        this.fSelectCustomProcessAreasAction = new SelectProcessAreasAction(0);
        this.fMenuAction = new OpenProcessAreaFiltersDialogMenuAction(this);
        this.fShowArchivedAction = new ShowArchivedAction();
        this.fShowDeletedAction = new ShowDeletedIterationsAction();
        IPreferenceStore preferences = ProcessRCPUI.getPreferenceStore();
        int filterType = preferences.getInt("teamArtifactsNavigator.activeFilter");
        switch (filterType) {
            case 0: {
                this.fSelectCustomProcessAreasAction.setChecked(true);
                this.fSelectCustomProcessAreasAction.run();
                break;
            }
            case 1: {
                this.fSelectMyProcessAreasAction.setChecked(true);
                this.fSelectMyProcessAreasAction.run();
                break;
            }
            case 2: {
                this.fSelectAllProcessAreasAction.setChecked(true);
                this.fSelectAllProcessAreasAction.run();
            }
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.process.rcp.ui", (String)"icons/copied/elcl16/filter_ps.gif");
    }

    public String getToolTipText() {
        return Messages.OpenTeamAreaFiltersDialogAction_2;
    }

    public String getText() {
        return Messages.OpenTeamAreaFiltersDialogAction_3;
    }

    public void run() {
        IPreferenceStore preferences = ProcessRCPUIPlugin.getDefault().getPreferenceStore();
        if (preferences.getInt("teamArtifactsNavigator.activeFilter") != 0) {
            this.fSelectCustomProcessAreasAction.run();
        }
        ProcessAreaFiltersDialog filter = new ProcessAreaFiltersDialog(this.fShell);
        filter.open();
        String stringMemento = preferences.getString("connectedProjectAreasMemento");
        preferences.setValue(CUSTOM_PROCESS_AREA_FILTER_MEMENTO, stringMemento);
        this.fSelectCustomProcessAreasAction.setChecked(true);
        this.fSelectAllProcessAreasAction.setChecked(false);
        this.fSelectMyProcessAreasAction.setChecked(false);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        ActionContributionItem item = new ActionContributionItem((IAction)this.fSelectAllProcessAreasAction);
        item.fill(this.fMenu, -1);
        item = new ActionContributionItem((IAction)this.fSelectMyProcessAreasAction);
        item.fill(this.fMenu, -1);
        item = new ActionContributionItem((IAction)this.fSelectCustomProcessAreasAction);
        item.fill(this.fMenu, -1);
        new MenuItem(this.fMenu, 2);
        item = new ActionContributionItem((IAction)this.fMenuAction);
        item.fill(this.fMenu, -1);
        new MenuItem(this.fMenu, 2);
        item = new ActionContributionItem((IAction)this.fShowArchivedAction);
        item.fill(this.fMenu, -1);
        item = new ActionContributionItem((IAction)this.fShowDeletedAction);
        item.fill(this.fMenu, -1);
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }
}

