/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.repository.client.ILicenseClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IContributorLicenseType;
import com.ibm.team.repository.common.ILicenseAdminService;
import com.ibm.team.repository.common.ILicenseAssignmentResult;
import com.ibm.team.repository.common.IServerLicenseType;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;

public class LicenseAdminLibrary {
    private final ITeamRepository fRepository;

    public LicenseAdminLibrary(ITeamRepository repository) {
        this.fRepository = repository;
    }

    private ILicenseAdminService getLicenseAdminService() {
        return (ILicenseAdminService)((IClientLibraryContext)this.fRepository).getServiceInterface(ILicenseAdminService.class);
    }

    private Object callCancelableService(IClientLibraryContext.IServiceRunnable runnable, IProgressMonitor monitor) throws TeamRepositoryException {
        return ((IClientLibraryContext)this.fRepository).callCancelableService(runnable, monitor);
    }

    public void revokeLicense(final String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) {
                LicenseAdminLibrary.this.getLicenseAdminService().restoreLicense(operationId);
                return null;
            }
        }, monitor);
        this.flushLicenseClientCache();
    }

    public void restoreLicense(final String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) {
                LicenseAdminLibrary.this.getLicenseAdminService().restoreLicense(operationId);
                return null;
            }
        }, monitor);
        this.flushLicenseClientCache();
    }

    public IContributorLicenseType[] getLicenseTypes(IProgressMonitor monitor) throws TeamRepositoryException {
        return (IContributorLicenseType[])this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return LicenseAdminLibrary.this.getLicenseAdminService().getLicenseTypes();
            }
        }, monitor);
    }

    public ILicenseAssignmentResult assignLicense(final IContributorHandle contributor, final String licenseId, IProgressMonitor monitor) throws TeamRepositoryException {
        ILicenseAssignmentResult result = (ILicenseAssignmentResult)this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public ILicenseAssignmentResult run(IProgressMonitor monitor) throws TeamRepositoryException {
                return LicenseAdminLibrary.this.getLicenseAdminService().assignLicenseWithResult(contributor, licenseId);
            }
        }, monitor);
        this.flushLicenseClientCache();
        return result;
    }

    public void unassignLicense(final IContributorHandle contributor, final String licenseId, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                LicenseAdminLibrary.this.getLicenseAdminService().unassignLicense(contributor, licenseId);
                return null;
            }
        }, monitor);
        this.flushLicenseClientCache();
    }

    public void unassignAllLicenses(final IContributorHandle contributor, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                LicenseAdminLibrary.this.getLicenseAdminService().unassignAllLicenses(contributor);
                return null;
            }
        }, monitor);
        this.flushLicenseClientCache();
    }

    public String[] getAssignedLicenses(final IContributorHandle contributor, IProgressMonitor monitor) throws TeamRepositoryException {
        return (String[])this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return LicenseAdminLibrary.this.getLicenseAdminService().getAssignedLicenses(contributor);
            }
        }, monitor);
    }

    public void setLicenseCount(final String licenseId, final Integer newMax, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                LicenseAdminLibrary.this.getLicenseAdminService().setLicensePurchaseCount(licenseId, newMax);
                return null;
            }
        }, monitor);
        this.flushLicenseClientCache();
    }

    public void addLicense(final byte[] licenseFileContents, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                LicenseAdminLibrary.this.getLicenseAdminService().addLicense(licenseFileContents);
                return null;
            }
        }, monitor);
        this.flushLicenseClientCache();
    }

    public void removeLicense(final byte[] licenseFileContents, IProgressMonitor monitor) throws TeamRepositoryException {
        this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                LicenseAdminLibrary.this.getLicenseAdminService().removeLicense(licenseFileContents);
                return null;
            }
        }, monitor);
        this.flushLicenseClientCache();
    }

    private void flushLicenseClientCache() {
        ILicenseClient licenseClient = (ILicenseClient)this.fRepository.getClientLibrary(ILicenseClient.class);
        licenseClient.flushCache();
    }

    public IServerLicenseType getServerLicenseType(IProgressMonitor monitor) throws TeamRepositoryException {
        return (IServerLicenseType)this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return LicenseAdminLibrary.this.getLicenseAdminService().getServerLicenseType();
            }
        }, monitor);
    }

    public IContributorHandle[] getLicensedContributors(final String licenseId, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IContributorHandle[])this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return LicenseAdminLibrary.this.getLicenseAdminService().getLicensedContributors(licenseId);
            }
        }, monitor);
    }
}

