/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.HistoryCombo;
import com.ibm.team.process.rcp.ui.ILoginInfoUIProvider;
import com.ibm.team.process.rcp.ui.IUIValidationCallback;
import com.ibm.team.process.rcp.ui.Messages;
import com.ibm.team.repository.client.ILoginInfo2;
import com.ibm.team.repository.client.SavedPasswordNotObtainedException;
import com.ibm.team.repository.client.internal.login.KerberosLoginUtils;
import com.ibm.team.repository.client.login.KerberosLoginInfo;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.osgi.service.prefs.Preferences;

public class KerberosLoginInfoUIProvider
implements ILoginInfoUIProvider {
    private static final String EMPTY_STRING = "";
    private Preferences dialogPrefs = this.getConfigPrefs().node("dialog");
    private String kerberosRealm = null;
    private String kerberosKdc = null;
    private String kerberosConfigPath = null;
    private String oldKerberosRealm = null;
    private String oldKerberosKdc = null;
    private String oldKerberosConfigPath = null;
    private boolean restartRequired = false;
    private HistoryCombo kerberosRealmText;
    private HistoryCombo kerberosKdcText;
    private HistoryCombo kerberosConfigPathText;
    private KerberosLoginInfo info = new KerberosLoginInfo();
    private ExpandableComposite kerberosComposite;
    private IUIValidationCallback validationCallback;
    private ControlDecoration kerberosRealmDec;
    private ControlDecoration kerberosKDCDec;
    private ControlDecoration kerberosPathDec;
    private Button btnBrowse;

    public KerberosLoginInfoUIProvider() {
        this.kerberosRealm = KerberosLoginUtils.getKerberosRealm();
        this.kerberosKdc = KerberosLoginUtils.getKerberosKdc();
        this.kerberosConfigPath = KerberosLoginUtils.getKerberosConfigPath();
    }

    private Preferences getConfigPrefs() {
        IEclipsePreferences prefs = new InstanceScope().getNode("com.ibm.team.process.rcp.ui");
        Preferences edilogPrefs = prefs.node(this.getClass().getName());
        return edilogPrefs;
    }

    protected ExpandableComposite createExpandableSection(Composite parent) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, 18);
        excomposite.setText(Messages.KerberosLoginInfoUIProvider_32);
        excomposite.setExpanded(false);
        excomposite.setLayoutData((Object)new GridData(4, 4, true, true));
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ExpandableComposite excomposite = (ExpandableComposite)e.getSource();
                Composite reflowParent = excomposite.getParent();
                while (reflowParent != null) {
                    if (reflowParent instanceof ScrolledComposite) {
                        reflowParent = reflowParent.getParent().getParent().getParent().getParent().getParent();
                        reflowParent.setRedraw(false);
                        reflowParent.layout(true, true);
                        reflowParent.setRedraw(true);
                        break;
                    }
                    if (reflowParent instanceof Shell) {
                        reflowParent.setSize(reflowParent.computeSize(-1, -1));
                        break;
                    }
                    reflowParent = reflowParent.getParent();
                }
            }
        });
        excomposite.setLayout((Layout)new GridLayout());
        return excomposite;
    }

    @Override
    public Control createContents(Composite parent2, IUIValidationCallback vc) {
        this.validationCallback = vc;
        Composite parent = new Composite(parent2, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        this.kerberosComposite = this.createExpandableSection(parent);
        this.kerberosComposite.setClient((Control)this.createAdvancedOptions(this.kerberosComposite));
        this.populate();
        this.attachListeners();
        this.kerberosComposite.setExpanded(true);
        this.kerberosComposite.setExpanded(false);
        if (this.validationCallback != null) {
            this.validationCallback.validate();
        }
        return parent;
    }

    private void attachListeners() {
        this.kerberosRealmText.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Combo combo = KerberosLoginInfoUIProvider.this.kerberosRealmText.getCombo();
                KerberosLoginInfoUIProvider.this.kerberosRealm = combo.getText();
                KerberosLoginInfoUIProvider.this.kerberosRealmText.addToHistory();
                if (KerberosLoginInfoUIProvider.this.oldKerberosRealm != null && KerberosLoginInfoUIProvider.this.oldKerberosKdc != null) {
                    KerberosLoginInfoUIProvider.this.restartRequired = !KerberosLoginInfoUIProvider.this.oldKerberosRealm.equalsIgnoreCase(KerberosLoginInfoUIProvider.this.kerberosRealm) || !KerberosLoginInfoUIProvider.this.oldKerberosKdc.equalsIgnoreCase(KerberosLoginInfoUIProvider.this.kerberosKdc);
                }
                if (KerberosLoginInfoUIProvider.this.validationCallback != null) {
                    KerberosLoginInfoUIProvider.this.validationCallback.validate();
                }
            }
        });
        this.kerberosKdcText.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Combo combo = KerberosLoginInfoUIProvider.this.kerberosKdcText.getCombo();
                KerberosLoginInfoUIProvider.this.kerberosKdc = combo.getText();
                KerberosLoginInfoUIProvider.this.kerberosKdcText.addToHistory();
                if (KerberosLoginInfoUIProvider.this.oldKerberosRealm != null && KerberosLoginInfoUIProvider.this.oldKerberosKdc != null) {
                    KerberosLoginInfoUIProvider.this.restartRequired = !KerberosLoginInfoUIProvider.this.oldKerberosRealm.equalsIgnoreCase(KerberosLoginInfoUIProvider.this.kerberosRealm) || !KerberosLoginInfoUIProvider.this.oldKerberosKdc.equalsIgnoreCase(KerberosLoginInfoUIProvider.this.kerberosKdc);
                }
                if (KerberosLoginInfoUIProvider.this.validationCallback != null) {
                    KerberosLoginInfoUIProvider.this.validationCallback.validate();
                }
            }
        });
        this.kerberosConfigPathText.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Combo combo = KerberosLoginInfoUIProvider.this.kerberosConfigPathText.getCombo();
                KerberosLoginInfoUIProvider.this.kerberosConfigPath = combo.getText();
                KerberosLoginInfoUIProvider.this.kerberosConfigPathText.addToHistory();
                if (KerberosLoginInfoUIProvider.this.oldKerberosConfigPath != null) {
                    KerberosLoginInfoUIProvider.this.restartRequired = !KerberosLoginInfoUIProvider.this.oldKerberosConfigPath.equals(KerberosLoginInfoUIProvider.this.kerberosConfigPath);
                }
                if (KerberosLoginInfoUIProvider.this.validationCallback != null) {
                    KerberosLoginInfoUIProvider.this.validationCallback.validate();
                }
            }
        });
    }

    private GridData setControlGridData(Control ctrl) {
        GridData gd = new GridData(4, 0x1000000, true, false);
        GC gc = new GC((Drawable)Display.getDefault());
        try {
            gc.setFont(JFaceResources.getDialogFont());
            gd.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)32);
        }
        finally {
            gc.dispose();
        }
        ctrl.setLayoutData((Object)gd);
        return gd;
    }

    private Composite createAdvancedOptions(ExpandableComposite kerberosComposite) {
        Composite parent = new Composite((Composite)kerberosComposite, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginLeft = 5;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        final Label kerberosRealmID = new Label(parent, 0);
        kerberosRealmID.setText(Messages.KerberosLoginInfoUIProvider_28);
        this.kerberosRealmText = new HistoryCombo(parent, this.dialogPrefs.node("kerberosRealm"), false);
        this.setControlGridData((Control)this.kerberosRealmText.getCombo()).horizontalSpan = 2;
        this.kerberosRealmText.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = kerberosRealmID.getText();
            }
        });
        this.kerberosRealmDec = new ControlDecoration(this.kerberosRealmText.getControl(), 16512);
        this.kerberosRealmDec.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        this.kerberosRealmDec.setDescriptionText(Messages.KerberosLoginInfoUIProvider_33);
        this.kerberosRealmDec.hide();
        final Label kerberosKdcID = new Label(parent, 0);
        kerberosKdcID.setText(Messages.KerberosLoginInfoUIProvider_29);
        this.kerberosKdcText = new HistoryCombo(parent, this.dialogPrefs.node("kerberosKdc"), false);
        this.setControlGridData((Control)this.kerberosKdcText.getCombo()).horizontalSpan = 2;
        this.kerberosKdcText.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = kerberosKdcID.getText();
            }
        });
        this.kerberosKDCDec = new ControlDecoration(this.kerberosKdcText.getControl(), 16512);
        this.kerberosKDCDec.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        this.kerberosKDCDec.setDescriptionText(Messages.KerberosLoginInfoUIProvider_33);
        this.kerberosKDCDec.hide();
        final Label kerberosConfigPathID = new Label(parent, 0);
        kerberosConfigPathID.setText(Messages.KerberosLoginInfoUIProvider_30);
        this.kerberosConfigPathText = new HistoryCombo(parent, this.dialogPrefs.node("kerberosConfigpath"), false);
        this.setControlGridData((Control)this.kerberosConfigPathText.getCombo());
        this.kerberosConfigPathText.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = kerberosConfigPathID.getText();
            }
        });
        this.kerberosPathDec = new ControlDecoration(this.kerberosConfigPathText.getControl(), 16512);
        this.kerberosPathDec.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        this.kerberosPathDec.setDescriptionText(Messages.KerberosLoginInfoUIProvider_33);
        this.kerberosPathDec.hide();
        this.btnBrowse = new Button(parent, 8);
        this.btnBrowse.setText(Messages.KerberosLoginInfoUIProvider_1);
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell());
                dialog.setFilterExtensions(new String[]{"krb5.*", "*.*"});
                dialog.setFilterNames(new String[]{Messages.KerberosLoginInfoUIProvider_37, Messages.KerberosLoginInfoUIProvider_38});
                dialog.setText(Messages.KerberosLoginInfoUIProvider_2);
                String location = dialog.open();
                if (location != null) {
                    KerberosLoginInfoUIProvider.this.kerberosConfigPathText.getCombo().setText(location);
                }
            }
        });
        return parent;
    }

    @Override
    public ILoginInfo2 getLoginInfo() {
        if (this.restartRequired) {
            KerberosLoginUtils.restartRequired();
        }
        KerberosLoginUtils.setKerberosRealm((String)this.kerberosRealm);
        KerberosLoginUtils.setKerberosKdc((String)this.kerberosKdc);
        KerberosLoginUtils.setKerberosConfigPath((String)this.kerberosConfigPath);
        return this.info;
    }

    @Override
    public void populate(ILoginInfo2 loginInfo) throws SavedPasswordNotObtainedException {
        this.populate(loginInfo, true);
    }

    @Override
    public void populate(ILoginInfo2 loginInfo, boolean rememberPassword) throws SavedPasswordNotObtainedException {
        this.populate();
    }

    private void populate() {
        if (this.kerberosComposite != null && !this.kerberosComposite.isDisposed()) {
            this.kerberosComposite.setExpanded(false);
        }
        if (KerberosLoginUtils.isSuccessfullyLoggedIn()) {
            this.oldKerberosRealm = this.kerberosRealm;
            this.oldKerberosKdc = this.kerberosKdc;
            this.oldKerberosConfigPath = this.kerberosConfigPath;
        } else {
            this.oldKerberosRealm = null;
            this.oldKerberosKdc = null;
            this.oldKerberosConfigPath = null;
        }
        this.setKerberosRealmTextValue(this.kerberosRealm);
        this.setKerberosKdcTextValue(this.kerberosKdc);
        this.setKerberosConfigPathTextValue(this.kerberosConfigPath);
    }

    private boolean isValidConfigFile(String kerberosConfigPath) {
        File file = new File(kerberosConfigPath);
        return file.exists() && !file.isDirectory();
    }

    @Override
    public void clear() {
        this.setKerberosRealmTextValue(EMPTY_STRING);
        this.setKerberosKdcTextValue(EMPTY_STRING);
        this.setKerberosConfigPathTextValue(EMPTY_STRING);
    }

    private void setKerberosRealmTextValue(String value) {
        boolean comboIsValid;
        boolean bl = comboIsValid = this.kerberosRealmText != null && !this.kerberosRealmText.getCombo().isDisposed();
        if (value != null && comboIsValid) {
            this.kerberosRealmText.getCombo().setText(value);
            if (KerberosLoginUtils.isKerberosRealmPreset()) {
                this.kerberosRealmText.getCombo().setEnabled(false);
                this.kerberosRealmDec.show();
            } else {
                this.kerberosRealmText.getCombo().setEnabled(true);
                this.kerberosRealmDec.hide();
            }
        }
    }

    private void setKerberosKdcTextValue(String value) {
        boolean comboIsValid;
        boolean bl = comboIsValid = this.kerberosKdcText != null && !this.kerberosKdcText.getCombo().isDisposed();
        if (value != null && comboIsValid) {
            this.kerberosKdcText.getCombo().setText(value);
            if (KerberosLoginUtils.isKerberosKdcPreset()) {
                this.kerberosKdcText.getCombo().setEnabled(false);
                this.kerberosKDCDec.show();
            } else {
                this.kerberosKdcText.getCombo().setEnabled(true);
                this.kerberosKDCDec.hide();
            }
        }
    }

    private void setKerberosConfigPathTextValue(String value) {
        boolean comboIsValid;
        boolean bl = comboIsValid = this.kerberosConfigPathText != null && !this.kerberosConfigPathText.getCombo().isDisposed();
        if (value != null && comboIsValid) {
            this.kerberosConfigPathText.getCombo().setText(value);
            if (KerberosLoginUtils.isKerberosConfigPathPreset()) {
                this.kerberosConfigPathText.getCombo().setEnabled(false);
                this.btnBrowse.setEnabled(false);
                this.kerberosPathDec.show();
            } else {
                this.kerberosConfigPathText.getCombo().setEnabled(true);
                this.btnBrowse.setEnabled(true);
                this.kerberosPathDec.hide();
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.getValidationStatus() == null || this.getValidationStatus().getSeverity() != 4;
    }

    @Override
    public IStatus getValidationStatus() {
        if (this.restartRequired || KerberosLoginUtils.isRestartRequired()) {
            return new Status(2, "com.ibm.team.process.rcp.ui", Messages.KerberosLoginInfoUIProvider_31);
        }
        if (this.isEmpty(this.kerberosKdc) && !this.isEmpty(this.kerberosRealm) || !this.isEmpty(this.kerberosKdc) && this.isEmpty(this.kerberosRealm)) {
            return new Status(4, "com.ibm.team.process.rcp.ui", Messages.KerberosLoginInfoUIProvider_35);
        }
        if (!this.isEmpty(this.kerberosConfigPath) && !this.isValidConfigFile(this.kerberosConfigPath)) {
            return new Status(4, "com.ibm.team.process.rcp.ui", Messages.KerberosLoginInfoUIProvider_36);
        }
        return null;
    }

    private boolean isEmpty(String text) {
        return text == null || text.trim().length() == 0;
    }

    @Override
    public void dispose() {
        this.validationCallback = null;
    }
}

