/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class HistoryCombo {
    private static final String PREF_HISTORY = "history";
    private static final int MAX_HISTORY_LENGTH = 20;
    private Combo fCombo;
    private Preferences fPreferences;

    public HistoryCombo(Composite parent, Preferences savedState, boolean autoSelect) {
        this.fCombo = new Combo(parent, 4);
        this.fPreferences = savedState;
        if (savedState != null) {
            this.loadState(this.fCombo, savedState);
        }
        if (this.fCombo.getItemCount() > 0 && autoSelect) {
            this.fCombo.select(0);
        }
    }

    private void loadState(Combo combo, Preferences savedState) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < 20) {
            block3: {
                try {
                    Preferences child;
                    String next;
                    if (!savedState.nodeExists(PREF_HISTORY + i) || (next = (child = savedState.node(PREF_HISTORY + i)).get("value", "")).length() <= 0) break block3;
                    result.add(next);
                }
                catch (BackingStoreException e) {
                    break;
                }
            }
            ++i;
        }
        combo.setItems(result.toArray(new String[result.size()]));
    }

    protected void reload() {
        this.loadState(this.fCombo, this.fPreferences);
    }

    public Combo getCombo() {
        return this.fCombo;
    }

    public Control getControl() {
        return this.fCombo;
    }

    public String[] getHistory() {
        return this.fCombo.getItems();
    }

    public void addToHistory(String toAdd, boolean updateControl) {
        String[] items = this.fCombo.getItems();
        String[] unfiltered = new String[items.length + 1];
        unfiltered[0] = toAdd;
        System.arraycopy(items, 0, unfiltered, 1, items.length);
        String[] newItems = this.filterStrings(unfiltered);
        int toCopy = Math.min(newItems.length, 20);
        String[] newItemsArray = Arrays.copyOfRange(newItems, 0, toCopy);
        if (updateControl) {
            this.fCombo.setItems(newItemsArray);
        }
        try {
            this.save(this.fPreferences, newItemsArray);
            this.fPreferences.flush();
        }
        catch (BackingStoreException e) {
            ProcessRCPUIPlugin.getDefault().log(e);
        }
    }

    public void addToHistory() {
        this.addToHistory(this.fCombo.getText(), false);
    }

    private void save(Preferences whereToSave, String[] items) throws BackingStoreException {
        int i = items.length;
        while (i < 20) {
            if (whereToSave.nodeExists(PREF_HISTORY + i)) {
                whereToSave.node(PREF_HISTORY + i).removeNode();
            }
            ++i;
        }
        i = 0;
        while (i < items.length) {
            whereToSave.node(PREF_HISTORY + i).put("value", items[i]);
            ++i;
        }
    }

    private String[] filterStrings(String[] items) {
        ArrayList<String> strings = new ArrayList<String>();
        int i = 0;
        while (i < items.length) {
            String item = items[i];
            if (item != null && item.trim().length() > 0 && !this.containsEqualPath(strings, item)) {
                strings.add(item);
            }
            ++i;
        }
        return strings.toArray(new String[strings.size()]);
    }

    private boolean containsEqualPath(List strings, String string) {
        Path path = new Path(string);
        Iterator iterator = strings.iterator();
        while (iterator.hasNext()) {
            if (!path.equals((Object)new Path((String)iterator.next()))) continue;
            return true;
        }
        return false;
    }
}

