/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.DisplayHelper;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ErrorUtil {
    public static IStatus createStatus(String message, Throwable exception) {
        Throwable throwable = exception;
        ArrayList<Status> causes = new ArrayList<Status>(3);
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
            String causeMessage = throwable.getMessage();
            Status child = new Status(4, "com.ibm.team.process.rcp.ui", causeMessage);
            causes.add(child);
        }
        int count = causes.size();
        if (count == 0) {
            String causeMessage = throwable.getMessage();
            return new Status(4, "com.ibm.team.process.rcp.ui", causeMessage);
        }
        IStatus[] children = new IStatus[count];
        causes.toArray(children);
        return new MultiStatus("com.ibm.team.process.rcp.ui", 4, children, message, exception);
    }

    public static Shell getNewShell() {
        Display display;
        IWorkbenchWindow[] windows;
        Shell shell = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
            window = windows[0];
        }
        if (window != null) {
            shell = window.getShell();
        }
        if ((shell == null || shell.isDisposed()) && (display = Display.getCurrent()) != null) {
            shell = display.getActiveShell();
        }
        return shell;
    }

    public static void reportException(final String dialogTitle, TeamRepositoryException exception) {
        final Shell shell = ErrorUtil.getNewShell();
        if (shell != null) {
            final IStatus status = ErrorUtil.createStatus(exception.getMessage(), exception);
            DisplayHelper.asyncExec((Control)shell, new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)shell, (String)dialogTitle, null, (IStatus)status);
                }
            });
        }
        ProcessRCPUIPlugin.getDefault().log(exception);
    }
}

