/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.foundation.rcp.ui.dnd.ViewerDragSupport;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.util.ConvertingSelectionProvider;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.process.internal.rcp.ui.DelegatingComparer;
import com.ibm.team.process.internal.rcp.ui.DelegatingTreePathContentProvider2;
import com.ibm.team.process.internal.rcp.ui.DelegatingTreePathLabelProvider2;
import com.ibm.team.process.internal.rcp.ui.DelegatingTreePathSorter;
import com.ibm.team.process.internal.rcp.ui.DomainManager;
import com.ibm.team.process.internal.rcp.ui.DomainSelection;
import com.ibm.team.process.internal.rcp.ui.IDomainNavigator;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.rcp.ui.ContextMenuHelper2;
import com.ibm.team.process.rcp.ui.teamnavigator.Category;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.UIJob;

public class DomainNavigator2
implements IDomainNavigator {
    private Map fValidationJobs = new HashMap();
    private final IWorkbenchPart fWorkbenchPart;
    private TreeViewer fTreeViewer;
    private ISelectionProvider fSelectionProvider;
    private Category fCategory;
    private DomainManager fDomainManager;

    public DomainNavigator2(IWorkbenchPart workbenchPart) {
        this.fWorkbenchPart = workbenchPart;
    }

    @Override
    public IWorkbenchPart getWorkbenchPart() {
        return this.fWorkbenchPart;
    }

    @Override
    public void refresh() {
        if (this.fTreeViewer != null && !this.fTreeViewer.getControl().isDisposed()) {
            this.fTreeViewer.refresh();
        }
    }

    public void configure(Category category, IConnectedProjectAreaRegistry registry) {
        this.fCategory = category;
        this.fDomainManager = new DomainManager(this, category, registry);
        if (this.fTreeViewer != null) {
            this.initializeTreeViewer();
        }
    }

    private void setSelectionProvider(ISelectionProvider provider) {
        this.fSelectionProvider = provider;
    }

    public ISelection getOriginalSelection() {
        return ((DomainSelection)this.fSelectionProvider.getSelection()).getOriginal();
    }

    public Control createPartControl(Composite parent, FormToolkit toolkit) {
        this.fTreeViewer = new TreeViewer(toolkit.createTree(parent, 2562));
        this.fTreeViewer.setUseHashlookup(true);
        this.addDragSupport(this.fTreeViewer);
        if (this.fDomainManager != null) {
            this.initializeTreeViewer();
        }
        return this.fTreeViewer.getControl();
    }

    private void initializeTreeViewer() {
        DelegatingTreePathContentProvider2 delegatingContentProvider = new DelegatingTreePathContentProvider2(this.fDomainManager, this.fCategory);
        DelegatingTreePathLabelProvider2 delegatingLabelProvider = new DelegatingTreePathLabelProvider2(this.fDomainManager, this.fCategory, (IElementRemovedNotifier)delegatingContentProvider);
        this.fTreeViewer.setContentProvider((IContentProvider)delegatingContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)delegatingLabelProvider);
        this.fTreeViewer.setSorter((ViewerSorter)new DelegatingTreePathSorter(this.fDomainManager));
        this.fTreeViewer.setComparer((IElementComparer)new DelegatingComparer(this.fDomainManager));
        this.fTreeViewer.setInput((Object)this.fDomainManager);
        this.fTreeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                DomainNavigator2.this.openSelection(DomainNavigator2.this.fSelectionProvider.getSelection(), false);
            }
        });
        this.fTreeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                DomainNavigator2.this.validateCategoryElement(event.getElement());
            }
        });
        this.setSelectionProvider((ISelectionProvider)new ConvertingSelectionProvider((ISelectionProvider)this.fTreeViewer){

            protected ISelection convertFrom(ISelection viewerSelection) {
                return DomainNavigator2.this.convertSelection2Model(viewerSelection);
            }
        });
        this.hookContextMenu(this.fTreeViewer);
        new TooltipSupport(this.fTreeViewer.getControl(), true, true){
            private Domain fCurrentDomain;
            private TreePath fPath;

            protected Object mapElement(int x, int y) {
                Object element = super.mapElement(x, y);
                this.fCurrentDomain = null;
                this.fPath = null;
                if (element != null) {
                    LinkedList<Object> pathelems = new LinkedList<Object>();
                    pathelems.add(element);
                    TreeItem item = DomainNavigator2.this.fTreeViewer.getTree().getItem(new Point(x, y));
                    while (item.getParentItem() != null) {
                        item = item.getParentItem();
                        Object data = item.getData();
                        pathelems.addFirst(data);
                        if (!(data instanceof DomainSubtreeRoot)) continue;
                        this.fCurrentDomain = ((DomainSubtreeRoot)data).getDomain();
                    }
                    this.fPath = new TreePath(pathelems.toArray());
                    if (this.fCurrentDomain == null) {
                        this.fCurrentDomain = DomainNavigator2.this.fDomainManager.getDomain(element);
                    }
                    if (this.fCurrentDomain != null) {
                        try {
                            element = this.fCurrentDomain.convertToModel(element);
                        }
                        catch (RuntimeException e) {
                            DomainNavigator2.this.discardDomain(this.fCurrentDomain, e, true);
                        }
                    }
                }
                return element;
            }

            protected String getMarkup(Object element, boolean isFocus) {
                String markup = super.getMarkup(element, isFocus);
                if (markup != null) {
                    return markup;
                }
                if (element != null && this.fCurrentDomain != null) {
                    try {
                        return this.fCurrentDomain.getHoverMarkupForObject(element);
                    }
                    catch (RuntimeException e) {
                        DomainNavigator2.this.discardDomain(this.fCurrentDomain, e, true);
                    }
                }
                return null;
            }

            protected void openRequested(Object element) {
                TreeSelection treesel = new TreeSelection(this.fPath);
                ArrayList<Object> elts = new ArrayList<Object>();
                elts.add(element);
                DomainSelection ds = new DomainSelection((IStructuredSelection)treesel, elts);
                DomainNavigator2.this.openSelection((ISelection)ds, true);
            }
        };
    }

    public void validateCategoryElement(final Object element) {
        if (this.fCategory.isCategoryElement(element) && !this.fCategory.isValid(element) && !this.fValidationJobs.containsKey(element)) {
            Job job = new Job(this.fCategory.getValidationJobName(element)){

                protected IStatus run(IProgressMonitor monitor) {
                    DomainNavigator2.this.fCategory.makeValid(element, monitor);
                    new UIJob(Messages.DomainNavigator2_0){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (DomainNavigator2.this.fTreeViewer.getTree().isDisposed()) {
                                return Status.OK_STATUS;
                            }
                            if (DomainNavigator2.this.fCategory.isValid(element)) {
                                DomainNavigator2.this.fTreeViewer.expandToLevel(element, 1);
                            } else {
                                DomainNavigator2.this.fTreeViewer.collapseToLevel(element, -1);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                    DomainNavigator2.this.fValidationJobs.remove(element);
                    return Status.OK_STATUS;
                }
            };
            this.fValidationJobs.put(element, job);
            job.schedule();
        }
    }

    public void setSelection(ISelection selection) {
        if (this.fSelectionProvider != null) {
            this.fSelectionProvider.setSelection(selection);
        }
    }

    public Domain[] getDomains() {
        return this.fDomainManager.getDomains();
    }

    ISelection convertSelection2Model(ISelection selection) {
        return this.convertSelection(selection, false);
    }

    ISelection convertModel2Selection(ISelection selection) {
        return this.convertSelection(selection, true);
    }

    private ISelection convertSelection(ISelection selection, boolean isModelSelection) {
        if (selection instanceof ITreeSelection) {
            ITreeSelection ss = (ITreeSelection)selection;
            TreePath[] paths = ss.getPaths();
            ArrayList<Object> result = new ArrayList<Object>(paths.length);
            int i = 0;
            while (i < paths.length) {
                Object object = paths[i].getLastSegment();
                if (paths[i].getSegmentCount() == 1 && this.fCategory.isCategoryElement(object)) {
                    result.add(this.fCategory.convertModel(object));
                } else {
                    Domain domain = null;
                    domain = paths[i].getSegmentCount() > 1 && paths[i].getSegment(1) instanceof DomainSubtreeRoot ? ((DomainSubtreeRoot)paths[i].getSegment(1)).getDomain() : this.fDomainManager.getDomain(object);
                    if (domain != null) {
                        Object r = null;
                        try {
                            if (isModelSelection) {
                                r = domain.convertToSelection(object);
                            } else {
                                DomainSubtreeRoot doro = null;
                                if (object instanceof DomainSubtreeRoot) {
                                    doro = (DomainSubtreeRoot)object;
                                }
                                r = domain.convertToModel(object);
                                if (doro != null && r == object) {
                                    r = doro;
                                }
                            }
                        }
                        catch (RuntimeException e) {
                            this.discardDomain(domain, e, true);
                        }
                        if (r != null) {
                            result.add(r);
                        }
                    }
                }
                ++i;
            }
            return new DomainSelection((IStructuredSelection)ss, result);
        }
        return selection;
    }

    private void hookContextMenu(TreeViewer viewer) {
        MenuManager menuMgr = new MenuManager("#TeamArtifactsPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)manager);
                ContextMenuHelper2.addStandardActions(manager, DomainNavigator2.this.fSelectionProvider, (IWorkbenchSite)DomainNavigator2.this.fWorkbenchPart.getSite(), IMenuOperationTarget.ALL_TYPES);
                DomainNavigator2.this.addDomainActions(manager);
            }
        });
        final Menu menu = menuMgr.createContextMenu(viewer.getControl());
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                menu.setDefaultItem(DomainNavigator2.this.findItemForAction(menu, "jazz.open"));
            }
        });
        this.fWorkbenchPart.getSite().registerContextMenu(String.valueOf(this.fWorkbenchPart.getSite().getId()) + ".teamArtifacts", menuMgr, (ISelectionProvider)viewer);
        viewer.getControl().setMenu(menu);
    }

    private MenuItem findItemForAction(Menu menu, String id) {
        MenuItem[] items = menu.getItems();
        int i = 0;
        while (i < items.length) {
            ActionContributionItem ci;
            MenuItem item = items[i];
            if (item.getData() instanceof ActionContributionItem && id.equals((ci = (ActionContributionItem)item.getData()).getId())) {
                return item;
            }
            ++i;
        }
        return null;
    }

    private void addDomainActions(final IMenuManager manager) {
        ISelection selection = this.fSelectionProvider.getSelection();
        if (selection instanceof DomainSelection) {
            DomainSelection domsel = (DomainSelection)selection;
            TreeSelection origtreesel = (TreeSelection)domsel.getOriginal();
            Domain domain = null;
            TreePath[] paths = origtreesel.getPaths();
            int i = 0;
            while (i < paths.length) {
                Domain actdomain = null;
                if (paths[i].getFirstSegment() instanceof DomainSubtreeRoot) {
                    actdomain = ((DomainSubtreeRoot)paths[i].getFirstSegment()).getDomain();
                }
                if (domain == null) {
                    domain = actdomain;
                } else if (domain != actdomain) {
                    return;
                }
                ++i;
            }
            if (domain == null) {
                return;
            }
            final Domain finalDomain = domain;
            final IStructuredSelection origsel = domsel.getOriginal();
            ContextMenuHelper.addNewSubmenu((IMenuManager)manager, (boolean)false);
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    finalDomain.contributeContextMenuActions(manager, origsel);
                }
            });
        }
    }

    private void addDragSupport(TreeViewer treeViewer) {
        new ViewerDragSupport((Viewer)treeViewer, 7){

            public ISelection getSelection() {
                ISelectionProvider provider = DomainNavigator2.this.fSelectionProvider;
                if (provider != null) {
                    return provider.getSelection();
                }
                return super.getSelection();
            }
        };
    }

    public void openSelection(ISelection selection, boolean openContainers) {
        HashMap<Domain, ArrayList<Object>> selections = new HashMap<Domain, ArrayList<Object>>();
        if (selection instanceof DomainSelection) {
            DomainSelection domsel = (DomainSelection)selection;
            TreeSelection treeSelection = (TreeSelection)domsel.getOriginal();
            TreePath[] paths = treeSelection.getPaths();
            int i = 0;
            while (i < paths.length) {
                if (paths[i].getSegmentCount() > 1 && paths[i].getFirstSegment() instanceof DomainSubtreeRoot) {
                    Domain domain = ((DomainSubtreeRoot)paths[i].getFirstSegment()).getDomain();
                    Object element = domain.convertToModel(paths[i].getLastSegment());
                    ArrayList<Object> list = (ArrayList<Object>)selections.get(domain);
                    if (list == null) {
                        list = new ArrayList<Object>();
                        selections.put(domain, list);
                    }
                    list.add(element);
                }
                ++i;
            }
            boolean opened = false;
            for (Map.Entry domainEntry : selections.entrySet()) {
                StructuredSelection s = new StructuredSelection((List)domainEntry.getValue());
                try {
                    if (!((Domain)domainEntry.getKey()).open(this.fWorkbenchPart.getSite(), (IStructuredSelection)s)) continue;
                    opened = true;
                }
                catch (RuntimeException e) {
                    ProcessRCPUIPlugin.getDefault().log(NLS.bind((String)Messages.DomainNavigator2_6, (Object)((Domain)domainEntry.getKey()).getName()), e);
                    return;
                }
            }
            if (domsel.size() == 1 && !opened) {
                this.fTreeViewer.setExpandedState(treeSelection.getFirstElement(), !this.fTreeViewer.getExpandedState(treeSelection.getFirstElement()));
            }
        }
    }

    protected void discardDomain(Domain domain, RuntimeException e, boolean refresh) {
        ProcessRCPUIPlugin.getDefault().log(NLS.bind((String)Messages.DomainNavigator2_7, (Object)domain.getName()), e);
        this.fDomainManager.unloadDomain(domain, refresh);
    }

    public void dispose() {
        IElementComparer comparer = this.fTreeViewer.getComparer();
        if (comparer instanceof DelegatingComparer) {
            ((DelegatingComparer)comparer).dispose();
        }
        this.setSelection(null);
        if (this.fDomainManager != null) {
            this.fDomainManager.dispose();
        }
    }
}

