/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.internal.rcp.ui.DomainManager;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.rcp.ui.teamnavigator.Category;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class DelegatingTreePathLabelProvider
extends LabelProvider
implements ITreePathLabelProvider,
IColorProvider,
IFontProvider {
    private DomainManager fDomainManager;
    private Category fGroupingCategory;
    private StandardLabelProvider fStdLabelProvider;

    public DelegatingTreePathLabelProvider(DomainManager domainManager, Category category, IElementRemovedNotifier notifier) {
        this.fDomainManager = domainManager;
        this.fGroupingCategory = category;
        this.fStdLabelProvider = new StandardLabelProvider(notifier);
    }

    private void registerListener(ILabelProviderListener listener, boolean isRemove) {
        Domain[] domains = this.fDomainManager.getDomains();
        int i = 0;
        while (i < domains.length) {
            ITreePathLabelProvider labelProvider = this.getLabelProvider(domains[i]);
            if (labelProvider != null) {
                if (isRemove) {
                    labelProvider.removeListener(listener);
                } else {
                    labelProvider.addListener(listener);
                }
            }
            ++i;
        }
        if (isRemove) {
            this.fStdLabelProvider.removeListener(listener);
        } else {
            this.fStdLabelProvider.addListener(listener);
        }
    }

    public void addListener(ILabelProviderListener listener) {
        this.registerListener(listener, false);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.registerListener(listener, true);
    }

    private ITreePathLabelProvider getLabelProvider(Domain domain) {
        try {
            return domain.getLabelProvider();
        }
        catch (Throwable e) {
            this.discardDomain(domain, e);
            return null;
        }
    }

    private void discardDomain(Domain domain, Throwable e) {
        this.fDomainManager.unloadDomain(domain);
        ProcessRCPUIPlugin.getDefault().log(NLS.bind((String)Messages.DelegatingTreePathLabelProvider_0, (Object)domain.getName()), e);
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateLabel(ViewerLabel label, TreePath path) {
        Object element;
        block9: {
            element = path.getLastSegment();
            if (element instanceof DomainSubtreeRoot) {
                Domain domain = ((DomainSubtreeRoot)element).getDomain();
                label.setText(domain.getName());
                label.setImage(domain.getImage());
                return;
            }
            Domain domain = path.getSegmentCount() > 1 && path.getSegment(1) instanceof DomainSubtreeRoot ? ((DomainSubtreeRoot)path.getSegment(1)).getDomain() : this.fDomainManager.getDomain(path.getFirstSegment());
            if (domain != null) {
                try {
                    if (domain.getRoot().equals(element)) {
                        label.setText(domain.getName());
                        label.setImage(domain.getImage());
                        return;
                    }
                    ITreePathLabelProvider labelProvider = domain.getLabelProvider();
                    if (labelProvider != null) {
                        labelProvider.updateLabel(label, path);
                        break block9;
                    } else {
                        Object model = domain.convertToModel(element);
                        if (this.fStdLabelProvider.hasLabelForObject(model)) {
                            this.fStdLabelProvider.updateLabel(label, model);
                            return;
                        }
                    }
                    break block9;
                }
                catch (Throwable e) {
                    this.discardDomain(domain, e);
                    return;
                }
            }
            if (this.fGroupingCategory.isCategoryElement(element)) {
                label.setText(this.fGroupingCategory.getText(element));
                label.setImage(this.fGroupingCategory.getImage(element));
            }
        }
        this.fStdLabelProvider.invokeDecorators(label, element);
    }

    public Color getForeground(Object element) {
        Domain domain = this.fDomainManager.getDomain(element);
        if (domain != null) {
            try {
                ITreePathLabelProvider labelProvider = this.getLabelProvider(domain);
                if (labelProvider instanceof IColorProvider) {
                    return ((IColorProvider)labelProvider).getForeground(element);
                }
            }
            catch (Throwable e) {
                this.discardDomain(domain, e);
            }
        }
        return null;
    }

    public Color getBackground(Object element) {
        Domain domain = this.fDomainManager.getDomain(element);
        if (domain != null) {
            try {
                ITreePathLabelProvider labelProvider = this.getLabelProvider(domain);
                if (labelProvider instanceof IColorProvider) {
                    return ((IColorProvider)labelProvider).getBackground(element);
                }
            }
            catch (Throwable e) {
                this.discardDomain(domain, e);
            }
        }
        return null;
    }

    public Font getFont(Object element) {
        Domain domain = this.fDomainManager.getDomain(element);
        if (domain != null) {
            try {
                ITreePathLabelProvider labelProvider = this.getLabelProvider(domain);
                if (labelProvider instanceof IFontProvider) {
                    return ((IFontProvider)labelProvider).getFont(element);
                }
            }
            catch (Throwable e) {
                this.discardDomain(domain, e);
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element == null) {
            return "";
        }
        ViewerLabel label = new ViewerLabel("", null);
        this.updateLabel(label, new TreePath(new Object[]{element}));
        return label.getText();
    }

    public Image getImage(Object element) {
        if (element == null) {
            return null;
        }
        ViewerLabel label = new ViewerLabel("", null);
        this.updateLabel(label, new TreePath(new Object[]{element}));
        return label.getImage();
    }

    public void dispose() {
        this.fStdLabelProvider.dispose();
    }
}

