/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.jface.labelProviders.IElementRemovedListener;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.process.internal.rcp.ui.AbstractDelegatingTreePathContentProvider;
import com.ibm.team.process.internal.rcp.ui.DomainManager;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.rcp.ui.teamnavigator.Category;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class DelegatingTreePathContentProvider
extends AbstractDelegatingTreePathContentProvider {
    private TreePath fCurrentParentPath;

    public DelegatingTreePathContentProvider(DomainManager domainManager, Category category) {
        super(domainManager, category);
        this.fInputChangedForDomain = new HashMap();
        Domain[] domains = domainManager.getDomains();
        int i = 0;
        while (i < domains.length) {
            ITreePathContentProvider cp = domains[i].getContentProvider();
            if (cp instanceof IElementRemovedNotifier) {
                IElementRemovedNotifier notifier = (IElementRemovedNotifier)cp;
                notifier.addElementRemovedListener((IElementRemovedListener)this);
            }
            ++i;
        }
    }

    public Object[] getChildren(TreePath parentPath) {
        Object parentElement = parentPath.getLastSegment();
        if (this.fCategory.isCategoryElement(parentElement)) {
            if (!this.fCategory.isValid(parentElement)) {
                return EMPTY;
            }
            this.fCurrentParentPath = parentPath;
            return this.getChildren(parentElement);
        }
        Domain domain = null;
        try {
            if (parentPath.getSegmentCount() > 1 && parentPath.getSegment(1) instanceof DomainSubtreeRoot) {
                domain = ((DomainSubtreeRoot)parentPath.getSegment(1)).getDomain();
                this.callInputChanged(domain);
                return domain.getContentProvider().getChildren(parentPath);
            }
            domain = this.fDomainManager.getDomain(parentPath.getFirstSegment());
            if (domain != null) {
                if (parentPath.getSegmentCount() == 1) {
                    return domain.getContentProvider().getElements(domain.getRoot());
                }
                return domain.getContentProvider().getChildren(parentPath);
            }
        }
        catch (Throwable e) {
            this.discardDomain(domain, e, true, true);
        }
        return EMPTY;
    }

    public TreePath[] getParents(Object element) {
        if (this.fCategory.isCategoryElement(element)) {
            return new TreePath[]{new TreePath(EMPTY)};
        }
        if (element instanceof DomainSubtreeRoot) {
            return new TreePath[]{new TreePath(new Object[]{((DomainSubtreeRoot)element).getCategoryElement()})};
        }
        Domain[] domains = this.fDomainManager.getDomains();
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        int i = 0;
        while (i < domains.length) {
            if (domains[i].contains(element)) {
                try {
                    ITreePathContentProvider cp = domains[i].getContentProvider();
                    TreePath[] parents = cp.getParents(element);
                    if (parents != null) {
                        paths.addAll(Arrays.asList(parents));
                    }
                }
                catch (RuntimeException e) {
                    this.discardDomain(domains[i], e, true, true);
                }
            }
            ++i;
        }
        return paths.toArray(new TreePath[paths.size()]);
    }

    public boolean hasChildren(TreePath path) {
        IWorkbenchAdapter adapter;
        Object element = path.getLastSegment();
        if (element instanceof PendingUpdateAdapter) {
            return false;
        }
        if (this.fCategory.isCategoryElement(element)) {
            return true;
        }
        if (element instanceof DomainSubtreeRoot) {
            Domain domain = ((DomainSubtreeRoot)element).getDomain();
            try {
                return domain.getContentProvider().hasChildren(path);
            }
            catch (RuntimeException e) {
                this.discardDomain(domain, e, true, true);
                return false;
            }
        }
        if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
            try {
                return adapter.getChildren(element).length > 0;
            }
            catch (RuntimeException e) {
                ProcessRCPUIPlugin.getDefault().log(Messages.DelegatingTreePathContentProvider_0, e);
                return false;
            }
        }
        Domain domain = path.getSegmentCount() > 1 && path.getSegment(1) instanceof DomainSubtreeRoot ? ((DomainSubtreeRoot)path.getSegment(1)).getDomain() : this.fDomainManager.getDomain(element);
        if (domain != null) {
            try {
                return domain.getContentProvider().hasChildren(path);
            }
            catch (RuntimeException e) {
                this.discardDomain(domain, e, true, true);
                return false;
            }
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        Object[] catElems = this.fCategory.getCategoryElements();
        if (catElems == null) {
            catElems = EMPTY;
        }
        Domain[] nonSupportingDomains = this.fDomainManager.getNonSupportingDomains(this.fCategory);
        ArrayList<Object> children = new ArrayList<Object>(Arrays.asList(catElems));
        int i = 0;
        while (i < nonSupportingDomains.length) {
            try {
                this.callInputChanged(nonSupportingDomains[i]);
                children.add(nonSupportingDomains[i].getRoot());
            }
            catch (Throwable e) {
                this.discardDomain(nonSupportingDomains[i], e, false, true);
            }
            ++i;
        }
        return children.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object[] computeChildren(Object parentElement, IElementCollector collector, IProgressMonitor monitor) {
        DomainManager domainManager;
        Category category;
        DelegatingTreePathContentProvider delegatingTreePathContentProvider = this;
        synchronized (delegatingTreePathContentProvider) {
            category = this.fCategory;
            domainManager = this.fDomainManager;
        }
        if (domainManager == null || !(parentElement instanceof IItem)) {
            return EMPTY;
        }
        IItem parentItem = (IItem)parentElement;
        TreePath treePathPrefix = ((DeferredTreePathContentManager.TreePathElementCollector)collector).getParentPath();
        if (treePathPrefix == null) {
            throw new IllegalStateException(Messages.DelegatingTreePathContentProvider_4);
        }
        Domain[] supportingDomains = domainManager.getSupportingDomains(category);
        ArrayList<DomainSubtreeRoot> roots = new ArrayList<DomainSubtreeRoot>(supportingDomains.length);
        ITeamRepository teamRepository = (ITeamRepository)parentItem.getOrigin();
        String[] domainIds = this.getDomainIds(supportingDomains);
        try {
            String[] licenseAsserts = this.assertLicenses(domainIds, teamRepository, monitor);
            int i = 0;
            while (i < licenseAsserts.length) {
                if (licenseAsserts[i] == null) {
                    Domain domain = supportingDomains[i];
                    DomainSubtreeRoot domainSubtreeRoot = new DomainSubtreeRoot(domain, parentElement);
                    try {
                        domain.addTreePathPrefix(domainSubtreeRoot, treePathPrefix);
                        roots.add(domainSubtreeRoot);
                    }
                    catch (Throwable e) {
                        this.discardDomain(domain, e, false, true);
                    }
                }
                ++i;
            }
        }
        catch (OperationCanceledException e) {
            return EMPTY;
        }
        catch (TeamRepositoryException e) {
            ProcessRCPUIPlugin.getDefault().log(Messages.DelegatingTreePathContentProvider2_1, e);
            return EMPTY;
        }
        return roots.toArray();
    }

    @Override
    protected DeferredTreeContentManager getContentManager() {
        if (this.fContentManager == null && this.fViewer != null) {
            this.fContentManager = new DeferredTreePathContentManager((AbstractTreeViewer)this.fViewer);
        }
        return this.fContentManager;
    }

    protected final class DeferredTreePathContentManager
    extends DeferredTreeContentManager {
        protected DeferredTreePathContentManager(AbstractTreeViewer viewer) {
            super(viewer);
        }

        protected IDeferredWorkbenchAdapter getAdapter(Object element) {
            if (DelegatingTreePathContentProvider.this.hasChildren(element)) {
                return DelegatingTreePathContentProvider.this;
            }
            return super.getAdapter(element);
        }

        protected String getFetchJobName(Object parent, IDeferredWorkbenchAdapter adapter) {
            if (adapter.getLabel(parent) == null) {
                return Messages.DelegatingTreePathContentProvider_3;
            }
            return super.getFetchJobName(parent, adapter);
        }

        protected IElementCollector createElementCollector(Object parent, PendingUpdateAdapter placeholder) {
            TreePathElementCollector elementCollector = new TreePathElementCollector(DelegatingTreePathContentProvider.this.fCurrentParentPath, parent, placeholder);
            return elementCollector;
        }

        final class TreePathElementCollector
        implements IElementCollector {
            private final PendingUpdateAdapter fPlaceholder;
            private final Object fParent;
            private final TreePath fCurrentParentPath;

            public TreePathElementCollector(TreePath currentParentPath, Object parent, PendingUpdateAdapter placeholder) {
                this.fCurrentParentPath = currentParentPath;
                this.fParent = parent;
                this.fPlaceholder = placeholder;
            }

            public void add(Object element, IProgressMonitor monitor) {
                DeferredTreePathContentManager.this.addChildren(this.fParent, new Object[]{element}, monitor);
            }

            public void add(Object[] elements, IProgressMonitor monitor) {
                DeferredTreePathContentManager.this.addChildren(this.fParent, elements, monitor);
            }

            public void done() {
                DeferredTreePathContentManager.this.runClearPlaceholderJob(this.fPlaceholder);
            }

            public TreePath getParentPath() {
                return this.fCurrentParentPath;
            }
        }
    }
}

