/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.foundation.rcp.ui.util.ItemHandleComparer;
import com.ibm.team.process.internal.rcp.ui.DomainManager;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.rcp.ui.teamnavigator.Category;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.common.IItemHandle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.osgi.util.NLS;

public class DelegatingComparer
implements IElementComparer {
    private DomainManager fDomainManager;
    private List fDomainsWithComparers;
    private IElementComparer fItemHandleComparer = new ItemHandleComparer();

    public DelegatingComparer(DomainManager domainManager) {
        this.fDomainManager = domainManager;
        this.fDomainsWithComparers = new ArrayList();
        Domain[] domains = this.fDomainManager.getDomains();
        int i = 0;
        while (i < domains.length) {
            Domain domain = domains[i];
            try {
                if (domain.getComparer() != null) {
                    this.fDomainsWithComparers.add(domain);
                }
            }
            catch (Exception e) {
                ProcessRCPUIPlugin.getDefault().log(NLS.bind((String)Messages.DelegatingComparer_0, (Object)domain.getName()), e);
            }
            ++i;
        }
    }

    public boolean equals(Object e1, Object e2) {
        IElementComparer elementComparer;
        Domain domain1;
        Category category = this.fDomainManager.getCategory();
        if (category.isCategoryElement(e1) && category.isCategoryElement(e2)) {
            return category.equals(e1, e2);
        }
        if (!(e1 instanceof DomainSubtreeRoot) && !(e2 instanceof DomainSubtreeRoot) && (domain1 = this.getDomain(e1)) != null && (elementComparer = domain1.getComparer()) != null && domain1.contains(e2)) {
            return elementComparer.equals(e1, e2);
        }
        if (e1 == null) {
            return false;
        }
        if (e1 instanceof IItemHandle && e2 instanceof IItemHandle) {
            return this.fItemHandleComparer.equals(e1, e2);
        }
        return e1.equals(e2);
    }

    public int hashCode(Object element) {
        IElementComparer elementComparer;
        Domain domain1;
        Category category = this.fDomainManager.getCategory();
        if (category.isCategoryElement(element)) {
            return category.hashCode(element);
        }
        if (!(element instanceof DomainSubtreeRoot) && (domain1 = this.getDomain(element)) != null && (elementComparer = domain1.getComparer()) != null) {
            return elementComparer.hashCode(element);
        }
        if (element == null) {
            return 0;
        }
        if (element instanceof IItemHandle) {
            return this.fItemHandleComparer.hashCode(element);
        }
        return element.hashCode();
    }

    private Domain getDomain(Object element) {
        if (this.fDomainsWithComparers.size() == 0) {
            return null;
        }
        Iterator iterator = this.fDomainsWithComparers.iterator();
        while (iterator.hasNext()) {
            Domain domain = (Domain)iterator.next();
            if (domain.isDisposed()) {
                iterator.remove();
                continue;
            }
            try {
                if (!domain.contains(element)) continue;
                return domain;
            }
            catch (Exception e) {
                ProcessRCPUIPlugin.getDefault().log(NLS.bind((String)Messages.DelegatingComparer_1, (Object)domain.getName()), e);
                iterator.remove();
                this.fDomainManager.unloadDomain(domain);
            }
        }
        return null;
    }

    public void dispose() {
        this.fDomainsWithComparers = null;
        this.fDomainManager = null;
    }
}

