/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IReadAccessListHandle;
import com.ibm.team.process.internal.client.ProcessClientService;
import com.ibm.team.process.internal.common.query.BaseReadAccessListQueryModel;
import com.ibm.team.process.internal.rcp.ui.IElementCollector;
import com.ibm.team.repository.client.IExternalUserRegistryManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IExternalUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.query.BaseContributorQueryModel;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ContributorFetchingUtils {
    private static int fgMaxSize = 2000;

    public static List fetchAllContributors(String pattern, Collection properties, boolean includeArchived, IElementCollector collector, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            Assert.isNotNull((Object)teamRepository);
            BaseContributorQueryModel.ContributorQueryModel model = BaseContributorQueryModel.ContributorQueryModel.ROOT;
            IItemQuery allContributorsQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            allContributorsQuery.orderByAsc((IField)model.name());
            allContributorsQuery.setResultLimit(fgMaxSize + 1);
            IPredicate filter = ContributorFetchingUtils.createPatternAndArchiveFilter((BaseContributorQueryModel)model, pattern, includeArchived);
            if (filter != null) {
                allContributorsQuery.filter(filter);
            }
            monitor = ContributorFetchingUtils.getProgressMonitor(monitor);
            List list = ContributorFetchingUtils.queryItems(allContributorsQuery, properties, collector, teamRepository, monitor);
            return list;
        }
        finally {
            if (collector != null) {
                collector.done();
            }
        }
    }

    public static List fetchExternalUsers(String pattern, IElementCollector collector, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            monitor = ContributorFetchingUtils.getProgressMonitor(monitor);
            monitor.beginTask("", 1000);
            IExternalUserRegistryManager manager = teamRepository.externalUserRegistryManager();
            int queryMax = manager.getMaxLimitForUserSearchQuery((IProgressMonitor)new SubProgressMonitor(monitor, 50));
            IExternalUser[] externalUsers = pattern.startsWith(" ") ? manager.findUsersByAnyName(pattern.substring(1), (IProgressMonitor)new SubProgressMonitor(monitor, 550)) : manager.findUsersByName(pattern, (IProgressMonitor)new SubProgressMonitor(monitor, 550));
            if (collector != null) {
                if (queryMax != -1 && externalUsers.length == queryMax + 1) {
                    collector.setMaximumSearchLimitReached(queryMax);
                } else {
                    collector.setMaximumSearchLimitReached(-1);
                }
            }
            List<String> properties = Arrays.asList(IContributor.USERID_PROPERTY);
            List existing = ContributorFetchingUtils.fetchAllContributors(pattern, properties, true, null, teamRepository, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
            HashMap<String, IContributor> mapOfExisting = new HashMap<String, IContributor>(existing.size());
            for (IContributor existingContributor : existing) {
                mapOfExisting.put(existingContributor.getUserId(), existingContributor);
            }
            int updateSize = 5;
            ArrayList<IExternalUser> potential = new ArrayList<IExternalUser>(externalUsers.length);
            int pointer = 0;
            int i = 0;
            while (i < externalUsers.length) {
                IExternalUser externalUser = externalUsers[i];
                if (mapOfExisting.get(externalUser.getUserId()) == null) {
                    potential.add(externalUser);
                    int size = potential.size();
                    if (size % updateSize == 0) {
                        collector.add(potential.subList(pointer, size).toArray());
                        pointer += updateSize;
                    }
                }
                ++i;
            }
            int size = potential.size();
            if (size % updateSize != 0) {
                if (size > updateSize) {
                    collector.add(potential.subList(pointer, size).toArray());
                } else {
                    collector.add(potential.toArray());
                }
            }
            ArrayList<IExternalUser> arrayList = potential;
            return arrayList;
        }
        finally {
            if (collector != null) {
                collector.done();
            }
        }
    }

    public static List fetchProjectAreaAccessContributors(String pattern, IProjectArea projectArea, Collection properties, boolean includeArchived, IElementCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            if (projectArea == null) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            IReadAccessListHandle accessList = projectArea.getReadAccessList();
            if (accessList == null) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            BaseReadAccessListQueryModel.ReadAccessListQueryModel model = BaseReadAccessListQueryModel.ReadAccessListQueryModel.ROOT;
            IItemQuery accessListQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model.internalContributors());
            accessListQuery.orderByAsc((IField)model.internalContributors().name());
            accessListQuery.setResultLimit(fgMaxSize + 1);
            IPredicate filter = model.itemId()._eq(accessList.getItemId());
            IPredicate patternFilter = ContributorFetchingUtils.createPatternAndArchiveFilter((BaseContributorQueryModel)model.internalContributors(), pattern, includeArchived);
            if (patternFilter != null) {
                filter = filter._and(patternFilter);
            }
            accessListQuery.filter(filter);
            monitor = ContributorFetchingUtils.getProgressMonitor(monitor);
            List list = ContributorFetchingUtils.queryItems(accessListQuery, properties, collector, (ITeamRepository)projectArea.getOrigin(), monitor);
            return list;
        }
        finally {
            if (collector != null) {
                collector.done();
            }
        }
    }

    private static IPredicate createPatternAndArchiveFilter(BaseContributorQueryModel contributorModel, String pattern, boolean includeArchived) {
        if (pattern != null) {
            pattern = pattern.toLowerCase();
        }
        IPredicate archiveFilter = null;
        if (!includeArchived) {
            archiveFilter = contributorModel.archived()._isFalse();
        }
        if (pattern != null) {
            String wildCardPattern = pattern = ContributorFetchingUtils.escape(pattern);
            pattern = pattern.replace("*", "%");
            if ((pattern = pattern.replace("?", "_")).length() > 1 && Character.getType(pattern.charAt(0)) == 12) {
                wildCardPattern = String.valueOf('%') + pattern + '%';
            } else if (pattern.length() > 1 && Character.getType(pattern.charAt(pattern.length() - 1)) == 12) {
                wildCardPattern = pattern.substring(0, pattern.length() - 1);
            } else {
                if (!wildCardPattern.endsWith("%")) {
                    wildCardPattern = String.valueOf(pattern) + '%';
                }
                String[] words = wildCardPattern.split(" ");
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < words.length) {
                    sb.append(words[i]);
                    if (!words[i].endsWith("%")) {
                        sb.append('%');
                    }
                    if (i != words.length - 1) {
                        sb.append(' ');
                    }
                    ++i;
                }
                wildCardPattern = sb.toString();
            }
            IPredicate wildCard = contributorModel.name()._ignoreCaseLike(wildCardPattern, '\\');
            if (archiveFilter != null) {
                return archiveFilter._and(wildCard);
            }
            return wildCard;
        }
        if (archiveFilter != null) {
            return archiveFilter;
        }
        return null;
    }

    private static String escape(String pattern) {
        pattern = pattern.replace("_", "\\_");
        return pattern.replace("%", "\\%");
    }

    private static IProgressMonitor getProgressMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return monitor;
    }

    private static List queryItems(IItemQuery query, Collection properties, IElementCollector collector, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 1000);
        try {
            UUID repoID = teamRepository.getId();
            if (repoID == null || !teamRepository.loggedIn() || teamRepository.getErrorState() != 0) {
                if (collector != null) {
                    collector.done();
                }
                List list = Collections.EMPTY_LIST;
                return list;
            }
            ArrayList allItems = new ArrayList();
            int pageSize = collector == null ? fgMaxSize : 20;
            ProcessClientService processService = (ProcessClientService)teamRepository.getClientLibrary(IProcessItemService.class);
            IItemQueryPage page = processService.queryItems(query, IQueryService.EMPTY_PARAMETERS, pageSize, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            if (page.getResultSize() > 0) {
                int queryPageSize = 100;
                SubProgressMonitor pageMonitor = new SubProgressMonitor(monitor, 950);
                pageMonitor.beginTask("", 1000 * (int)Math.ceil((double)page.getResultSize() / 100.0));
                List items = teamRepository.itemManager().fetchPartialItems(page.getItemHandles(), 0, properties, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pageMonitor, 1000));
                allItems.addAll(items);
                if (collector != null) {
                    collector.add(items.toArray());
                }
                while (page.hasNext()) {
                    UUID token = page.getToken();
                    int nextStartPosition = page.getNextStartPosition();
                    page = (IItemQueryPage)processService.fetchPage(token, nextStartPosition, 100, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pageMonitor, 500));
                    items = teamRepository.itemManager().fetchPartialItems(page.getItemHandles(), 0, properties, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pageMonitor, 500));
                    allItems.addAll(items);
                    if (allItems.size() > fgMaxSize) {
                        allItems.remove(allItems.size() - 1);
                        if (collector == null) continue;
                        collector.add(items.subList(0, items.size() - 1).toArray());
                        continue;
                    }
                    if (collector == null) continue;
                    collector.add(items.toArray());
                }
                if (collector != null) {
                    if (page.getResultSize() > fgMaxSize) {
                        collector.setMaximumSearchLimitReached(fgMaxSize);
                    } else {
                        collector.setMaximumSearchLimitReached(-1);
                    }
                }
            } else if (collector != null) {
                collector.setMaximumSearchLimitReached(-1);
            }
            ArrayList arrayList = allItems;
            return arrayList;
        }
        finally {
            if (collector != null) {
                collector.done();
            }
            monitor.done();
        }
    }

    public static void setMaximumFetchSize(int maxSize) {
        fgMaxSize = maxSize;
    }
}

