/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.AbstractLicensePropertyPage;
import com.ibm.team.process.internal.rcp.ui.DisplayHelper;
import com.ibm.team.process.internal.rcp.ui.LicenseAdminLibrary;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IContributorLicenseType;
import com.ibm.team.repository.common.ILicenseType;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class AccessLicensesPropertyPage
extends AbstractLicensePropertyPage {
    private ITeamRepository fTeamRepository;
    private Composite fComposite;
    private TableViewer fGroupViewer;
    private Job fJob;
    private IContributorLicenseType[] fContributorCALs;
    private Label fProductName;
    private Label fEditionName;
    private Text fDescription;
    private Link fPurchaseURLLink;
    private Link fInfoURLLink;
    private Label fStatus;
    private IContributorLicenseType fContributorLicenseType;
    private Group fGroup;

    protected Control createContents(Composite parent) {
        IAdaptable element = this.getElement();
        this.fTeamRepository = (ITeamRepository)element.getAdapter(ITeamRepository.class);
        this.fComposite = new Composite(parent, 0);
        this.fComposite.setLayout((Layout)new GridLayout(1, false));
        this.fComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 0;
        layout.verticalSpacing = 5;
        this.fComposite.setLayout((Layout)layout);
        Label label = new Label(this.fComposite, 64);
        label.setText(Messages.AccessLicensesPropertyPage_10);
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        label.setLayoutData((Object)gridData);
        label = new Label(this.fComposite, 64);
        label.setText(Messages.AccessLicensesPropertyPage_18);
        Table table = new Table(this.fComposite, 2048);
        gridData = new GridData(4, 128, true, false, 1, 1);
        gridData.heightHint = table.getItemHeight() * 4;
        table.setLayoutData((Object)gridData);
        this.fGroupViewer = new TableViewer(table);
        this.fGroupViewer.setSorter(new ViewerSorter());
        this.fGroupViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IContributorLicenseType) {
                    IContributorLicenseType license = (IContributorLicenseType)element;
                    return NLS.bind((String)Messages.AccessLicensesPropertyPage_19, (Object)license.getProductName(), (Object)license.getName());
                }
                return super.getText(element);
            }
        });
        this.fGroupViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }
        });
        this.fGroupViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AccessLicensesPropertyPage.this.handleLicenseSelectionChanged(event.getSelection());
            }
        });
        this.fGroupViewer.setInput((Object)new String[]{Messages.AccessLicensesPropertyPage_0});
        this.createDetailsGroup(this.fComposite);
        this.intialize();
        this.applyDialogFont(this.fComposite);
        return this.fComposite;
    }

    private void createDetailsGroup(Composite parent) {
        this.fGroup = new Group(parent, 0);
        this.fGroup.setText(Messages.AccessLicensesPropertyPage_1);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.fGroup.setLayout((Layout)layout);
        this.fGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label((Composite)this.fGroup, 0);
        label.setText(Messages.AccessLicensesPropertyPage_16);
        label.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fProductName = new Label((Composite)this.fGroup, 64);
        this.fProductName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label((Composite)this.fGroup, 0);
        label.setText(Messages.AccessLicensesPropertyPage_17);
        label.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fEditionName = new Label((Composite)this.fGroup, 64);
        this.fEditionName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label((Composite)this.fGroup, 0);
        label.setText(Messages.AccessLicensesPropertyPage_2);
        label.setLayoutData((Object)new GridData(4, 128, false, true));
        this.fDescription = new Text((Composite)this.fGroup, 2634);
        GridData data = new GridData(4, 4, true, true);
        int availableRows = this.getAvailableRows((Composite)this.fGroup);
        data.heightHint = this.fDescription.getLineHeight() * (availableRows / 15);
        this.fDescription.setLayoutData((Object)data);
        label = new Label((Composite)this.fGroup, 0);
        label.setText(Messages.AccessLicensesPropertyPage_4);
        label.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fStatus = new Label((Composite)this.fGroup, 64);
        this.fStatus.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fInfoURLLink = this.createInfoURL((Composite)this.fGroup);
        this.fPurchaseURLLink = this.createPurchaseURL((Composite)this.fGroup);
    }

    private int getAvailableRows(Composite group) {
        int fontHeight = group.getFont().getFontData()[0].getHeight();
        int displayHeight = group.getDisplay().getClientArea().height;
        return displayHeight / fontHeight;
    }

    private void intialize() {
        if (!this.fTeamRepository.loggedIn() || this.fTeamRepository.getErrorState() != 0) {
            this.setStatus((IStatus)new Status(2, "com.ibm.team.process.rcp.ui", Messages.ServerLicensePropertyPage_14));
            this.fGroupViewer.setInput((Object)new Object[0]);
            return;
        }
        this.fJob = new Job(Messages.AccessLicensesPropertyPage_5){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    AccessLicensesPropertyPage.this.fetchAvailableLicenses(AccessLicensesPropertyPage.this.fTeamRepository, monitor);
                    DisplayHelper.asyncExec(AccessLicensesPropertyPage.this.fGroupViewer.getControl(), new Runnable(){

                        @Override
                        public void run() {
                            AccessLicensesPropertyPage.this.fGroupViewer.setInput((Object)AccessLicensesPropertyPage.this.fContributorCALs);
                            if (AccessLicensesPropertyPage.this.fContributorCALs.length > 0) {
                                AccessLicensesPropertyPage.this.fGroupViewer.setSelection((ISelection)new StructuredSelection((Object)AccessLicensesPropertyPage.this.fContributorCALs[0]));
                            }
                        }
                    });
                }
                catch (TeamRepositoryException e) {
                    DisplayHelper.asyncExec(AccessLicensesPropertyPage.this.fGroupViewer.getControl(), new Runnable(){

                        @Override
                        public void run() {
                            AccessLicensesPropertyPage.this.fGroupViewer.setInput((Object)new Object[0]);
                            AccessLicensesPropertyPage.this.setStatus((IStatus)new Status(4, "com.ibm.team.process.rcp.ui", Messages.AccessLicensesPropertyPage_6, (Throwable)e));
                        }
                    });
                }
                AccessLicensesPropertyPage.this.fJob = null;
                return Status.OK_STATUS;
            }
        };
        this.fJob.schedule();
    }

    private void fetchAvailableLicenses(ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        LicenseAdminLibrary adminLibrary = new LicenseAdminLibrary(teamRepository);
        IContributor contributor = teamRepository.loggedInContributor();
        if (contributor != null) {
            String[] assignedLicenseIDs = adminLibrary.getAssignedLicenses((IContributorHandle)contributor, monitor);
            ArrayList<IContributorLicenseType> cals = new ArrayList<IContributorLicenseType>(assignedLicenseIDs.length);
            IContributorLicenseType[] licenseTypes = adminLibrary.getLicenseTypes(monitor);
            int i = 0;
            while (i < assignedLicenseIDs.length) {
                String licenseId = assignedLicenseIDs[i];
                IContributorLicenseType contributorCAL = this.findMatch(licenseTypes, licenseId);
                if (contributorCAL != null) {
                    cals.add(contributorCAL);
                }
                ++i;
            }
            this.fContributorCALs = cals.toArray(new IContributorLicenseType[cals.size()]);
        }
    }

    private IContributorLicenseType findMatch(IContributorLicenseType[] licenses, String licenseId) {
        int j = 0;
        while (j < licenses.length) {
            if (licenseId.equals(licenses[j].getId())) {
                return licenses[j];
            }
            ++j;
        }
        return null;
    }

    protected void handleLicenseSelectionChanged(ISelection selection) {
        String linkText;
        IContributorLicenseType contributorLicenseType = (IContributorLicenseType)((IStructuredSelection)selection).getFirstElement();
        if (this.fContributorLicenseType != null && this.fContributorLicenseType.getId().equals(contributorLicenseType.getId())) {
            return;
        }
        this.fContributorLicenseType = contributorLicenseType;
        this.fProductName.setText(this.fContributorLicenseType.getProductName());
        String variantName = this.fContributorLicenseType.getVariantName();
        if (variantName == null) {
            this.fEditionName.setText(this.fContributorLicenseType.getEditionName());
        } else {
            this.fEditionName.setText(NLS.bind((String)Messages.AccessLicensesPropertyPage_20, (Object)this.fContributorLicenseType.getEditionName(), (Object)variantName));
        }
        this.fDescription.setText(this.fContributorLicenseType.getDescription());
        String infoURL = this.fContributorLicenseType.getInfoURL();
        String buyURL = this.fContributorLicenseType.getBuyURL();
        if (infoURL == null) {
            if (this.fInfoURLLink != null) {
                this.fInfoURLLink.dispose();
                this.fInfoURLLink = null;
                this.fInfoURL = null;
            }
        } else {
            if (this.fInfoURLLink == null) {
                this.fInfoURLLink = this.createInfoURL((Composite)this.fGroup);
            }
            linkText = NLS.bind((String)Messages.AccessLicensesPropertyPage_21, (Object)this.fContributorLicenseType.getProductName());
            this.fInfoURLLink.setText("<a>" + linkText + "</a>");
            this.fInfoURL = infoURL;
        }
        if (buyURL == null) {
            if (this.fPurchaseURLLink != null) {
                this.fPurchaseURLLink.dispose();
                this.fPurchaseURLLink = null;
                this.fPurchaseURL = null;
            }
        } else {
            if (this.fPurchaseURLLink == null) {
                this.fPurchaseURLLink = this.createInfoURL((Composite)this.fGroup);
            }
            linkText = NLS.bind((String)Messages.AccessLicensesPropertyPage_22, (Object)this.fContributorLicenseType.getProductName(), (Object)this.fContributorLicenseType.getName());
            this.fPurchaseURLLink.setText(NLS.bind((String)"<a>{0}</a>", (Object)linkText));
            this.fPurchaseURL = buyURL;
        }
        if (this.fContributorLicenseType.getDisabledReason() != null) {
            this.fStatus.setText(NLS.bind((String)Messages.AccessLicensesPropertyPage_9, (Object)this.fContributorLicenseType.getDisabledReason()));
        } else {
            this.fStatus.setText(Messages.AccessLicensesPropertyPage_8);
        }
        this.fComposite.pack(true);
        this.fComposite.getParent().layout(true);
    }

    @Override
    protected ILicenseType getLicense() {
        return this.fContributorLicenseType;
    }
}

