/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.ide.help.server.prefs;

import com.ibm.team.process.ide.help.server.Activator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class Preferences {
    private IEclipsePreferences prefs;
    private IEclipsePreferences defPrefs;
    private IEclipsePreferences configPrefs;

    public Preferences(String plugin) {
        this.prefs = Preferences.getNode(plugin);
        this.defPrefs = Preferences.getDefaultNode(plugin);
        this.configPrefs = Preferences.getConfigNode(plugin);
    }

    public void addListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        this.prefs.addPreferenceChangeListener(listener);
    }

    public String get(String name) {
        return this.prefs.get(name, "");
    }

    public static String get(String plugin, String name) {
        return Preferences.getNode(plugin).get(name, "");
    }

    public String getDefault(String name) {
        return this.defPrefs.get(name, "");
    }

    public static String getDefault(String plugin, String name) {
        return Preferences.getDefaultNode(plugin).get(name, "");
    }

    public static String getConfig(String plugin, String name) {
        return Preferences.getConfigNode(plugin).get(name, "");
    }

    public static String getProperty(String name) {
        return Activator.getDefault().getBundle().getBundleContext().getProperty(name);
    }

    public void set(String name, String value) {
        Preferences.set(this.prefs, name, value);
    }

    public static void set(String plugin, String name, String value) {
        Preferences.set(Preferences.getNode(plugin), name, value);
    }

    public void setDefault(String name, String value) {
        Preferences.set(this.defPrefs, name, value);
    }

    public static void setDefault(String plugin, String name, String value) {
        Preferences.set(Preferences.getDefaultNode(plugin), name, value);
    }

    public static void setConfig(String plugin, String name, String value) {
        Preferences.set(Preferences.getConfigNode(plugin), name, value);
    }

    public static void set(IEclipsePreferences node, String name, String value) {
        node.put(name, value);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public static IEclipsePreferences getNode(String plugin) {
        IEclipsePreferences p = new InstanceScope().getNode(plugin);
        return p;
    }

    public static IEclipsePreferences getDefaultNode(String plugin) {
        IEclipsePreferences p = new DefaultScope().getNode(plugin);
        return p;
    }

    public static IEclipsePreferences getConfigNode(String plugin) {
        IEclipsePreferences p = new ConfigurationScope().getNode(plugin);
        return p;
    }

    public static void remove(String plugin, String name) {
        Preferences.getNode(plugin).remove(name);
        try {
            Preferences.getNode(plugin).flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public static Properties loadPropertyFile(File file) {
        Properties props = new Properties();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.indexOf("=") <= -1) continue;
                String key = line.substring(0, line.indexOf("="));
                String val = line.substring(line.indexOf("=") + 1);
                props.setProperty(key, val);
            }
            br.close();
        }
        catch (IOException iOException) {}
        return props;
    }

    public static void savePropertyFile(File file, Properties props) {
        try {
            if (file.exists()) {
                file.delete();
            }
            file.getParentFile().mkdirs();
            file.createNewFile();
            PrintWriter pw = new PrintWriter(new FileWriter(file));
            Enumeration<Object> keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String val = props.getProperty(key);
                pw.println(String.valueOf(key) + '=' + val);
            }
            pw.close();
        }
        catch (IOException iOException) {}
    }

    public static boolean isDebug() {
        return Preferences.get("com.ibm.team.process.ide.help", "DEBUG").equals("true");
    }

    public static void setPreference(String id, String value) {
        if (!id.contains(".")) {
            return;
        }
        String plugin = id.substring(0, id.lastIndexOf("."));
        String name = id.substring(id.lastIndexOf(".") + 1);
        Preferences.set(plugin, name, value);
    }
}

