/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.ide.help.server;

import com.ibm.team.process.ide.help.server.dialogs.AbstractMessageDialog;
import java.lang.reflect.Constructor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = "com.ibm.team.process.ide.help";
    public static boolean LOG_WARN = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.team.process.ide.help/debug/warn"));
    public static boolean LOG_INFO = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.team.process.ide.help/debug/info"));
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Thread initThread = new Thread(){

            @Override
            public void run() {
            }
        };
        initThread.start();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void earlyStartup() {
    }

    public static synchronized void logError(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, PLUGIN_ID, message, ex);
        Activator.getDefault().getLog().log((IStatus)errorStatus);
    }

    public static synchronized void logWarning(String message) {
        Activator.logWarning(message, null);
    }

    public static synchronized void logWarning(String message, Throwable ex) {
        if (Activator.getDefault() != null && Activator.getDefault().isDebugging() && LOG_WARN) {
            if (message == null) {
                message = "";
            }
            Status warningStatus = new Status(2, PLUGIN_ID, 0, message, ex);
            Activator.getDefault().getLog().log((IStatus)warningStatus);
        }
    }

    public static synchronized void logDebug(String message) {
        if (Activator.getDefault().isDebugging() && LOG_INFO) {
            if (message == null) {
                message = "";
            }
            Status status = new Status(1, PLUGIN_ID, message);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    public static synchronized void logStatus(IStatus status) {
        if (status.getSeverity() == 4) {
            Activator.getDefault().getLog().log(status);
        } else if (status.getSeverity() == 2 && Activator.getDefault().isDebugging() && LOG_WARN) {
            Activator.getDefault().getLog().log(status);
        }
    }

    public static void setTask(IProgressMonitor monitor, String task) {
        if (monitor instanceof SubProgressMonitor) {
            Activator.setTask(((SubProgressMonitor)monitor).getWrappedProgressMonitor(), task);
        } else {
            monitor.subTask(task);
        }
    }

    public static int displayDialog(String cls) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return -1;
        }
        IWorkbench wb = PlatformUI.getWorkbench();
        DialogRunnable runnable = new DialogRunnable(cls);
        wb.getDisplay().asyncExec((Runnable)runnable);
        return runnable.getReturnCode();
    }

    static class DialogRunnable
    implements Runnable {
        private String clsName;
        private int code = -1;

        public DialogRunnable(String clsName) {
            this.clsName = clsName;
        }

        @Override
        public void run() {
            try {
                IWorkbench wb = PlatformUI.getWorkbench();
                Class<?> cls = Class.forName(this.clsName);
                Constructor<?> constructor = cls.getConstructor(Shell.class);
                AbstractMessageDialog dialog = (AbstractMessageDialog)((Object)constructor.newInstance(wb.getActiveWorkbenchWindow().getShell()));
                if (dialog != null) {
                    dialog.setBlockOnOpen(true);
                    this.code = dialog.open();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public int getReturnCode() {
            return this.code;
        }
    }
}

