/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.ide.help.common;

import com.ibm.team.process.ide.help.common.HTTPSUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;

public class ProxyUtil {
    private static IProxyService manager = ProxyManager.getProxyManager();

    public static void addProxyChangeListener(IProxyChangeListener listener) {
        manager.addProxyChangeListener(listener);
    }

    public static void removeProxyChangeListener(IProxyChangeListener listener) {
        if (listener != null) {
            try {
                manager.removeProxyChangeListener(listener);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public static boolean isAuthConnSupported() {
        try {
            Class.forName("org.eclipse.core.net.proxy.IProxyService");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static IProxyData getProxy(URL url) {
        URI uri;
        IProxyService service;
        block6: {
            if (!ProxyUtil.isAuthConnSupported()) {
                return null;
            }
            service = manager;
            if (!service.isProxiesEnabled()) {
                return null;
            }
            try {
                uri = url.toURI();
                if (!ProxyUtil.shouldBypass(uri)) break block6;
                return null;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return null;
            }
        }
        IProxyData[] data = service.select(uri);
        if (data.length == 0) {
            return null;
        }
        return data[0];
    }

    public static boolean shouldBypass(URI uri) {
        String host = uri.getHost();
        if (host == null) {
            return true;
        }
        List<String> hosts = ProxyUtil.getProxyBypassHosts();
        if (hosts.contains(host)) {
            return true;
        }
        return (host.equals("localhost") || host.equals("127.0.0.1")) && hosts.contains("<local>");
    }

    public static void setProxy(IProxyData proxy) {
        if (!ProxyUtil.isAuthConnSupported()) {
            return;
        }
        IProxyService service = manager;
        IProxyData[] data = service.getProxyData();
        int d = 0;
        while (d < data.length) {
            if (data[d].getType().equalsIgnoreCase(proxy.getType())) {
                data[d] = proxy;
            }
            ++d;
        }
        try {
            service.setProxyData(data);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void setProxy(String type, String host, int port, String source) {
        ProxyUtil.setProxy((IProxyData)new ProxyData(type, host, port, false, source));
    }

    public static void setProxy(String type, String host, int port, String user, String password, String source) {
        ProxyData proxy = new ProxyData(type, host, port, true, source);
        proxy.setUserid(user);
        proxy.setPassword(password);
        ProxyUtil.setProxy((IProxyData)proxy);
    }

    public static List<String> getProxyBypassHosts() {
        ArrayList<String> hosts = new ArrayList<String>();
        if (!ProxyUtil.isAuthConnSupported()) {
            return hosts;
        }
        IProxyService service = manager;
        String[] manuals = service.getNonProxiedHosts();
        String[] natives = null;
        if (service instanceof ProxyManager) {
            natives = ((ProxyManager)service).getNativeNonProxiedHosts();
        }
        int m = 0;
        while (m < manuals.length) {
            hosts.add(manuals[m]);
            ++m;
        }
        if (natives != null) {
            int n = 0;
            while (n < natives.length) {
                hosts.add(natives[n]);
                ++n;
            }
        }
        return hosts;
    }

    private static URLConnection followRedirects(URL url, Proxy proxy) throws IOException {
        URLConnection c = url.openConnection(proxy);
        while (c instanceof HttpURLConnection && (((HttpURLConnection)c).getResponseCode() == 301 || ((HttpURLConnection)c).getResponseCode() == 302)) {
            url = new URL(c.getHeaderField("Location"));
            c = url.openConnection(proxy);
        }
        return url.openConnection(proxy);
    }

    public static URLConnection getConnection(URL url) throws IOException {
        Proxy proxy = Proxy.NO_PROXY;
        IProxyData data = ProxyUtil.getProxy(url);
        if (data != null) {
            if (data.isRequiresAuthentication()) {
                Authenticator.setDefault(new ProxyAuthenticator(data.getUserId(), data.getPassword()));
            } else {
                Authenticator.setDefault(null);
            }
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(data.getHost(), data.getPort()));
        }
        if (url.toString().startsWith("https")) {
            return HTTPSUtil.getConnection(url, proxy);
        }
        return ProxyUtil.followRedirects(url, proxy);
    }

    public static InputStream getStream(URL url) throws IOException {
        return ProxyUtil.getConnection(url).getInputStream();
    }

    public static boolean isProxiesEnabled() {
        return manager.isProxiesEnabled();
    }

    public static boolean isSystemProxiesEnabled() {
        return manager.isSystemProxiesEnabled();
    }

    public static void addProxyBypassHost(String host) {
        if (!ProxyUtil.isAuthConnSupported()) {
            return;
        }
        IProxyService service = manager;
        String[] hosts = service.getNonProxiedHosts();
        String[] newHosts = new String[hosts.length + 1];
        int h = 0;
        while (h < hosts.length) {
            if (hosts[h].equals(host)) {
                return;
            }
            newHosts[h] = hosts[h];
            ++h;
        }
        newHosts[hosts.length] = host;
        try {
            service.setNonProxiedHosts(newHosts);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void removeProxyBypassHost(int index) {
        if (!ProxyUtil.isAuthConnSupported()) {
            return;
        }
        IProxyService service = manager;
        String[] hosts = service.getNonProxiedHosts();
        if (hosts.length <= index) {
            return;
        }
        ArrayList<String> newHosts = new ArrayList<String>();
        int h = 0;
        while (h < hosts.length) {
            if (h != index) {
                newHosts.add(hosts[h]);
            }
            ++h;
        }
        try {
            service.setNonProxiedHosts(newHosts.toArray(new String[newHosts.size()]));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void removeProxyBypassHost(String host) {
        if (!ProxyUtil.isAuthConnSupported()) {
            return;
        }
        IProxyService service = manager;
        String[] hosts = service.getNonProxiedHosts();
        if (hosts.length == 0) {
            return;
        }
        ArrayList<String> newHosts = new ArrayList<String>();
        int h = 0;
        while (h < hosts.length) {
            if (!hosts[h].equals(host)) {
                newHosts.add(hosts[h]);
            }
            ++h;
        }
        try {
            service.setNonProxiedHosts(newHosts.toArray(new String[newHosts.size()]));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void fixNativeLocal() {
        if (!ProxyUtil.isAuthConnSupported()) {
            return;
        }
        IProxyService service = manager;
        if (service instanceof ProxyManager) {
            ProxyManager cfr_ignored_0 = (ProxyManager)service;
        }
    }

    private static class ProxyAuthenticator
    extends Authenticator {
        private String user;
        private String password;

        public ProxyAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password.toCharArray());
        }
    }
}

