/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.ide.help.common;

import com.ibm.team.process.ide.help.common.IC;
import com.ibm.team.process.ide.help.common.ICDialog;
import com.ibm.team.process.ide.help.server.prefs.EWMPreferencePage;
import java.util.List;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class ICButtons
implements SelectionListener {
    private EWMPreferencePage page;
    private Button addIC;
    private Button editIC;
    private Button removeIC;
    private Button moveUp;
    private Button moveDown;
    private Button testIC;
    private Button enableIC;

    public ICButtons(Composite parent, EWMPreferencePage page) {
        this.page = page;
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1040));
        container.setFont(parent.getFont());
        this.editIC = this.createPushButton(container, Messages.HelpContentBlock_editICTitle);
        this.testIC = this.createPushButton(container, Messages.HelpContentBlock_testConnectionTitle);
        if (Messages.HelpContentBlock_3.length() > Messages.HelpContentBlock_4.length()) {
        }
        page.getTable().getTable().addSelectionListener((SelectionListener)this);
        this.updateButtonStates();
    }

    public Button createPushButton(Composite parent, String buttonText) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(buttonText);
        button.addSelectionListener((SelectionListener)this);
        this.page.setButtonLayoutData(button);
        return button;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            if (e.getSource() == this.addIC) {
                this.addIC();
            } else if (e.getSource() == this.editIC) {
                this.editIC();
            } else if (e.getSource() == this.removeIC) {
                this.removeIC();
            } else if (e.getSource() == this.testIC) {
                this.testIC();
            } else if (e.getSource() == this.enableIC) {
                this.enableIC();
            } else if (e.getSource() == this.moveUp) {
                this.move(-1);
            } else if (e.getSource() == this.moveDown) {
                this.move(1);
            }
        } else if (e.getSource() instanceof Table) {
            this.updateButtonStates();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.getSource() instanceof Table) {
            this.editIC();
        }
    }

    public void addIC() {
        ICDialog dialog = new ICDialog(this.page.getShell());
        if (dialog.open() == 0) {
            this.page.getTable().addIC(dialog.getIC());
            this.updateButtonStates();
        }
    }

    public void editIC() {
        IStructuredSelection selection = (IStructuredSelection)this.page.getTable().getSelection();
        IC ic = (IC)selection.getFirstElement();
        if (ic == null) {
            return;
        }
        ICDialog dialog = new ICDialog(this.page.getShell(), ic);
        if (dialog.open() == 0) {
            this.page.getTable().editIC(dialog.getIC());
            this.updateButtonStates();
        }
    }

    public void removeIC() {
        IStructuredSelection selection = (IStructuredSelection)this.page.getTable().getSelection();
        List ics = selection.toList();
        String remove = "";
        int i = 0;
        while (i < ics.size()) {
            remove = String.valueOf(remove) + "\n" + ics.get(i);
            ++i;
        }
        boolean shouldRemove = MessageDialog.openQuestion((Shell)this.page.getShell(), (String)NLS.bind((String)Messages.HelpContentBlock_rmvTitle, (Object)""), (String)NLS.bind((String)Messages.HelpContentBlock_rmvLabel, (Object)remove));
        if (shouldRemove) {
            int i2 = 0;
            while (i2 < ics.size()) {
                this.page.getTable().removeIC((IC)ics.get(i2));
                ++i2;
            }
            this.updateButtonStates();
        }
    }

    public void testIC() {
        IStructuredSelection selection = (IStructuredSelection)this.page.getTable().getSelection();
        IC ic = (IC)selection.getFirstElement();
        if (ic == null) {
            return;
        }
        ICDialog dialog = new ICDialog(this.page.getShell(), ic, true);
        if (dialog.open() == 0) {
            this.page.getTable().editIC(dialog.getIC());
            this.updateButtonStates();
        }
    }

    public void enableIC() {
        int[] indexes = this.page.getTable().getTable().getSelectionIndices();
        IStructuredSelection selection = (IStructuredSelection)this.page.getTable().getSelection();
        List ics = selection.toList();
        boolean enable = this.enableIC.getText().equals(Messages.HelpContentBlock_4);
        int i = 0;
        while (i < ics.size()) {
            ((IC)ics.get(i)).setEnabled(enable);
            this.page.getTable().getTableViewer().replace((Object)((IC)ics.get(i)), indexes[i]);
            ++i;
        }
        this.page.getTable().refresh();
        this.updateButtonStates();
    }

    public void move(int offset) {
        int index = this.page.getTable().getTable().getSelectionIndices()[0];
        List ics = this.page.getTable().getICs();
        IC x = (IC)ics.get(index);
        IC y = (IC)ics.get(index + offset);
        ics.set(index + offset, x);
        ics.set(index, y);
        this.page.getTable().getTableViewer().getContentProvider().inputChanged((Viewer)this.page.getTable().getTableViewer(), null, (Object)ics);
        this.page.getTable().getTableViewer().replace((Object)x, index + offset);
        this.page.getTable().getTableViewer().replace((Object)y, index);
        this.page.getTable().refresh();
        this.page.getTable().getTable().deselectAll();
        this.page.getTable().getTable().select(index + offset);
        this.updateButtonStates();
    }

    public void updateButtonStates() {
        IC firstIC = (IC)((IStructuredSelection)this.page.getTable().getSelection()).getFirstElement();
        if (firstIC != null) {
            int cfr_ignored_0 = this.page.getTable().getTable().getSelectionIndices()[0];
            if (this.page.getTable().getTable().getSelectionIndices().length == 1) {
                this.editIC.setEnabled(true);
                this.testIC.setEnabled(true);
            }
        }
    }
}

