/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.ide.help.common;

import com.ibm.team.process.ide.help.common.URLUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class IC {
    private String name;
    private boolean enabled;
    private String protocol;
    private String host;
    private String path;
    private int port = -1;
    private File sitexml = null;

    public IC(String name, String href, boolean enabled) throws MalformedURLException {
        this.name = name;
        this.enabled = enabled;
        this.setHref(href);
    }

    public void setHref(String href) {
        if (href.startsWith(":")) {
            href = "http" + href;
        }
        try {
            this.setHref(new URL(href));
        }
        catch (MalformedURLException malformedURLException) {
            this.sitexml = new File(href);
        }
    }

    public void setHref(URL url) {
        this.protocol = url.getProtocol();
        this.host = url.getHost();
        this.path = url.getPath();
        this.port = url.getPort();
        if (this.port == -1) {
            if (this.protocol.equals("http")) {
                this.port = 80;
            } else if (this.protocol.equals("https")) {
                this.port = 443;
            }
        }
    }

    public String getHref() {
        if (this.sitexml != null) {
            return this.sitexml.getAbsolutePath();
        }
        String portString = ":" + this.port;
        if (this.port == 80 && this.protocol.equals("http")) {
            portString = "";
        } else if (this.port == 443 && this.protocol.equals("https")) {
            portString = "";
        }
        return String.valueOf(this.protocol) + "://" + this.host + portString + this.path;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        return String.valueOf(this.name) + " (" + this.getHref() + ")";
    }

    public boolean canConnect() {
        try {
            URLUtil.getStream(new URL(String.valueOf(this.getHref()) + "/toc")).close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

