/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver.editors;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.editors.CreateWorkItemsAspectEditor;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.editors.InputDialogWithVars;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.editors.Messages;
import com.ibm.team.process.internal.ide.ui.editors.form.AbstractProcessAspect;
import com.ibm.team.process.internal.ide.ui.editors.form.IDevelopmentLineProxy;
import com.ibm.team.process.internal.ide.ui.editors.form.IIterationStructureProxy;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SetupProjectAspectEditor
extends CreateWorkItemsAspectEditor {
    private static final String TAG_TEAM_AREA = "team-area";
    private static final String TAG_STREAM = "stream";
    private static final String TAG_COMPONENT = "component";
    private static final String TAG_WORKSPACE = "workspace";
    private static final String TAG_CATEGORY = "category";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_DEVELOPMENT_LINE = "timeline";
    private static final String ATTR_PATH = "path";
    private static final String[] VAR_STREAM_NAME = new String[]{Messages.SetupProjectAspectEditor_streamName, "${stream-name}"};
    private static final String[][] TEAM_AREA_NAME_VARS = new String[][]{VAR_PROJECT_AREA_NAME};
    private static final String[][] STREAM_NAME_VARS = new String[][]{VAR_PROJECT_AREA_NAME, VAR_TEAM_AREA_NAME};
    private static final String[][] WORKSPACE_NAME_VARS = new String[][]{VAR_PROJECT_AREA_NAME, VAR_TEAM_AREA_NAME, VAR_STREAM_NAME};
    private Model fModel;
    private SectionCheckbox fCreateStreamButton;
    private Text fStreamNameText;
    private Text fStreamDescText;
    private ListViewer fComponentsViewer;
    private Button fAddComponentButton;
    private Button fRemoveComponentButton;
    private SectionCheckbox fCreateWorkspaceButton;
    private Text fWorkspaceNameText;
    private Text fWorkspaceDescText;
    private Composite fStreamDetailsComposite;
    private ModifyListener fModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (e.widget == SetupProjectAspectEditor.this.fTeamAreaNameText) {
                ((SetupProjectAspectEditor)SetupProjectAspectEditor.this).fModel.teamAreaName = SetupProjectAspectEditor.this.fTeamAreaNameText.getText();
            } else if (e.widget == SetupProjectAspectEditor.this.fStreamNameText) {
                ((SetupProjectAspectEditor)SetupProjectAspectEditor.this).fModel.streamName = SetupProjectAspectEditor.this.fStreamNameText.getText();
            } else if (e.widget == SetupProjectAspectEditor.this.fStreamDescText) {
                ((SetupProjectAspectEditor)SetupProjectAspectEditor.this).fModel.streamDescription = SetupProjectAspectEditor.this.fStreamDescText.getText();
            } else if (e.widget == SetupProjectAspectEditor.this.fWorkspaceNameText) {
                ((SetupProjectAspectEditor)SetupProjectAspectEditor.this).fModel.workspaceName = SetupProjectAspectEditor.this.fWorkspaceNameText.getText();
            } else if (e.widget == SetupProjectAspectEditor.this.fWorkspaceDescText) {
                ((SetupProjectAspectEditor)SetupProjectAspectEditor.this).fModel.workspaceDescription = SetupProjectAspectEditor.this.fWorkspaceDescText.getText();
            }
            SetupProjectAspectEditor.this.setDirty();
        }
    };
    private Composite fTeamAreaDetailsComposite;
    private Text fTeamAreaNameText;
    private Composite fWorkspaceDetailsComposite;
    private IIterationStructureProxy fIterationStructure;
    private ComboViewer fDevelopmentLineComboViewer;
    private IPropertyChangeListener fIterationStructureChangeListener;
    private List fCategoryForms = new ArrayList();
    private Label fCategoryCountLabel;
    private Composite fCategoriesComposite;

    @Override
    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.fModel = new Model();
        this.fIterationStructure = ((AbstractProcessAspect)this.getAspect()).getIterationStructure();
    }

    @Override
    public void restoreState(IMemento memento) {
        IMemento workspaceMemento;
        IMemento teamAreaMemento = memento.getChild(TAG_TEAM_AREA);
        this.fModel.createTeamArea = true;
        this.fModel.teamAreaName = SetupProjectAspectEditor.getAttrib(teamAreaMemento, ATTR_NAME, "");
        this.fModel.developmentLineId = SetupProjectAspectEditor.getAttrib(teamAreaMemento, ATTR_DEVELOPMENT_LINE, "");
        IMemento streamMemento = memento.getChild(TAG_STREAM);
        this.fModel.createStream = streamMemento != null;
        this.fModel.streamName = SetupProjectAspectEditor.getAttrib(streamMemento, ATTR_NAME, "");
        this.fModel.streamDescription = SetupProjectAspectEditor.getAttrib(streamMemento, ATTR_DESCRIPTION, "");
        this.fModel.componentNames.clear();
        if (streamMemento != null) {
            IMemento[] componentMementos = streamMemento.getChildren(TAG_COMPONENT);
            int i = 0;
            while (i < componentMementos.length) {
                this.fModel.componentNames.add(SetupProjectAspectEditor.getAttrib(componentMementos[i], ATTR_NAME, ""));
                ++i;
            }
        }
        this.fModel.createWorkspace = (workspaceMemento = memento.getChild(TAG_WORKSPACE)) != null;
        this.fModel.workspaceName = SetupProjectAspectEditor.getAttrib(workspaceMemento, ATTR_NAME, "");
        this.fModel.workspaceDescription = SetupProjectAspectEditor.getAttrib(workspaceMemento, ATTR_DESCRIPTION, "");
        this.fModel.categories.clear();
        IMemento workitemsMemento = memento.getChild("workitems");
        if (workitemsMemento != null) {
            IMemento[] categoryMementos = workitemsMemento.getChildren(TAG_CATEGORY);
            int i = 0;
            while (i < categoryMementos.length) {
                IMemento categoryMemento = categoryMementos[i];
                Category category = new Category();
                category.path = SetupProjectAspectEditor.getAttrib(categoryMemento, ATTR_PATH, "");
                category.htmlDescription = SetupProjectAspectEditor.getAttrib(categoryMemento, "htmlDescription", "");
                this.fModel.categories.add(category);
                ++i;
            }
        }
        super.restoreState(memento);
    }

    @Override
    public boolean saveState(IMemento memento) {
        if (this.fModel.teamAreaName != null && this.fModel.teamAreaName.length() > 0) {
            IMemento teamAreaMemento = memento.createChild(TAG_TEAM_AREA);
            teamAreaMemento.putString(ATTR_NAME, this.fModel.teamAreaName);
            teamAreaMemento.putString(ATTR_DEVELOPMENT_LINE, this.fModel.developmentLineId);
        }
        if (this.fModel.createStream) {
            IMemento streamMemento = memento.createChild(TAG_STREAM);
            streamMemento.putString(ATTR_NAME, this.fModel.streamName);
            streamMemento.putString(ATTR_DESCRIPTION, SetupProjectAspectEditor.convertLineSeparators(this.fModel.streamDescription));
            for (String componentName : this.fModel.componentNames) {
                streamMemento.createChild(TAG_COMPONENT).putString(ATTR_NAME, componentName);
            }
            if (this.fModel.createWorkspace) {
                IMemento workspaceMemento = memento.createChild(TAG_WORKSPACE);
                workspaceMemento.putString(ATTR_NAME, this.fModel.workspaceName);
                workspaceMemento.putString(ATTR_DESCRIPTION, SetupProjectAspectEditor.convertLineSeparators(this.fModel.workspaceDescription));
            }
        }
        if (!this.fModel.categories.isEmpty()) {
            IMemento workitemsMemento = memento.createChild("workitems");
            for (Category category : this.fModel.categories) {
                IMemento categoryMemento = workitemsMemento.createChild(TAG_CATEGORY);
                categoryMemento.putString(ATTR_PATH, category.path);
                categoryMemento.putString("htmlDescription", SetupProjectAspectEditor.convertLineSeparators(category.htmlDescription));
            }
        }
        return super.saveState(memento);
    }

    @Override
    protected void createContents(Composite parent, FormToolkit toolkit) {
        Composite contentArea = this.createContentArea(parent, toolkit);
        this.createTeamAreaSection(contentArea, toolkit);
        this.createStreamAndWorkspaceSection(contentArea, toolkit);
        this.createCategoriesSection(contentArea, toolkit);
        this.createTemplatesHeader(contentArea, toolkit);
        this.hookModifyListeners();
    }

    private void createCategoriesSection(Composite parent, FormToolkit toolkit) {
        this.fCategoriesComposite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fCategoriesComposite);
        GridLayoutFactory.fillDefaults().spacing(0, 10).applyTo(this.fCategoriesComposite);
        this.createCategoriesHeader(this.fCategoriesComposite, toolkit);
    }

    private void createCategoriesHeader(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.fCategoryCountLabel = toolkit.createLabel(composite, "");
        this.fCategoryCountLabel.setFont(SetupProjectAspectEditor.getBoldFont());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)this.fCategoryCountLabel);
        Button newButton = toolkit.createButton(composite, Messages.SetupProjectAspectEditor_3, 8);
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SetupProjectAspectEditor.this.doNewCategory();
            }
        });
    }

    private void updateVisibility(boolean reflowIfNeeded) {
        boolean reflowNeeded = this.updateVisibility(this.fModel.createTeamArea, this.fTeamAreaDetailsComposite);
        reflowNeeded |= this.updateVisibility(this.fModel.createWorkspace, this.fWorkspaceDetailsComposite);
        if ((reflowNeeded |= this.updateVisibility(this.fModel.createStream, this.fStreamDetailsComposite)) && reflowIfNeeded) {
            this.getSite().reflow();
        }
    }

    private boolean updateVisibility(boolean makeVisible, Composite composite) {
        if (makeVisible != composite.getVisible()) {
            composite.setVisible(makeVisible);
            ((GridData)composite.getLayoutData()).exclude = !makeVisible;
            return true;
        }
        return false;
    }

    protected void createTeamAreaSection(final Composite parent, FormToolkit toolkit) {
        Label sectionLabel = toolkit.createLabel(parent, Messages.SetupProjectAspectEditor_teamArea_section);
        sectionLabel.setFont(SetupProjectAspectEditor.getBoldFont());
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)sectionLabel);
        this.fTeamAreaDetailsComposite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.fTeamAreaDetailsComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(10, 0, 0, 5).spacing(10, 5).applyTo(this.fTeamAreaDetailsComposite);
        this.fTeamAreaNameText = this.createSingleLineText(this.fTeamAreaDetailsComposite, toolkit, Messages.SetupProjectAspectEditor_teamArea_label, Messages.SetupProjectAspectEditor_teamArea_message, TEAM_AREA_NAME_VARS);
        this.fDevelopmentLineComboViewer = this.createComboViewer(this.fTeamAreaDetailsComposite, toolkit, Messages.SetupProjectAspectEditor_devLine_label);
        this.fDevelopmentLineComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fDevelopmentLineComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDevelopmentLineProxy) {
                    IDevelopmentLineProxy line = (IDevelopmentLineProxy)element;
                    return line.getName();
                }
                return super.getText(element);
            }
        });
        final Display display = parent.getDisplay();
        this.fIterationStructureChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!parent.isDisposed()) {
                            SetupProjectAspectEditor.this.updateDevelopmentLines();
                        }
                    }
                });
            }
        };
        this.fIterationStructure.addPropertyChangeListener(this.fIterationStructureChangeListener);
        this.updateDevelopmentLines();
        this.fDevelopmentLineComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                String lineId = null;
                if (sel.size() == 1) {
                    IDevelopmentLineProxy line = (IDevelopmentLineProxy)sel.getFirstElement();
                    lineId = line.getId();
                }
                if (lineId == null) {
                    lineId = "";
                }
                if (!lineId.equals(((SetupProjectAspectEditor)SetupProjectAspectEditor.this).fModel.developmentLineId)) {
                    ((SetupProjectAspectEditor)SetupProjectAspectEditor.this).fModel.developmentLineId = lineId;
                    SetupProjectAspectEditor.this.setDirty();
                }
            }
        });
    }

    private void updateDevelopmentLines() {
        IDevelopmentLineProxy[] developmentLines = this.fIterationStructure.getDevelopmentLines();
        this.fDevelopmentLineComboViewer.setInput((Object)developmentLines);
        int i = 0;
        while (i < developmentLines.length) {
            IDevelopmentLineProxy line = developmentLines[i];
            if (line.getId().equals(this.fModel.developmentLineId)) {
                this.fDevelopmentLineComboViewer.setSelection((ISelection)new StructuredSelection((Object)line));
                return;
            }
            ++i;
        }
        this.fDevelopmentLineComboViewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fIterationStructureChangeListener != null) {
            this.fIterationStructure.removePropertyChangeListener(this.fIterationStructureChangeListener);
            this.fIterationStructureChangeListener = null;
        }
    }

    protected void createStreamAndWorkspaceSection(Composite parent, FormToolkit toolkit) {
        this.fCreateStreamButton = this.createSectionCheckbox(parent, toolkit, Messages.SetupProjectAspectEditor_stream_section);
        this.fCreateStreamButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((SetupProjectAspectEditor)SetupProjectAspectEditor.this).fModel.createStream = SetupProjectAspectEditor.this.fCreateStreamButton.getSelection();
                SetupProjectAspectEditor.this.updateVisibility(true);
            }
        });
        this.fStreamDetailsComposite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fStreamDetailsComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 5).applyTo(this.fStreamDetailsComposite);
        Composite innerDetailsComposite = toolkit.createComposite(this.fStreamDetailsComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)innerDetailsComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(10, 0, 0, 5).applyTo(innerDetailsComposite);
        this.fStreamNameText = this.createSingleLineText(innerDetailsComposite, toolkit, Messages.SetupProjectAspectEditor_stream_label, Messages.SetupProjectAspectEditor_stream_message, STREAM_NAME_VARS);
        this.fStreamDescText = this.createMultiLineText(innerDetailsComposite, toolkit, Messages.SetupProjectAspectEditor_stream_desc_label, 3, STREAM_NAME_VARS);
        Label componentsLabel = toolkit.createLabel(innerDetailsComposite, Messages.SetupProjectAspectEditor_components_label);
        GridDataFactory.fillDefaults().applyTo((Control)componentsLabel);
        Composite componentsComposite = toolkit.createComposite(innerDetailsComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)componentsComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(componentsComposite);
        this.fComponentsViewer = new ListViewer(componentsComposite);
        this.fComponentsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fComponentsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fComponentsViewer.setSorter(new ViewerSorter());
        int h = this.fComponentsViewer.getList().getItemHeight() * 3;
        h = this.fComponentsViewer.getList().computeTrim((int)0, (int)0, (int)100, (int)h).height;
        GridDataFactory.fillDefaults().grab(true, false).hint(100, h).applyTo((Control)this.fComponentsViewer.getList());
        this.fComponentsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SetupProjectAspectEditor.this.handleComponentSelection((IStructuredSelection)event.getSelection());
            }
        });
        Composite buttonsComposite = toolkit.createComposite(componentsComposite);
        GridDataFactory.fillDefaults().applyTo((Control)buttonsComposite);
        GridLayoutFactory.fillDefaults().applyTo(buttonsComposite);
        this.fAddComponentButton = toolkit.createButton(buttonsComposite, Messages.SetupProjectAspectEditor_components_add, 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fAddComponentButton);
        this.fAddComponentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SetupProjectAspectEditor.this.doAddComponent();
            }
        });
        this.fRemoveComponentButton = toolkit.createButton(buttonsComposite, Messages.SetupProjectAspectEditor_components_remove, 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fRemoveComponentButton);
        this.fRemoveComponentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SetupProjectAspectEditor.this.doRemoveComponents();
            }
        });
        this.fCreateWorkspaceButton = this.createSectionCheckbox(this.fStreamDetailsComposite, toolkit, Messages.SetupProjectAspectEditor_workspace_section);
        this.fCreateWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((SetupProjectAspectEditor)SetupProjectAspectEditor.this).fModel.createWorkspace = SetupProjectAspectEditor.this.fCreateWorkspaceButton.getSelection();
                SetupProjectAspectEditor.this.updateVisibility(true);
            }
        });
        this.fWorkspaceDetailsComposite = toolkit.createComposite(this.fStreamDetailsComposite);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.fWorkspaceDetailsComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(10, 0, 0, 0).applyTo(this.fWorkspaceDetailsComposite);
        this.fWorkspaceNameText = this.createSingleLineText(this.fWorkspaceDetailsComposite, toolkit, Messages.SetupProjectAspectEditor_workspace_label, Messages.SetupProjectAspectEditor_workspace_message, WORKSPACE_NAME_VARS);
        this.fWorkspaceDescText = this.createMultiLineText(this.fWorkspaceDetailsComposite, toolkit, Messages.SetupProjectAspectEditor_workspace_desc, 3, WORKSPACE_NAME_VARS);
        this.updateComponentButtonsEnablement((IStructuredSelection)StructuredSelection.EMPTY);
    }

    protected void doAddComponent() {
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText.length() == 0) {
                    return "";
                }
                return null;
            }
        };
        InputDialogWithVars inputDialog = new InputDialogWithVars(this.fComponentsViewer.getList().getShell(), Messages.SetupProjectAspectEditor_add_component_title, Messages.SetupProjectAspectEditor_add_component_message, Messages.SetupProjectAspectEditor_add_component_default, validator, VARS_TOOLTIP, WORKSPACE_NAME_VARS);
        if (inputDialog.open() == 0) {
            String componentName = inputDialog.getValue();
            this.fModel.componentNames.add(componentName);
            this.fComponentsViewer.refresh();
            this.fComponentsViewer.setSelection((ISelection)new StructuredSelection((Object)componentName));
            this.setDirty();
        }
    }

    protected void doRemoveComponents() {
        IStructuredSelection selection = (IStructuredSelection)this.fComponentsViewer.getSelection();
        this.fModel.componentNames.removeAll(selection.toList());
        this.fComponentsViewer.refresh();
        this.setDirty();
    }

    private void handleComponentSelection(IStructuredSelection selection) {
        this.updateComponentButtonsEnablement(selection);
    }

    private void updateComponentButtonsEnablement(IStructuredSelection selection) {
        this.fRemoveComponentButton.setEnabled(!selection.isEmpty());
    }

    private SectionCheckbox createSectionCheckbox(Composite parent, FormToolkit toolkit, String text) {
        return new SectionCheckbox(parent, toolkit, text);
    }

    private Text createMultiLineText(Composite parent, FormToolkit toolkit, String labelText, int numLines, String[][] vars) {
        Composite composite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Label label = toolkit.createLabel(composite, labelText);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)label);
        Text text = toolkit.createText(composite, "", 2626);
        int h = text.getLineHeight() * numLines;
        h = text.computeTrim((int)0, (int)0, (int)150, (int)h).height;
        GridDataFactory.fillDefaults().grab(true, false).span(vars == null ? 2 : 1, 1).hint(100, h).applyTo((Control)text);
        if (vars != null) {
            this.createVarsButton(composite, text, toolkit, vars);
        }
        return text;
    }

    private Text createSingleLineText(Composite parent, FormToolkit toolkit, String labelText, String message, String[][] vars) {
        Composite composite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(vars == null ? 2 : 3).applyTo(composite);
        Label label = toolkit.createLabel(composite, labelText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)label);
        Text text = toolkit.createText(composite, "", (message == null ? 4 : 128) | 0x800);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(100, -1).applyTo((Control)text);
        if (message != null) {
            text.setMessage(message);
        }
        if (vars != null) {
            this.createVarsButton(composite, text, toolkit, vars);
        }
        return text;
    }

    private ComboViewer createComboViewer(Composite parent, FormToolkit toolkit, String labelText) {
        Composite composite = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Label label = toolkit.createLabel(composite, labelText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)label);
        ComboViewer comboViewer = new ComboViewer(composite);
        toolkit.adapt((Control)comboViewer.getCombo(), true, false);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).applyTo((Control)comboViewer.getCombo());
        return comboViewer;
    }

    private void hookModifyListeners() {
        this.fTeamAreaNameText.addModifyListener(this.fModifyListener);
        this.fStreamNameText.addModifyListener(this.fModifyListener);
        this.fStreamDescText.addModifyListener(this.fModifyListener);
        this.fWorkspaceNameText.addModifyListener(this.fModifyListener);
        this.fWorkspaceDescText.addModifyListener(this.fModifyListener);
    }

    private void unhookModifyListeners() {
        this.fTeamAreaNameText.removeModifyListener(this.fModifyListener);
        this.fStreamNameText.removeModifyListener(this.fModifyListener);
        this.fStreamDescText.removeModifyListener(this.fModifyListener);
        this.fWorkspaceNameText.removeModifyListener(this.fModifyListener);
        this.fWorkspaceDescText.removeModifyListener(this.fModifyListener);
    }

    @Override
    protected void updateUI() {
        this.fCreateStreamButton.setSelection(this.fModel.createStream);
        this.fCreateWorkspaceButton.setSelection(this.fModel.createWorkspace);
        this.fComponentsViewer.setInput((Object)this.fModel.componentNames);
        this.unhookModifyListeners();
        this.fTeamAreaNameText.setText(this.fModel.teamAreaName);
        this.fStreamDescText.setText(this.fModel.streamDescription);
        this.fStreamNameText.setText(this.fModel.streamName);
        this.fStreamDescText.setText(this.fModel.streamDescription);
        this.fWorkspaceNameText.setText(this.fModel.workspaceName);
        this.fWorkspaceDescText.setText(this.fModel.workspaceDescription);
        this.hookModifyListeners();
        this.updateVisibility(false);
        this.disposeCategoryForms();
        this.createCategoryForms();
        this.updateCategoryCount();
        super.updateUI();
    }

    private void updateCategoryCount() {
        this.fCategoryCountLabel.setText(NLS.bind((String)Messages.SetupProjectAspectEditor_4, (Object)Integer.toString(this.fModel.categories.size())));
    }

    private void createCategoryForms() {
        int index = 0;
        for (Category category : this.fModel.categories) {
            this.fCategoryForms.add(new CategoryForm(category, this.fCategoriesComposite, this.fToolkit, index++));
        }
    }

    private void disposeCategoryForms() {
        for (CategoryForm form : this.fCategoryForms) {
            form.dispose();
        }
        this.fCategoryForms.clear();
    }

    private void doNewCategory() {
        Category category = new Category();
        category.path = Messages.SetupProjectAspectEditor_5;
        category.htmlDescription = Messages.AcceptTeamInvitationAspectEditor_8;
        CategoryForm form = new CategoryForm(category, this.fCategoriesComposite, this.fToolkit, this.fModel.categories.size());
        this.fModel.categories.add(category);
        this.fCategoryForms.add(form);
        this.updateCategoryCount();
        this.setDirty();
        this.getContentArea().layout();
        this.getSite().reflow();
        form.activate();
    }

    private void doDeleteCategory(Category category, CategoryForm form) {
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.AcceptTeamInvitationAspectEditor_9, (String)NLS.bind((String)Messages.SetupProjectAspectEditor_6, (Object)category.path))) {
            form.dispose();
            this.fModel.categories.remove(category);
            this.fCategoryForms.remove(form);
            this.updateCategoryCount();
            this.updateCategoryIndices();
            this.setDirty();
            this.getSite().reflow();
        }
    }

    private void updateCategoryIndices() {
        int index = 0;
        for (CategoryForm form : this.fCategoryForms) {
            form.setIndex(index++);
        }
    }

    static class Category {
        String path = "";
        String htmlDescription = "";

        Category() {
        }
    }

    class CategoryForm {
        private Category fCategory;
        private Composite fComposite;
        private Label fPathLabel;
        private Text fPathText;
        private Text fDescriptionText;

        CategoryForm(final Category category, Composite parent, FormToolkit toolkit, int index) {
            this.fCategory = category;
            this.fComposite = toolkit.createComposite(parent);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fComposite);
            GridLayoutFactory.fillDefaults().applyTo(this.fComposite);
            if (index != 0) {
                Label separator = toolkit.createLabel(this.fComposite, "", 258);
                GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)separator);
            }
            Composite pathComposite = toolkit.createComposite(this.fComposite);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)pathComposite);
            GridLayoutFactory.fillDefaults().numColumns(4).applyTo(pathComposite);
            this.fPathLabel = toolkit.createLabel(pathComposite, "");
            GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.fPathLabel);
            this.fPathText = toolkit.createText(pathComposite, category.path, 2180);
            this.fPathText.setMessage(Messages.SetupProjectAspectEditor_0);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(150, -1).applyTo((Control)this.fPathText);
            SetupProjectAspectEditor.this.createVarsButton(pathComposite, this.fPathText, toolkit, CATEGORY_PATH_VARS);
            ToolBar toolbar = new ToolBar(pathComposite, 0);
            toolkit.adapt((Control)toolbar, true, false);
            ToolItem deleteItem = new ToolItem(toolbar, 0);
            deleteItem.setImage(JazzResources.getImageWithDefault((ResourceManager)SetupProjectAspectEditor.this.fResourceManager, (ImageDescriptor)DELETE_IMAGE_DESCRIPTOR));
            deleteItem.setToolTipText(Messages.SetupProjectAspectEditor_1);
            GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)toolbar);
            deleteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SetupProjectAspectEditor.this.doDeleteCategory(category, CategoryForm.this);
                }
            });
            Composite descriptionComposite = toolkit.createComposite(this.fComposite);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)descriptionComposite);
            GridLayoutFactory.fillDefaults().applyTo(descriptionComposite);
            Label descriptionLabel = toolkit.createLabel(descriptionComposite, Messages.AcceptTeamInvitationAspectEditor_1);
            GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)descriptionLabel);
            this.fDescriptionText = toolkit.createText(descriptionComposite, category.htmlDescription, 2626);
            int h = this.fDescriptionText.getLineHeight() * 3;
            h = this.fDescriptionText.computeTrim((int)0, (int)0, (int)100, (int)h).height;
            GridDataFactory.fillDefaults().grab(true, false).hint(150, h).applyTo((Control)this.fDescriptionText);
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (e.widget == CategoryForm.this.fPathText) {
                        ((CategoryForm)CategoryForm.this).fCategory.path = CategoryForm.this.fPathText.getText();
                        SetupProjectAspectEditor.this.setDirty();
                    } else if (e.widget == CategoryForm.this.fDescriptionText) {
                        ((CategoryForm)CategoryForm.this).fCategory.htmlDescription = CategoryForm.this.fDescriptionText.getText();
                        SetupProjectAspectEditor.this.setDirty();
                    }
                }
            };
            this.fPathText.addModifyListener(modifyListener);
            this.fDescriptionText.addModifyListener(modifyListener);
            this.setIndex(index);
        }

        void setIndex(int index) {
            this.fPathLabel.setText(NLS.bind((String)Messages.SetupProjectAspectEditor_2, (Object)Integer.toString(index + 1)));
        }

        void dispose() {
            this.fComposite.dispose();
        }

        public void activate() {
            this.fDescriptionText.setFocus();
            this.fPathText.setFocus();
            this.fPathText.selectAll();
        }
    }

    static class Model {
        protected boolean createTeamArea = true;
        String teamAreaName = "";
        String developmentLineId = "";
        boolean createStream = true;
        String streamName = "";
        String streamDescription = "";
        List componentNames = new ArrayList();
        boolean createWorkspace = true;
        String workspaceName = "";
        String workspaceDescription = "";
        List categories = new ArrayList();

        Model() {
        }
    }

    static class SectionCheckbox {
        private String fText;
        private Button fButton;
        private Label fLabel;

        SectionCheckbox(Composite parent, FormToolkit toolkit, String text) {
            this.fText = text;
            Composite composite = toolkit.createComposite(parent);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
            GridLayoutFactory.fillDefaults().numColumns(2).spacing(3, 0).applyTo(composite);
            this.fButton = toolkit.createButton(composite, "", 32);
            this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.updateLabel();
                }
            });
            this.fLabel = toolkit.createLabel(composite, text);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fLabel);
            this.fLabel.setFont(SetupProjectAspectEditor.getBoldFont());
        }

        public boolean getSelection() {
            return this.fButton.getSelection();
        }

        public void addSelectionListener(SelectionListener listener) {
            this.fButton.addSelectionListener(listener);
        }

        public void setSelection(boolean selection) {
            this.fButton.setSelection(selection);
            this.updateLabel();
        }

        private void updateLabel() {
            this.fLabel.setText(this.fButton.getSelection() ? NLS.bind((String)Messages.SetupProjectAspectEditor_checkBoxSectionFmt, (Object)this.fText) : this.fText);
        }
    }
}

